/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerContributionTest
extends ModelReconcilerTest {
    private void testContribution_PersistedState(String applicationState, String userChange, String newApplicationState) {
        MApplication application = this.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        part.setPersistedState(applicationState);
        window.getChildren().add((Object)part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setPersistedState(userChange);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        part.setPersistedState(newApplicationState);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerContributionTest.assertEquals((String)newApplicationState, (String)part.getPersistedState());
        this.applyAll(deltas);
        if (applicationState == null) {
            if (userChange == null) {
                ModelReconcilerContributionTest.assertEquals((String)newApplicationState, (String)part.getPersistedState());
            } else {
                ModelReconcilerContributionTest.assertEquals((String)userChange, (String)part.getPersistedState());
            }
        } else if (userChange == null || !applicationState.equals(userChange)) {
            ModelReconcilerContributionTest.assertEquals((String)userChange, (String)part.getPersistedState());
        } else {
            ModelReconcilerContributionTest.assertEquals((String)newApplicationState, (String)part.getPersistedState());
        }
    }

    public void testContribution_PersistedState_NullNullNull() {
        this.testContribution_PersistedState(null, null, null);
    }

    public void testContribution_PersistedState_NullNullEmpty() {
        this.testContribution_PersistedState(null, null, "");
    }

    public void testContribution_PersistedState_NullNullString() {
        this.testContribution_PersistedState(null, null, "state");
    }

    public void testContribution_PersistedState_NullEmptyNull() {
        this.testContribution_PersistedState(null, "", null);
    }

    public void testContribution_PersistedState_NullEmptyEmpty() {
        this.testContribution_PersistedState(null, "", "");
    }

    public void testContribution_PersistedState_NullEmptyString() {
        this.testContribution_PersistedState(null, "", "state");
    }

    public void testContribution_PersistedState_NullStringNull() {
        this.testContribution_PersistedState(null, "state", null);
    }

    public void testContribution_PersistedState_NullStringEmpty() {
        this.testContribution_PersistedState(null, "state", "");
    }

    public void testContribution_PersistedState_NullStringString() {
        this.testContribution_PersistedState(null, "state", "state");
    }

    public void testContribution_PersistedState_NullStringString2() {
        this.testContribution_PersistedState(null, "state", "state2");
    }

    public void testContribution_PersistedState_EmptyNullNull() {
        this.testContribution_PersistedState("", null, null);
    }

    public void testContribution_PersistedState_EmptyNullEmpty() {
        this.testContribution_PersistedState("", null, "");
    }

    public void testContribution_PersistedState_EmptyNullString() {
        this.testContribution_PersistedState("", null, "state");
    }

    public void testContribution_PersistedState_EmptyEmptyNull() {
        this.testContribution_PersistedState("", "", null);
    }

    public void testContribution_PersistedState_EmptyEmptyEmpty() {
        this.testContribution_PersistedState("", "", "");
    }

    public void testContribution_PersistedState_EmptyEmptyString() {
        this.testContribution_PersistedState("", "", "state");
    }

    public void testContribution_PersistedState_EmptyStringNull() {
        this.testContribution_PersistedState("", "state", null);
    }

    public void testContribution_PersistedState_EmptyStringEmpty() {
        this.testContribution_PersistedState("", "state", "");
    }

    public void testContribution_PersistedState_EmptyStringString() {
        this.testContribution_PersistedState("", "state", "state");
    }

    public void testContribution_PersistedState_EmptyStringString2() {
        this.testContribution_PersistedState("", "state", "state2");
    }

    public void testContribution_PersistedState_StringNullNull() {
        this.testContribution_PersistedState("state", null, null);
    }

    public void testContribution_PersistedState_StringNullEmpty() {
        this.testContribution_PersistedState("state", null, "");
    }

    public void testContribution_PersistedState_StringNullString() {
        this.testContribution_PersistedState("state", null, "state");
    }

    public void testContribution_PersistedState_StringNullString2() {
        this.testContribution_PersistedState("state", null, "state2");
    }

    public void testContribution_PersistedState_StringEmptyNull() {
        this.testContribution_PersistedState("state", "", null);
    }

    public void testContribution_PersistedState_StringEmptyEmpty() {
        this.testContribution_PersistedState("state", "", "");
    }

    public void testContribution_PersistedState_StringEmptyString() {
        this.testContribution_PersistedState("state", "", "state");
    }

    public void testContribution_PersistedState_StringEmptyString2() {
        this.testContribution_PersistedState("state", "", "state2");
    }

    public void testContribution_PersistedState_StringStringNull() {
        this.testContribution_PersistedState("state", "state", null);
    }

    public void testContribution_PersistedState_StringString2Null() {
        this.testContribution_PersistedState("state", "state2", null);
    }

    public void testContribution_PersistedState_StringStringEmpty() {
        this.testContribution_PersistedState("state", "state", "");
    }

    public void testContribution_PersistedState_StringString2Empty() {
        this.testContribution_PersistedState("state", "state2", "");
    }

    public void testContribution_PersistedState_StringStringString() {
        this.testContribution_PersistedState("state", "state", "state");
    }

    public void testContribution_PersistedState_StringStringString2() {
        this.testContribution_PersistedState("state", "state", "state2");
    }

    public void testContribution_PersistedState_StringString2String() {
        this.testContribution_PersistedState("state", "state2", "state");
    }

    public void testContribution_PersistedState_StringString2String2() {
        this.testContribution_PersistedState("state", "state2", "state2");
    }

    private void testContribution_URI(String applicationURI, String userChange, String newApplicationURI) {
        MApplication application = this.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        part.setURI(applicationURI);
        window.getChildren().add((Object)part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setURI(userChange);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        part.setURI(newApplicationURI);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerContributionTest.assertEquals((String)newApplicationURI, (String)part.getURI());
        this.applyAll(deltas);
        if (applicationURI == null) {
            if (userChange == null) {
                ModelReconcilerContributionTest.assertEquals((String)newApplicationURI, (String)part.getURI());
            } else {
                ModelReconcilerContributionTest.assertEquals((String)userChange, (String)part.getURI());
            }
        } else if (userChange == null || !applicationURI.equals(userChange)) {
            ModelReconcilerContributionTest.assertEquals((String)userChange, (String)part.getURI());
        } else {
            ModelReconcilerContributionTest.assertEquals((String)newApplicationURI, (String)part.getURI());
        }
    }

    public void testContribution_URI_NullNullNull() {
        this.testContribution_URI(null, null, null);
    }

    public void testContribution_URI_NullNullEmpty() {
        this.testContribution_URI(null, null, "");
    }

    public void testContribution_URI_NullNullString() {
        this.testContribution_URI(null, null, "uri");
    }

    public void testContribution_URI_NullEmptyNull() {
        this.testContribution_URI(null, "", null);
    }

    public void testContribution_URI_NullEmptyEmpty() {
        this.testContribution_URI(null, "", "");
    }

    public void testContribution_URI_NullEmptyString() {
        this.testContribution_URI(null, "", "uri");
    }

    public void testContribution_URI_NullStringNull() {
        this.testContribution_URI(null, "uri", null);
    }

    public void testContribution_URI_NullStringEmpty() {
        this.testContribution_URI(null, "uri", "");
    }

    public void testContribution_URI_NullStringString() {
        this.testContribution_URI(null, "uri", "uri");
    }

    public void testContribution_URI_NullStringString2() {
        this.testContribution_URI(null, "uri", "uri2");
    }

    public void testContribution_URI_EmptyNullNull() {
        this.testContribution_URI("", null, null);
    }

    public void testContribution_URI_EmptyNullEmpty() {
        this.testContribution_URI("", null, "");
    }

    public void testContribution_URI_EmptyNullString() {
        this.testContribution_URI("", null, "uri");
    }

    public void testContribution_URI_EmptyEmptyNull() {
        this.testContribution_URI("", "", null);
    }

    public void testContribution_URI_EmptyEmptyEmpty() {
        this.testContribution_URI("", "", "");
    }

    public void testContribution_URI_EmptyEmptyString() {
        this.testContribution_URI("", "", "uri");
    }

    public void testContribution_URI_EmptyStringNull() {
        this.testContribution_URI("", "uri", null);
    }

    public void testContribution_URI_EmptyStringEmpty() {
        this.testContribution_URI("", "uri", "");
    }

    public void testContribution_URI_EmptyStringString() {
        this.testContribution_URI("", "uri", "uri");
    }

    public void testContribution_URI_EmptyStringString2() {
        this.testContribution_URI("", "uri", "uri2");
    }

    public void testContribution_URI_StringNullNull() {
        this.testContribution_URI("uri", null, null);
    }

    public void testContribution_URI_StringNullEmpty() {
        this.testContribution_URI("uri", null, "");
    }

    public void testContribution_URI_StringNullString() {
        this.testContribution_URI("uri", null, "uri");
    }

    public void testContribution_URI_StringNullString2() {
        this.testContribution_URI("uri", null, "uri2");
    }

    public void testContribution_URI_StringEmptyNull() {
        this.testContribution_URI("uri", "", null);
    }

    public void testContribution_URI_StringEmptyEmpty() {
        this.testContribution_URI("uri", "", "");
    }

    public void testContribution_URI_StringEmptyString() {
        this.testContribution_URI("uri", "", "uri");
    }

    public void testContribution_URI_StringEmptyString2() {
        this.testContribution_URI("uri", "", "uri2");
    }

    public void testContribution_URI_StringStringNull() {
        this.testContribution_URI("uri", "uri", null);
    }

    public void testContribution_URI_StringString2Null() {
        this.testContribution_URI("uri", "uri2", null);
    }

    public void testContribution_URI_StringStringEmpty() {
        this.testContribution_URI("uri", "uri", "");
    }

    public void testContribution_URI_StringString2Empty() {
        this.testContribution_URI("uri", "uri2", "");
    }

    public void testContribution_URI_StringStringString() {
        this.testContribution_URI("uri", "uri", "uri");
    }

    public void testContribution_URI_StringStringString2() {
        this.testContribution_URI("uri", "uri", "uri2");
    }

    public void testContribution_URI_StringString2String() {
        this.testContribution_URI("uri", "uri2", "uri");
    }

    public void testContribution_URI_StringString2String2() {
        this.testContribution_URI("uri", "uri2", "uri2");
    }
}

