/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartDescriptor;
import org.eclipse.e4.ui.model.application.MPartSashContainer;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MPerspective;
import org.eclipse.e4.ui.model.application.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.MToolBar;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.model.application.MWindowTrim;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;
import org.eclipse.emf.common.util.EList;

public abstract class ModelReconcilerElementContainerTest
extends ModelReconcilerTest {
    public void testElementContainer_Children_Add() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        part.setLabel("newPart");
        window.getChildren().add((Object)part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        part = (MPart)window.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((String)"newPart", (String)part.getLabel());
    }

    public void testElementContainer_Children_Add2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part = MApplicationFactory.eINSTANCE.createPart();
        part.setLabel("newPart");
        window.getChildren().add((Object)part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part, (Object)window.getChildren().get(0));
        part = (MPart)window.getChildren().get(0);
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part, (Object)window.getChildren().get(0));
        part = (MPart)window.getChildren().get(1);
        ModelReconcilerElementContainerTest.assertEquals((String)"newPart", (String)part.getLabel());
    }

    public void testElementContainer_Children_Add3() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        part.setLabel("newPart");
        stack.getChildren().add((Object)part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack = (MPartStack)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)stack.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)stack.getChildren().size());
        part = (MPart)stack.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((String)"newPart", (String)part.getLabel());
    }

    public void testElementContainer_Children_Add4() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPart editor = MApplicationFactory.eINSTANCE.createPart();
        editor.setLabel("newEditor");
        window.getChildren().add((Object)editor);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        editor = (MPart)window.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((String)"newEditor", (String)editor.getLabel());
    }

    public void testElementContainer_Children_Add5() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPerspective perspective = MApplicationFactory.eINSTANCE.createPerspective();
        perspective.setLabel("newEditor");
        window.getChildren().add((Object)perspective);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        perspective = (MPerspective)window.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((String)"newEditor", (String)perspective.getLabel());
    }

    public void testElementContainer_Children_Add6() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPerspectiveStack perspectiveStack = MApplicationFactory.eINSTANCE.createPerspectiveStack();
        window.getChildren().add((Object)perspectiveStack);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(window.getChildren().get(0) instanceof MPerspectiveStack));
    }

    public void testElementContainer_Children_Add7() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartDescriptor part = MApplicationFactory.eINSTANCE.createPartDescriptor();
        window.getChildren().add((Object)part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(window.getChildren().get(0) instanceof MPartDescriptor));
    }

    public void testElementContainer_Children_Remove() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part, (Object)window.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
    }

    public void testElementContainer_Children_Remove2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)part1);
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part1 = (MPart)window.getChildren().get(0);
        part2 = (MPart)window.getChildren().get(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, (Object)window.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, (Object)window.getChildren().get(1));
        part2 = (MPart)window.getChildren().get(1);
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, (Object)window.getChildren().get(0));
    }

    public void testElementContainer_Children_Remove3() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        stack.getChildren().add((Object)part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack = (MPartStack)window.getChildren().get(0);
        part = (MPart)stack.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)stack.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part, (Object)stack.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)stack.getChildren().size());
    }

    public void testElementContainer_Children_Remove4() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        stack.getChildren().add((Object)part1);
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        stack.getChildren().add((Object)part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)stack.getChildren().get(0);
        part2 = (MPart)stack.getChildren().get(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)stack.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, (Object)stack.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, (Object)stack.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)stack.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, (Object)stack.getChildren().get(0));
    }

    public void testElementContainer_Children_MovedFromOneStackToAnother() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack1 = MApplicationFactory.eINSTANCE.createPartStack();
        MPartStack stack2 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack1);
        window.getChildren().add((Object)stack2);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        stack1.getChildren().add((Object)part1);
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        stack2.getChildren().add((Object)part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack1.getChildren().remove((Object)part1);
        stack2.getChildren().add((Object)part1);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack1 = (MPartStack)window.getChildren().get(0);
        stack2 = (MPartStack)window.getChildren().get(1);
        part1 = (MPart)stack1.getChildren().get(0);
        part2 = (MPart)stack2.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)stack1.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, (Object)stack1.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)stack2.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, (Object)stack2.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)stack1.getChildren().size());
        EList stack2Children = stack2.getChildren();
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)stack2Children.size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)stack2Children.contains(part1));
        ModelReconcilerElementContainerTest.assertTrue((boolean)stack2Children.contains(part2));
    }

    public void testElementContainer_Children_Repositioned() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        stack.getChildren().add((Object)part1);
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        stack.getChildren().add((Object)part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack.getChildren().move(0, 1);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)stack.getChildren().get(0);
        part2 = (MPart)stack.getChildren().get(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)stack.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, (Object)stack.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, (Object)stack.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)stack.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, (Object)stack.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, (Object)stack.getChildren().get(1));
    }

    public void testElementContainer_Children_Add_Multiple() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartSashContainer partSashContainer = MApplicationFactory.eINSTANCE.createPartSashContainer();
        window.getChildren().add((Object)partSashContainer);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        partSashContainer.getChildren().add((Object)part);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(window.getChildren().get(0) instanceof MPartSashContainer));
        partSashContainer = (MPartSashContainer)window.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)partSashContainer.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(partSashContainer.getChildren().get(0) instanceof MPart));
    }

    public void testElementContainer_Children_Add_PartSashContainer() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartSashContainer partSashContainer1 = MApplicationFactory.eINSTANCE.createPartSashContainer();
        window.getChildren().add((Object)partSashContainer1);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        partSashContainer1.getChildren().add((Object)part1);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartSashContainer partSashContainer2 = MApplicationFactory.eINSTANCE.createPartSashContainer();
        window.getChildren().add((Object)partSashContainer2);
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        partSashContainer2.getChildren().add((Object)part2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partSashContainer1 = (MPartSashContainer)window.getChildren().get(0);
        part1 = (MPart)partSashContainer1.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)partSashContainer1, (Object)window.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)partSashContainer1.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, (Object)partSashContainer1.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)partSashContainer1, (Object)window.getChildren().get(0));
        partSashContainer2 = (MPartSashContainer)window.getChildren().get(1);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)partSashContainer1.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, (Object)partSashContainer1.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)partSashContainer2.getChildren().size());
        ModelReconcilerElementContainerTest.assertNotNull((Object)partSashContainer2.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertTrue((boolean)(partSashContainer2.getChildren().get(0) instanceof MPart));
    }

    public void testElementContainer_Children_Add_WindowTrim() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MWindowTrim windowTrim = MApplicationFactory.eINSTANCE.createWindowTrim();
        window.getChildren().add((Object)windowTrim);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertNotNull((Object)window.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertTrue((boolean)(window.getChildren().get(0) instanceof MWindowTrim));
    }

    public void testElementContainer_Children_Remove_WindowTrim() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MWindowTrim windowTrim = MApplicationFactory.eINSTANCE.createWindowTrim();
        window.getChildren().add((Object)windowTrim);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        windowTrim = (MWindowTrim)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)windowTrim, (Object)window.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
    }

    public void testElementContainer_Children_Add_ToolBar() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MWindowTrim windowTrim = MApplicationFactory.eINSTANCE.createWindowTrim();
        window.getChildren().add((Object)windowTrim);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MToolBar toolBar = MApplicationFactory.eINSTANCE.createToolBar();
        windowTrim.getChildren().add((Object)toolBar);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        windowTrim = (MWindowTrim)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)windowTrim, (Object)window.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)windowTrim.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)windowTrim, (Object)window.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)windowTrim.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(windowTrim.getChildren().get(0) instanceof MToolBar));
    }

    public void testElementContainer_Children_Remove_ToolBar() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MWindowTrim windowTrim = MApplicationFactory.eINSTANCE.createWindowTrim();
        window.getChildren().add((Object)windowTrim);
        MToolBar toolBar = MApplicationFactory.eINSTANCE.createToolBar();
        windowTrim.getChildren().add((Object)toolBar);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        windowTrim.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        windowTrim = (MWindowTrim)window.getChildren().get(0);
        toolBar = (MToolBar)windowTrim.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)windowTrim, (Object)window.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)windowTrim.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)toolBar, (Object)windowTrim.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)toolBar.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)windowTrim, (Object)window.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)windowTrim.getChildren().size());
    }

    public void testElementContainer_Children_SwitchParent_ToolBar() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MWindowTrim windowTrim1 = MApplicationFactory.eINSTANCE.createWindowTrim();
        window.getChildren().add((Object)windowTrim1);
        MWindowTrim windowTrim2 = MApplicationFactory.eINSTANCE.createWindowTrim();
        window.getChildren().add((Object)windowTrim2);
        MToolBar toolBar = MApplicationFactory.eINSTANCE.createToolBar();
        windowTrim1.getChildren().add((Object)toolBar);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        windowTrim2.getChildren().add((Object)((MUIElement)windowTrim1.getChildren().remove(0)));
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        windowTrim1 = (MWindowTrim)window.getChildren().get(0);
        windowTrim2 = (MWindowTrim)window.getChildren().get(1);
        toolBar = (MToolBar)windowTrim1.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)windowTrim1, (Object)window.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((Object)windowTrim2, (Object)window.getChildren().get(1));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)windowTrim1.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)toolBar, (Object)windowTrim1.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)windowTrim2.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)toolBar.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)windowTrim1, (Object)window.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((Object)windowTrim2, (Object)window.getChildren().get(1));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)windowTrim1.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)windowTrim2.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)toolBar, (Object)windowTrim2.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)toolBar.getChildren().size());
    }

    public void testElementContainer_ActiveChild() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        stack.getChildren().add((Object)part1);
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        stack.getChildren().add((Object)part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack.setSelectedElement((MUIElement)part1);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)stack.getChildren().get(0);
        part2 = (MPart)stack.getChildren().get(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertNull((Object)stack.getSelectedElement());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, (Object)stack.getSelectedElement());
    }

    public void testElementContainer_ActiveChild2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        stack.getChildren().add((Object)part1);
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        stack.getChildren().add((Object)part2);
        stack.setSelectedElement((MUIElement)part1);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack.setSelectedElement((MUIElement)part2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)stack.getChildren().get(0);
        part2 = (MPart)stack.getChildren().get(1);
        stack.setSelectedElement((MUIElement)part1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((Object)part1, (Object)stack.getSelectedElement());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((Object)part2, (Object)stack.getSelectedElement());
    }

    private void testElementContainer_ActiveChild3(boolean setActiveChildFirst) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartSashContainer partSashContainer = MApplicationFactory.eINSTANCE.createPartSashContainer();
        window.getChildren().add((Object)partSashContainer);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        if (setActiveChildFirst) {
            partSashContainer.setSelectedElement((MUIElement)part);
            partSashContainer.getChildren().add((Object)part);
        } else {
            partSashContainer.getChildren().add((Object)part);
            partSashContainer.setSelectedElement((MUIElement)part);
        }
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerElementContainerTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(window.getChildren().get(0) instanceof MPartSashContainer));
        partSashContainer = (MPartSashContainer)window.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((int)1, (int)partSashContainer.getChildren().size());
        ModelReconcilerElementContainerTest.assertTrue((boolean)(partSashContainer.getChildren().get(0) instanceof MPart));
        part = (MPart)partSashContainer.getChildren().get(0);
        ModelReconcilerElementContainerTest.assertEquals((Object)part, (Object)partSashContainer.getSelectedElement());
    }

    public void testElementContainer_ActiveChild3_True() {
        this.testElementContainer_ActiveChild3(true);
    }

    public void testElementContainer_ActiveChild3_False() {
        this.testElementContainer_ActiveChild3(false);
    }
}

