/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.ItemType;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MMenuItem;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerItemTest
extends ModelReconcilerTest {
    private void testItem_Enabled(boolean applicationState, boolean userChange, boolean newApplicationState) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MApplicationFactory.eINSTANCE.createMenu();
        MMenuItem item = MApplicationFactory.eINSTANCE.createMenuItem();
        menu.getChildren().add((Object)item);
        window.setMainMenu(menu);
        item.setEnabled(applicationState);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        item.setEnabled(userChange);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        item = (MMenuItem)menu.getChildren().get(0);
        item.setEnabled(newApplicationState);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerItemTest.assertEquals((boolean)newApplicationState, (boolean)item.isEnabled());
        this.applyAll(deltas);
        if (userChange == applicationState) {
            ModelReconcilerItemTest.assertEquals((boolean)newApplicationState, (boolean)item.isEnabled());
        } else {
            ModelReconcilerItemTest.assertEquals((boolean)userChange, (boolean)item.isEnabled());
        }
    }

    public void testItem_Enabled_TrueTrueTrue() {
        this.testItem_Enabled(true, true, true);
    }

    public void testItem_Enabled_TrueTrueFalse() {
        this.testItem_Enabled(true, true, false);
    }

    public void testItem_Enabled_TrueFalseTrue() {
        this.testItem_Enabled(true, false, true);
    }

    public void testItem_Enabled_TrueFalseFalse() {
        this.testItem_Enabled(true, false, false);
    }

    public void testItem_Enabled_FalseTrueTrue() {
        this.testItem_Enabled(false, true, true);
    }

    public void testItem_Enabled_FalseTrueFalse() {
        this.testItem_Enabled(false, true, false);
    }

    public void testItem_Enabled_FalseFalseTrue() {
        this.testItem_Enabled(false, false, true);
    }

    public void testItem_Enabled_FalseFalseFalse() {
        this.testItem_Enabled(false, false, false);
    }

    private void testItem_Selected(boolean applicationState, boolean userChange, boolean newApplicationState) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MApplicationFactory.eINSTANCE.createMenu();
        MMenuItem item = MApplicationFactory.eINSTANCE.createMenuItem();
        menu.getChildren().add((Object)item);
        window.setMainMenu(menu);
        item.setSelected(applicationState);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        item.setSelected(userChange);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        item = (MMenuItem)menu.getChildren().get(0);
        menu.getChildren().add((Object)item);
        window.setMainMenu(menu);
        item.setSelected(newApplicationState);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerItemTest.assertEquals((boolean)newApplicationState, (boolean)item.isSelected());
        this.applyAll(deltas);
        if (userChange == applicationState) {
            ModelReconcilerItemTest.assertEquals((boolean)newApplicationState, (boolean)item.isSelected());
        } else {
            ModelReconcilerItemTest.assertEquals((boolean)userChange, (boolean)item.isSelected());
        }
    }

    public void testItem_Selected_TrueTrueTrue() {
        this.testItem_Selected(true, true, true);
    }

    public void testItem_Selected_TrueTrueFalse() {
        this.testItem_Selected(true, true, false);
    }

    public void testItem_Selected_TrueFalseTrue() {
        this.testItem_Selected(true, false, true);
    }

    public void testItem_Selected_TrueFalseFalse() {
        this.testItem_Selected(true, false, false);
    }

    public void testItem_Selected_FalseTrueTrue() {
        this.testItem_Selected(false, true, true);
    }

    public void testItem_Selected_FalseTrueFalse() {
        this.testItem_Selected(false, true, false);
    }

    public void testItem_Selected_FalseFalseTrue() {
        this.testItem_Selected(false, false, true);
    }

    public void testItem_Selected_FalseFalseFalse() {
        this.testItem_Selected(false, false, false);
    }

    private void testItem_Type(ItemType applicationState, ItemType userChange, ItemType newApplicationState) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MApplicationFactory.eINSTANCE.createMenu();
        MMenuItem item = MApplicationFactory.eINSTANCE.createMenuItem();
        menu.getChildren().add((Object)item);
        window.setMainMenu(menu);
        item.setType(applicationState);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        item.setType(userChange);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        item = (MMenuItem)menu.getChildren().get(0);
        item.setType(newApplicationState);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerItemTest.assertEquals((Object)newApplicationState, (Object)item.getType());
        this.applyAll(deltas);
        if (userChange == applicationState) {
            ModelReconcilerItemTest.assertEquals((Object)newApplicationState, (Object)item.getType());
        } else {
            ModelReconcilerItemTest.assertEquals((Object)userChange, (Object)item.getType());
        }
    }

    public void testItem_Type_PushPushPush() {
        this.testItem_Type(ItemType.PUSH, ItemType.PUSH, ItemType.PUSH);
    }

    public void testItem_Type_PushPushCheck() {
        this.testItem_Type(ItemType.PUSH, ItemType.PUSH, ItemType.CHECK);
    }

    public void testItem_Type_PushCheckPush() {
        this.testItem_Type(ItemType.PUSH, ItemType.CHECK, ItemType.PUSH);
    }

    public void testItem_Type_PushCheckCheck() {
        this.testItem_Type(ItemType.PUSH, ItemType.CHECK, ItemType.CHECK);
    }

    public void testItem_Type_CheckCheckCheck() {
        this.testItem_Type(ItemType.CHECK, ItemType.CHECK, ItemType.CHECK);
    }

    public void testItem_Type_CheckCheckRadio() {
        this.testItem_Type(ItemType.CHECK, ItemType.CHECK, ItemType.RADIO);
    }

    public void testItem_Type_CheckRadioCheck() {
        this.testItem_Type(ItemType.CHECK, ItemType.RADIO, ItemType.CHECK);
    }

    public void testItem_Type_CheckRadioRadio() {
        this.testItem_Type(ItemType.CHECK, ItemType.RADIO, ItemType.RADIO);
    }

    public void testItem_Type_RadioRadioRadio() {
        this.testItem_Type(ItemType.RADIO, ItemType.RADIO, ItemType.RADIO);
    }

    public void testItem_Type_RadioRadioSeparator() {
        this.testItem_Type(ItemType.RADIO, ItemType.RADIO, ItemType.SEPARATOR);
    }

    public void testItem_Type_RadioSeparatorRadio() {
        this.testItem_Type(ItemType.RADIO, ItemType.SEPARATOR, ItemType.RADIO);
    }

    public void testItem_Type_RadioSeparatorSeparator() {
        this.testItem_Type(ItemType.RADIO, ItemType.SEPARATOR, ItemType.SEPARATOR);
    }

    public void testItem_Type_SeparatorSeparatorSeparator() {
        this.testItem_Type(ItemType.SEPARATOR, ItemType.SEPARATOR, ItemType.SEPARATOR);
    }

    public void testItem_Type_SeparatorSeparatorPush() {
        this.testItem_Type(ItemType.SEPARATOR, ItemType.SEPARATOR, ItemType.PUSH);
    }

    public void testItem_Type_SeparatorPushSeparator() {
        this.testItem_Type(ItemType.SEPARATOR, ItemType.PUSH, ItemType.SEPARATOR);
    }

    public void testItem_Type_SeparatorPushPush() {
        this.testItem_Type(ItemType.SEPARATOR, ItemType.PUSH, ItemType.PUSH);
    }
}

