/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.model.application.MKeyBinding;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerKeyBindingTest
extends ModelReconcilerTest {
    private void testKeySequence_KeySequence(String before, String after) {
        MApplication application = this.createApplication();
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        application.getCommands().add((Object)command);
        MKeyBinding keyBinding = MApplicationFactory.eINSTANCE.createKeyBinding();
        keyBinding.setKeySequence(before);
        keyBinding.setCommand(command);
        application.getBindings().add((Object)keyBinding);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        keyBinding.setKeySequence(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        keyBinding = (MKeyBinding)application.getBindings().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerKeyBindingTest.assertEquals((String)before, (String)keyBinding.getKeySequence());
        this.applyAll(deltas);
        ModelReconcilerKeyBindingTest.assertEquals((String)after, (String)keyBinding.getKeySequence());
    }

    public void testKeySequence_KeySequence_NullNull() {
        this.testKeySequence_KeySequence(null, null);
    }

    public void testKeySequence_KeySequence_NullEmpty() {
        this.testKeySequence_KeySequence(null, "");
    }

    public void testKeySequence_KeySequence_NullString() {
        this.testKeySequence_KeySequence(null, "Ctrl+S");
    }

    public void testKeySequence_KeySequence_EmptyNull() {
        this.testKeySequence_KeySequence("", null);
    }

    public void testKeySequence_KeySequence_EmptyEmpty() {
        this.testKeySequence_KeySequence("", "");
    }

    public void testKeySequence_KeySequence_EmptyString() {
        this.testKeySequence_KeySequence("", "Ctrl+S");
    }

    public void testKeySequence_KeySequence_StringNull() {
        this.testKeySequence_KeySequence("Ctrl+S", null);
    }

    public void testKeySequence_KeySequence_StringEmpty() {
        this.testKeySequence_KeySequence("Ctrl+S", "");
    }

    public void testKeySequence_KeySequence_StringStringUnchanged() {
        this.testKeySequence_KeySequence("Ctrl+S", "Ctrl+S");
    }

    public void testKeySequence_KeySequence_StringStringChanged() {
        this.testKeySequence_KeySequence("Ctrl+S", "Ctrl+D");
    }
}

