/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MPartDescriptor;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerPartDescriptorTest
extends ModelReconcilerTest {
    private void testPartDescriptor_AllowMultiple(boolean before, boolean after) {
        MApplication application = this.createApplication();
        MPartDescriptor descriptor = MApplicationFactory.eINSTANCE.createPartDescriptor();
        application.getDescriptors().add((Object)descriptor);
        descriptor.setAllowMultiple(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        descriptor.setAllowMultiple(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        descriptor = (MPartDescriptor)application.getDescriptors().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerPartDescriptorTest.assertEquals((boolean)before, (boolean)descriptor.isAllowMultiple());
        this.applyAll(deltas);
        ModelReconcilerPartDescriptorTest.assertEquals((boolean)after, (boolean)descriptor.isAllowMultiple());
    }

    public void testPartDescriptor_AllowMultiple_TrueTrue() {
        this.testPartDescriptor_AllowMultiple(true, true);
    }

    public void testPartDescriptor_AllowMultiple_TrueFalse() {
        this.testPartDescriptor_AllowMultiple(true, false);
    }

    public void testPartDescriptor_AllowMultiple_FalseTrue() {
        this.testPartDescriptor_AllowMultiple(false, true);
    }

    public void testPartDescriptor_AllowMultiple_FalseFalse() {
        this.testPartDescriptor_AllowMultiple(false, false);
    }

    private void testUIItem_Tooltip(String before, String after) {
        MApplication application = this.createApplication();
        MPartDescriptor descriptor = MApplicationFactory.eINSTANCE.createPartDescriptor();
        application.getDescriptors().add((Object)descriptor);
        descriptor.setCategory(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        descriptor.setCategory(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        descriptor = (MPartDescriptor)application.getDescriptors().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerPartDescriptorTest.assertEquals((String)before, (String)descriptor.getCategory());
        this.applyAll(deltas);
        ModelReconcilerPartDescriptorTest.assertEquals((String)after, (String)descriptor.getCategory());
    }

    public void testUIItem_Tooltip_NullNull() {
        this.testUIItem_Tooltip(null, null);
    }

    public void testUIItem_Tooltip_NullEmpty() {
        this.testUIItem_Tooltip(null, "");
    }

    public void testUIItem_Tooltip_NullString() {
        this.testUIItem_Tooltip(null, "toolTip");
    }

    public void testUIItem_Tooltip_EmptyNull() {
        this.testUIItem_Tooltip("", null);
    }

    public void testUIItem_Tooltip_EmptyEmpty() {
        this.testUIItem_Tooltip("", "");
    }

    public void testUIItem_Tooltip_EmptyString() {
        this.testUIItem_Tooltip("", "toolTip");
    }

    public void testUIItem_Tooltip_StringNull() {
        this.testUIItem_Tooltip("toolTip", null);
    }

    public void testUIItem_Tooltip_StringEmpty() {
        this.testUIItem_Tooltip("toolTip", "");
    }

    public void testUIItem_Tooltip_StringStringUnchanged() {
        this.testUIItem_Tooltip("toolTip", "toolTip");
    }

    public void testUIItem_Tooltip_StringStringChanged() {
        this.testUIItem_Tooltip("toolTip", "toolTip2");
    }
}

