/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.model.application.MKeyBinding;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MMenuItem;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;
import org.eclipse.emf.common.util.EList;

public abstract class ModelReconcilerScenarioTest
extends ModelReconcilerTest {
    public void testApplicationElement_Id_Changed() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setLabel("name");
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setLabel("customName");
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        window.setId("id");
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerScenarioTest.assertEquals((String)"name", (String)window.getLabel());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((String)"customName", (String)window.getLabel());
    }

    public void testApplicationElement_Id_Changed2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setId("id");
        window.setLabel("name");
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setLabel("customName");
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        window.setId("id2");
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerScenarioTest.assertEquals((String)"name", (String)window.getLabel());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((String)"customName", (String)window.getLabel());
    }

    public void testPart_Name_NameChangeFromUser_UserWins() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        part.setLabel("name");
        window.getChildren().add((Object)part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setLabel("customName");
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        part.setLabel("name2");
        window.getChildren().add((Object)part);
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerScenarioTest.assertEquals((String)"name2", (String)part.getLabel());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((String)"customName", (String)part.getLabel());
    }

    public void testPart_Visibility_TrueFalseFromApplication_ApplicationWins() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        part.setLabel("name");
        part.setToBeRendered(true);
        window.getChildren().add((Object)part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setLabel("customName");
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        part.setLabel("name2");
        part.setToBeRendered(false);
        window.getChildren().add((Object)part);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertFalse((boolean)part.isToBeRendered());
        ModelReconcilerScenarioTest.assertEquals((String)"name2", (String)part.getLabel());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertFalse((boolean)part.isToBeRendered());
        ModelReconcilerScenarioTest.assertEquals((String)"customName", (String)part.getLabel());
    }

    public void testPart_Visibility_TrueFalseFromUser_UserWins() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        part.setLabel("name");
        part.setToBeRendered(true);
        window.getChildren().add((Object)part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setToBeRendered(false);
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        part.setLabel("name2");
        window.getChildren().add((Object)part);
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerScenarioTest.assertTrue((boolean)part.isToBeRendered());
        ModelReconcilerScenarioTest.assertEquals((String)"name2", (String)part.getLabel());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertFalse((boolean)part.isToBeRendered());
        ModelReconcilerScenarioTest.assertEquals((String)"name2", (String)part.getLabel());
    }

    public void testPart_Addition_PlacedAfterHiddenPart_UserWins() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setToBeRendered(true);
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setToBeRendered(true);
        MPart partD = MApplicationFactory.eINSTANCE.createPart();
        partD.setToBeRendered(true);
        window.getChildren().add((Object)partA);
        window.getChildren().add((Object)partB);
        window.getChildren().add((Object)partD);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        partB.setToBeRendered(false);
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partA = (MPart)window.getChildren().get(0);
        partB = (MPart)window.getChildren().get(1);
        partD = (MPart)window.getChildren().get(2);
        MPart partC = MApplicationFactory.eINSTANCE.createPart();
        partC.setToBeRendered(true);
        window.getChildren().add(2, (Object)partC);
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerScenarioTest.assertTrue((boolean)partA.isToBeRendered());
        ModelReconcilerScenarioTest.assertTrue((boolean)partB.isToBeRendered());
        ModelReconcilerScenarioTest.assertTrue((boolean)partC.isToBeRendered());
        ModelReconcilerScenarioTest.assertTrue((boolean)partD.isToBeRendered());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertTrue((boolean)partA.isToBeRendered());
        ModelReconcilerScenarioTest.assertFalse((boolean)partB.isToBeRendered());
        ModelReconcilerScenarioTest.assertTrue((boolean)partC.isToBeRendered());
        ModelReconcilerScenarioTest.assertTrue((boolean)partD.isToBeRendered());
    }

    public void testPart_Addition_PlacedAfterRemovedPart_UserWins() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        MPart partC = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partA);
        window.getChildren().add((Object)partB);
        window.getChildren().add((Object)partC);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.getChildren().remove((Object)partB);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partA = (MPart)window.getChildren().get(0);
        partB = (MPart)window.getChildren().get(1);
        partC = (MPart)window.getChildren().get(2);
        MPart partD = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partD);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        EList children = window.getChildren();
        ModelReconcilerScenarioTest.assertEquals((int)4, (int)children.size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, (Object)children.get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partB, (Object)children.get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)partC, (Object)children.get(2));
        ModelReconcilerScenarioTest.assertEquals((Object)partD, (Object)children.get(3));
        this.applyAll(deltas);
        children = window.getChildren();
        ModelReconcilerScenarioTest.assertEquals((int)3, (int)children.size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, (Object)children.get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partC, (Object)children.get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)partD, (Object)children.get(2));
    }

    public void testPart_Addition_PlacedAfterRemovedPart_UserWins2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partA);
        window.getChildren().add((Object)partB);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.getChildren().remove((Object)partA);
        window.getChildren().remove((Object)partB);
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partA = (MPart)window.getChildren().get(0);
        partB = (MPart)window.getChildren().get(1);
        MPart partC = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)partC);
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerScenarioTest.assertEquals((int)3, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, (Object)window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partB, (Object)window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)partC, (Object)window.getChildren().get(2));
        this.applyAll(deltas);
        EList children = window.getChildren();
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)children.size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, (Object)children.get(0));
    }

    public void testPartStack_Addition_ContainsExistingPart() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack1 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack1);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        stack1.getChildren().add((Object)part1);
        stack1.getChildren().add((Object)part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartStack stack2 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add(0, (Object)stack2);
        stack2.getChildren().add((Object)part1);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack1 = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)stack1.getChildren().get(0);
        part2 = (MPart)stack1.getChildren().get(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, (Object)stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)part2, (Object)stack1.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part2, (Object)stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        stack2 = (MPartStack)window.getChildren().get(0);
        ModelReconcilerScenarioTest.assertEquals((Object)part1, (Object)stack2.getChildren().get(0));
    }

    public void testPartStack_Addition_ContainsExistingPart2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack1 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack1);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        stack1.getChildren().add((Object)part1);
        stack1.getChildren().add((Object)part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartStack stack2 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack2);
        stack2.getChildren().add((Object)part1);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack1 = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)stack1.getChildren().get(0);
        part2 = (MPart)stack1.getChildren().get(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, (Object)stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)part2, (Object)stack1.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part2, (Object)stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        stack2 = (MPartStack)window.getChildren().get(1);
        ModelReconcilerScenarioTest.assertEquals((Object)part1, (Object)stack2.getChildren().get(0));
    }

    private void testPartStack_AdditionInBack_ApplicationHasNewStackInFront(boolean performMoveFirst) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack1 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack1);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        MPart partC = MApplicationFactory.eINSTANCE.createPart();
        stack1.getChildren().add((Object)partA);
        stack1.getChildren().add((Object)partB);
        stack1.getChildren().add((Object)partC);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartStack stack2 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack2);
        stack2.getChildren().add((Object)partA);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack1 = (MPartStack)window.getChildren().get(0);
        partA = (MPart)stack1.getChildren().get(0);
        partB = (MPart)stack1.getChildren().get(1);
        partC = (MPart)stack1.getChildren().get(2);
        MPartStack stack3 = MApplicationFactory.eINSTANCE.createPartStack();
        if (performMoveFirst) {
            stack3.getChildren().add((Object)partC);
            window.getChildren().add(0, (Object)stack3);
        } else {
            window.getChildren().add(0, (Object)stack3);
            stack3.getChildren().add((Object)partC);
        }
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)stack3, (Object)window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)stack1, (Object)window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack3.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, (Object)stack3.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, (Object)stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partB, (Object)stack1.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)3, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)stack3, (Object)window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)stack1, (Object)window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partB, (Object)stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack3.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, (Object)stack3.getChildren().get(0));
        stack2 = (MPartStack)window.getChildren().get(2);
        ModelReconcilerScenarioTest.assertEquals((Object)partA, (Object)stack2.getChildren().get(0));
    }

    public void testPartStack_AdditionInBack_ApplicationHasNewStackInFront_True() {
        this.testPartStack_AdditionInBack_ApplicationHasNewStackInFront(true);
    }

    public void testPartStack_AdditionInBack_ApplicationHasNewStackInFront_False() {
        this.testPartStack_AdditionInBack_ApplicationHasNewStackInFront(false);
    }

    private void testPartStack_AdditionInFront_ApplicationHasNewStackInBack(boolean performMoveFirst) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack1 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack1);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        MPart partC = MApplicationFactory.eINSTANCE.createPart();
        stack1.getChildren().add((Object)partA);
        stack1.getChildren().add((Object)partB);
        stack1.getChildren().add((Object)partC);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartStack stack2 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add(0, (Object)stack2);
        stack2.getChildren().add((Object)partA);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack1 = (MPartStack)window.getChildren().get(0);
        partA = (MPart)stack1.getChildren().get(0);
        partB = (MPart)stack1.getChildren().get(1);
        partC = (MPart)stack1.getChildren().get(2);
        MPartStack stack3 = MApplicationFactory.eINSTANCE.createPartStack();
        if (performMoveFirst) {
            stack3.getChildren().add((Object)partC);
            window.getChildren().add((Object)stack3);
        } else {
            window.getChildren().add((Object)stack3);
            stack3.getChildren().add((Object)partC);
        }
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)stack1, (Object)window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)stack3, (Object)window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, (Object)stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partB, (Object)stack1.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack3.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, (Object)stack3.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)3, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)stack1, (Object)window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)stack3, (Object)window.getChildren().get(2));
        stack2 = (MPartStack)window.getChildren().get(0);
        ModelReconcilerScenarioTest.assertEquals((Object)partA, (Object)stack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partB, (Object)stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack3.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, (Object)stack3.getChildren().get(0));
    }

    public void testPartStack_AdditionInFront_ApplicationHasNewStackInBack_True() {
        this.testPartStack_AdditionInFront_ApplicationHasNewStackInBack(true);
    }

    public void testPartStack_AdditionInFront_ApplicationHasNewStackInBack_False() {
        this.testPartStack_AdditionInFront_ApplicationHasNewStackInBack(false);
    }

    public void testPart_MoveFromExistingStackToExistingStack_ToStackHasNewPart() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPartStack stack1 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack1);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        stack1.getChildren().add((Object)partA);
        stack1.getChildren().add((Object)partB);
        MPartStack stack2 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack2);
        MPart partC = MApplicationFactory.eINSTANCE.createPart();
        stack2.getChildren().add((Object)partC);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        stack2.getChildren().add((Object)partB);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        stack1 = (MPartStack)window.getChildren().get(0);
        partA = (MPart)stack1.getChildren().get(0);
        partB = (MPart)stack1.getChildren().get(1);
        stack2 = (MPartStack)window.getChildren().get(1);
        partC = (MPart)stack2.getChildren().get(0);
        MPart partD = MApplicationFactory.eINSTANCE.createPart();
        stack2.getChildren().add((Object)partD);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)stack1, (Object)window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)stack2, (Object)window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, (Object)stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partB, (Object)stack1.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)stack2.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, (Object)stack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partD, (Object)stack2.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)stack1, (Object)window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)stack2, (Object)window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)stack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partA, (Object)stack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)3, (int)stack2.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partC, (Object)stack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partB, (Object)stack2.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)partD, (Object)stack2.getChildren().get(2));
    }

    public void testBindingContainer_NewWithBindings() {
        MApplication application = this.createApplication();
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MWindow window = this.createWindow(application);
        MKeyBinding keyBinding = MApplicationFactory.eINSTANCE.createKeyBinding();
        window.getBindings().add((Object)keyBinding);
        Object state = reconciler.serialize();
        application = this.createApplication();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)application.getBindings().size());
        this.applyAll(deltas);
        window = (MWindow)application.getChildren().get(0);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)window.getBindings().size());
    }

    public void testElementContainer_ActiveChild_New() {
        MApplication application = this.createApplication();
        MWindow window1 = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window1);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MWindow window2 = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window2);
        application.setSelectedElement((MUIElement)window2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window1 = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertNull((Object)application.getSelectedElement());
        ModelReconcilerScenarioTest.assertEquals((Object)window1, (Object)application.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window1, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertNotNull((Object)application.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)application.getChildren().get(1), (Object)application.getSelectedElement());
    }

    public void testElementContainer_ActiveChild_Removed() {
        MApplication application = this.createApplication();
        MWindow window1 = MApplicationFactory.eINSTANCE.createWindow();
        MWindow window2 = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window1);
        application.getChildren().add((Object)window2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        application.setSelectedElement((MUIElement)window2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window1 = (MWindow)application.getChildren().get(0);
        application.getChildren().remove(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertNull((Object)application.getSelectedElement());
        ModelReconcilerScenarioTest.assertEquals((Object)window1, (Object)application.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertNull((Object)application.getSelectedElement());
        ModelReconcilerScenarioTest.assertEquals((Object)window1, (Object)application.getChildren().get(0));
    }

    public void testElementContainer_ActiveChild_Removed2() {
        MApplication application = this.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPartStack partStack1 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)partStack1);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        partStack1.getChildren().add((Object)part1);
        partStack1.getChildren().add((Object)part2);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPartStack partStack2 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)partStack2);
        partStack2.getChildren().add((Object)part2);
        partStack2.setSelectedElement((MUIElement)part2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partStack1 = (MPartStack)window.getChildren().get(0);
        part1 = (MPart)partStack1.getChildren().get(0);
        partStack1.getChildren().remove(1);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partStack1, (Object)window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)partStack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, (Object)partStack1.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partStack1, (Object)window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)partStack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, (Object)partStack1.getChildren().get(0));
        partStack2 = (MPartStack)window.getChildren().get(1);
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)partStack2.getChildren().size());
        ModelReconcilerScenarioTest.assertNull((Object)partStack2.getSelectedElement());
    }

    public void testElementContainer_Children_Move_IdenticalToUserChange() {
        MApplication application = this.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPartStack partStack1 = MApplicationFactory.eINSTANCE.createPartStack();
        MPartStack partStack2 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)partStack1);
        window.getChildren().add((Object)partStack2);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        partStack1.getChildren().add((Object)part1);
        partStack1.getChildren().add((Object)part2);
        MPart part3 = MApplicationFactory.eINSTANCE.createPart();
        partStack2.getChildren().add((Object)part3);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        partStack2.getChildren().add((Object)part2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partStack1 = (MPartStack)window.getChildren().get(0);
        partStack2 = (MPartStack)window.getChildren().get(1);
        part1 = (MPart)partStack1.getChildren().get(0);
        part2 = (MPart)partStack1.getChildren().get(1);
        part3 = (MPart)partStack2.getChildren().get(0);
        partStack2.getChildren().add((Object)part2);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partStack1, (Object)window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partStack2, (Object)window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)partStack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, (Object)partStack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)partStack2.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part3, (Object)partStack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)part2, (Object)partStack2.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partStack1, (Object)window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partStack2, (Object)window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)partStack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, (Object)partStack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)partStack2.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part3, (Object)partStack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)part2, (Object)partStack2.getChildren().get(1));
    }

    public void testElementContainer_Children_Move_NewHasSameChildren() {
        MApplication application = this.createApplication();
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPartStack partStack1 = MApplicationFactory.eINSTANCE.createPartStack();
        MPartStack partStack2 = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)partStack1);
        window.getChildren().add((Object)partStack2);
        MPart part1 = MApplicationFactory.eINSTANCE.createPart();
        MPart part2 = MApplicationFactory.eINSTANCE.createPart();
        partStack1.getChildren().add((Object)part1);
        partStack1.getChildren().add((Object)part2);
        MPart part3 = MApplicationFactory.eINSTANCE.createPart();
        partStack2.getChildren().add((Object)part3);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        partStack2.getChildren().add(0, (Object)part2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        partStack1 = (MPartStack)window.getChildren().get(0);
        partStack2 = (MPartStack)window.getChildren().get(1);
        part1 = (MPart)partStack1.getChildren().get(0);
        part2 = (MPart)partStack1.getChildren().get(1);
        part3 = (MPart)partStack2.getChildren().get(0);
        partStack2.getChildren().add((Object)part2);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partStack1, (Object)window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partStack2, (Object)window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)partStack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, (Object)partStack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)partStack2.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part3, (Object)partStack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)part2, (Object)partStack2.getChildren().get(1));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)partStack1, (Object)window.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)partStack2, (Object)window.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)partStack1.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part1, (Object)partStack1.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)2, (int)partStack2.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)part2, (Object)partStack2.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)part3, (Object)partStack2.getChildren().get(1));
    }

    public void testElementContainer_Children_AddMultipleThenRemove() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MWindow window2 = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window2);
        MPart editor = MApplicationFactory.eINSTANCE.createPart();
        window2.getChildren().add((Object)editor);
        application.getChildren().remove((Object)window2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)deltas.size());
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)window.getChildren().size());
    }

    public void testElementContainer_Children_AddMultipleThenRemove2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MWindow window2 = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window2);
        application.setSelectedElement((MUIElement)window2);
        application.getChildren().remove((Object)window2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertNull((Object)application.getSelectedElement());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertNull((Object)application.getSelectedElement());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)window.getChildren().size());
    }

    public void testElementContainer_Children_AddMultipleThenRemove3() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MWindow window2 = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window2);
        MPart editor = MApplicationFactory.eINSTANCE.createPart();
        window2.getChildren().add((Object)editor);
        editor.setLabel("editor");
        application.getChildren().remove((Object)window2);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((int)0, (int)window.getChildren().size());
    }

    public void testMenu_MenuOrdering() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MApplicationFactory.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        MMenuItem fileMenuItem = MApplicationFactory.eINSTANCE.createMenuItem();
        fileMenuItem.setLabel("File");
        MMenuItem editMenuItem = MApplicationFactory.eINSTANCE.createMenuItem();
        editMenuItem.setLabel("Edit");
        MMenuItem helpMenuItem = MApplicationFactory.eINSTANCE.createMenuItem();
        helpMenuItem.setLabel("Help");
        menu.getChildren().add((Object)fileMenuItem);
        menu.getChildren().add((Object)editMenuItem);
        menu.getChildren().add((Object)helpMenuItem);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MMenuItem cvsMenuItem = MApplicationFactory.eINSTANCE.createMenuItem();
        cvsMenuItem.setLabel("CVS");
        menu.getChildren().add(2, (Object)cvsMenuItem);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        fileMenuItem = (MMenuItem)menu.getChildren().get(0);
        editMenuItem = (MMenuItem)menu.getChildren().get(1);
        helpMenuItem = (MMenuItem)menu.getChildren().get(2);
        MMenuItem e4MenuItem = MApplicationFactory.eINSTANCE.createMenuItem();
        e4MenuItem.setLabel("e4");
        menu.getChildren().add(2, (Object)e4MenuItem);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerScenarioTest.assertEquals((int)4, (int)menu.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)fileMenuItem, (Object)menu.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)editMenuItem, (Object)menu.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((Object)e4MenuItem, (Object)menu.getChildren().get(2));
        ModelReconcilerScenarioTest.assertEquals((Object)helpMenuItem, (Object)menu.getChildren().get(3));
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerScenarioTest.assertEquals((int)5, (int)menu.getChildren().size());
        ModelReconcilerScenarioTest.assertEquals((Object)fileMenuItem, (Object)menu.getChildren().get(0));
        ModelReconcilerScenarioTest.assertEquals((Object)editMenuItem, (Object)menu.getChildren().get(1));
        ModelReconcilerScenarioTest.assertEquals((String)"CVS", (String)((MMenuItem)menu.getChildren().get(2)).getLabel());
        ModelReconcilerScenarioTest.assertEquals((Object)e4MenuItem, (Object)menu.getChildren().get(3));
        ModelReconcilerScenarioTest.assertEquals((Object)helpMenuItem, (Object)menu.getChildren().get(4));
    }

    private void testApplication_Commands_MultiLevelKeyBindings(String originalApplicationKeyBindingSequence, String userApplicationKeyBindingSequence, String originalWindowKeyBindingSequence, String userWindowKeyBindingSequence) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MCommand command = MApplicationFactory.eINSTANCE.createCommand();
        application.getCommands().add((Object)command);
        MKeyBinding applicationKeyBinding = MApplicationFactory.eINSTANCE.createKeyBinding();
        applicationKeyBinding.setCommand(command);
        applicationKeyBinding.setKeySequence(originalApplicationKeyBindingSequence);
        MKeyBinding windowKeyBinding = MApplicationFactory.eINSTANCE.createKeyBinding();
        windowKeyBinding.setCommand(command);
        windowKeyBinding.setKeySequence(originalWindowKeyBindingSequence);
        application.getBindings().add((Object)applicationKeyBinding);
        window.getBindings().add((Object)windowKeyBinding);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        applicationKeyBinding.setKeySequence(userApplicationKeyBindingSequence);
        windowKeyBinding.setKeySequence(userWindowKeyBindingSequence);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        command = (MCommand)application.getCommands().get(0);
        applicationKeyBinding = (MKeyBinding)application.getBindings().get(0);
        windowKeyBinding = (MKeyBinding)window.getBindings().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerScenarioTest.assertEquals((String)originalApplicationKeyBindingSequence, (String)applicationKeyBinding.getKeySequence());
        ModelReconcilerScenarioTest.assertEquals((String)originalWindowKeyBindingSequence, (String)windowKeyBinding.getKeySequence());
        this.applyAll(deltas);
        ModelReconcilerScenarioTest.assertEquals((String)userApplicationKeyBindingSequence, (String)applicationKeyBinding.getKeySequence());
        ModelReconcilerScenarioTest.assertEquals((String)userWindowKeyBindingSequence, (String)windowKeyBinding.getKeySequence());
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullNull_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, null, "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullEmpty_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "", "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_NullString_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings(null, "Ctrl+S", "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyNull_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("", null, "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyEmpty_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "", "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_EmptyString_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("", "Ctrl+S", "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringNull_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", null, "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringEmpty_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "", "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringUnchanged_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+S", "Ctrl+S", "Ctrl+D");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_NullNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", null, null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_NullEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", null, "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_NullString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", null, "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_EmptyNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_EmptyEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_EmptyString() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_StringNull() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "Ctrl+S", null);
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_StringEmpty() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "Ctrl+S", "");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_StringStringUnchanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "Ctrl+S", "Ctrl+S");
    }

    public void testApplication_Commands_MultiLevelKeyBindings_StringStringChanged_StringStringChanged() {
        this.testApplication_Commands_MultiLevelKeyBindings("Ctrl+S", "Ctrl+D", "Ctrl+S", "Ctrl+D");
    }
}

