/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.io.StringWriter;
import java.util.Collection;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.ui.tests.reconciler.ModelResourceTest;
import org.eclipse.e4.workbench.modeling.IModelReconcilingService;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelReconcilerTest
extends ModelResourceTest {
    protected IModelReconcilingService service;

    @Override
    protected void setUp() throws Exception {
        this.service = this.getModelReconcilingService();
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.service = null;
    }

    protected abstract IModelReconcilingService getModelReconcilingService();

    protected ModelReconciler createModelReconciler() {
        return this.service.createModelReconciler();
    }

    protected Collection<ModelDelta> constructDeltas(Object object, Object serializedState) {
        return this.constructDeltas(this.createModelReconciler(), object, serializedState);
    }

    protected Collection<ModelDelta> constructDeltas(ModelReconciler reconciler, Object object, Object serializedState) {
        return reconciler.constructDeltas(object, serializedState);
    }

    protected void applyAll(Collection<ModelDelta> deltas) {
        this.applyAll(deltas, new String[0]);
    }

    protected void applyAll(Collection<ModelDelta> deltas, String[] filters) {
        IStatus status = this.service.applyDeltas(deltas, filters);
        ModelReconcilerTest.assertNotNull((Object)status);
        ModelReconcilerTest.assertEquals((int)0, (int)status.getCode());
    }

    protected static void print(Object serializedState) {
        ModelReconcilerTest.print((Node)serializedState);
    }

    protected static void print(Node serializedState) {
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "no");
            trans.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(serializedState);
            trans.transform(source, result);
            String xmlString = sw.toString();
            System.out.println(xmlString);
            System.out.println();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

