/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MToolBar;
import org.eclipse.e4.ui.model.application.MToolItem;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerToolBarTest
extends ModelReconcilerTest {
    private void testToolBar_Children_Add(MToolItem toolItem) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)part);
        MToolBar toolBar = MApplicationFactory.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        toolBar.getChildren().add((Object)toolItem);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        toolBar = part.getToolbar();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerToolBarTest.assertEquals((int)0, (int)toolBar.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerToolBarTest.assertEquals((int)1, (int)toolBar.getChildren().size());
        ModelReconcilerToolBarTest.assertEquals(toolItem.getClass(), ((MToolItem)toolBar.getChildren().get(0)).getClass());
    }

    public void testToolBar_Children_Add_ToolItem() {
        this.testToolBar_Children_Add(MApplicationFactory.eINSTANCE.createToolItem());
    }

    public void testToolBar_Children_Add_DirectToolItem() {
        this.testToolBar_Children_Add((MToolItem)MApplicationFactory.eINSTANCE.createDirectToolItem());
    }

    public void testToolBar_Children_Add_HandledToolItem() {
        this.testToolBar_Children_Add((MToolItem)MApplicationFactory.eINSTANCE.createHandledToolItem());
    }

    public void testToolBar_Children_Remove() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = MApplicationFactory.eINSTANCE.createPart();
        window.getChildren().add((Object)part);
        MToolBar toolBar = MApplicationFactory.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        MToolItem toolItem = MApplicationFactory.eINSTANCE.createToolItem();
        toolBar.getChildren().add((Object)toolItem);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        toolBar.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        toolBar = part.getToolbar();
        toolItem = (MToolItem)toolBar.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerToolBarTest.assertEquals((int)1, (int)toolBar.getChildren().size());
        ModelReconcilerToolBarTest.assertEquals((Object)toolItem, (Object)toolBar.getChildren().get(0));
        this.applyAll(deltas);
        ModelReconcilerToolBarTest.assertEquals((int)0, (int)toolBar.getChildren().size());
    }
}

