/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerUIItemTest
extends ModelReconcilerTest {
    public void testUIItem_IconURI_Unmodified() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setLabel("name");
        window.setIconURI("iconURI");
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setLabel("name2");
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIItemTest.assertEquals((String)"iconURI", (String)window.getIconURI());
        ModelReconcilerUIItemTest.assertEquals((String)"name", (String)window.getLabel());
        this.applyAll(deltas);
        ModelReconcilerUIItemTest.assertEquals((String)"iconURI", (String)window.getIconURI());
        ModelReconcilerUIItemTest.assertEquals((String)"name2", (String)window.getLabel());
    }

    private void testUIItem_IconURIUnchanged(String iconURI) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setIconURI(iconURI);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIItemTest.assertEquals((String)iconURI, (String)window.getIconURI());
        this.applyAll(deltas);
        ModelReconcilerUIItemTest.assertEquals((String)iconURI, (String)window.getIconURI());
    }

    public void testUIItem_IconURIUnchanged_Null() {
        this.testUIItem_IconURIUnchanged(null);
    }

    public void testUIItem_IconURIUnchanged_Empty() {
        this.testUIItem_IconURIUnchanged("");
    }

    public void testUIItem_IconURIUnchanged_String() {
        this.testUIItem_IconURIUnchanged("iconURI");
    }

    private void testUIItem_IconURI(String before, String after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setIconURI(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setIconURI(after);
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerUIItemTest.assertEquals((String)before, (String)window.getIconURI());
        this.applyAll(deltas);
        ModelReconcilerUIItemTest.assertEquals((String)after, (String)window.getIconURI());
    }

    public void testUIItem_IconURI_NullNull() {
        this.testUIItem_IconURI(null, null);
    }

    public void testUIItem_IconURI_NullEmpty() {
        this.testUIItem_IconURI(null, "");
    }

    public void testUIItem_IconURI_NullString() {
        this.testUIItem_IconURI(null, "iconURI");
    }

    public void testUIItem_IconURI_EmptyNull() {
        this.testUIItem_IconURI("", null);
    }

    public void testUIItem_IconURI_EmptyEmpty() {
        this.testUIItem_IconURI("", "");
    }

    public void testUIItem_IconURI_EmptyString() {
        this.testUIItem_IconURI("", "iconURI");
    }

    public void testUIItem_IconURI_StringNull() {
        this.testUIItem_IconURI("iconURI", null);
    }

    public void testUIItem_IconURI_StringEmpty() {
        this.testUIItem_IconURI("iconURI", "");
    }

    public void testUIItem_IconURI_StringStringUnchanged() {
        this.testUIItem_IconURI("iconURI", "iconURI");
    }

    public void testUIItem_IconURI_StringStringChanged() {
        this.testUIItem_IconURI("iconURI", "iconURI2");
    }

    public void testUIItem_Tooltip_Unmodified() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setLabel("name");
        window.setTooltip("toolTip");
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setLabel("name2");
        Object serializedState = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, serializedState);
        ModelReconcilerUIItemTest.assertEquals((String)"toolTip", (String)window.getTooltip());
        ModelReconcilerUIItemTest.assertEquals((String)"name", (String)window.getLabel());
        this.applyAll(deltas);
        ModelReconcilerUIItemTest.assertEquals((String)"toolTip", (String)window.getTooltip());
        ModelReconcilerUIItemTest.assertEquals((String)"name2", (String)window.getLabel());
    }

    private void testUIItem_TooltipUnchanged(String toolTip) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setTooltip(toolTip);
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        this.saveModel();
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIItemTest.assertEquals((String)toolTip, (String)window.getTooltip());
        this.applyAll(deltas);
        ModelReconcilerUIItemTest.assertEquals((String)toolTip, (String)window.getTooltip());
    }

    public void testUIItem_TooltipUnchanged_Null() {
        this.testUIItem_TooltipUnchanged(null);
    }

    public void testUIItem_TooltipUnchanged_Empty() {
        this.testUIItem_TooltipUnchanged("");
    }

    public void testUIItem_TooltipUnchanged_String() {
        this.testUIItem_TooltipUnchanged("toolTip");
    }

    private void testUIItem_Tooltip(String before, String after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setTooltip(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setTooltip(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIItemTest.assertEquals((String)before, (String)window.getTooltip());
        this.applyAll(deltas);
        ModelReconcilerUIItemTest.assertEquals((String)after, (String)window.getTooltip());
    }

    public void testUIItem_Tooltip_NullNull() {
        this.testUIItem_Tooltip(null, null);
    }

    public void testUIItem_Tooltip_NullEmpty() {
        this.testUIItem_Tooltip(null, "");
    }

    public void testUIItem_Tooltip_NullString() {
        this.testUIItem_Tooltip(null, "toolTip");
    }

    public void testUIItem_Tooltip_EmptyNull() {
        this.testUIItem_Tooltip("", null);
    }

    public void testUIItem_Tooltip_EmptyEmpty() {
        this.testUIItem_Tooltip("", "");
    }

    public void testUIItem_Tooltip_EmptyString() {
        this.testUIItem_Tooltip("", "toolTip");
    }

    public void testUIItem_Tooltip_StringNull() {
        this.testUIItem_Tooltip("toolTip", null);
    }

    public void testUIItem_Tooltip_StringEmpty() {
        this.testUIItem_Tooltip("toolTip", "");
    }

    public void testUIItem_Tooltip_StringStringUnchanged() {
        this.testUIItem_Tooltip("toolTip", "toolTip");
    }

    public void testUIItem_Tooltip_StringStringChanged() {
        this.testUIItem_Tooltip("toolTip", "toolTip2");
    }

    public void testUIItem_Label_Unmodified() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setLabel("name");
        window.setTooltip("toolTip");
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setTooltip("toolTip2");
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIItemTest.assertEquals((String)"toolTip", (String)window.getTooltip());
        ModelReconcilerUIItemTest.assertEquals((String)"name", (String)window.getLabel());
        this.applyAll(deltas);
        ModelReconcilerUIItemTest.assertEquals((String)"toolTip2", (String)window.getTooltip());
        ModelReconcilerUIItemTest.assertEquals((String)"name", (String)window.getLabel());
    }

    private void testUIItem_LabelUnchanged(String name) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setLabel(name);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIItemTest.assertEquals((String)name, (String)window.getLabel());
        this.applyAll(deltas);
        ModelReconcilerUIItemTest.assertEquals((String)name, (String)window.getLabel());
    }

    public void testUIItem_LabelUnchanged_Null() {
        this.testUIItem_LabelUnchanged(null);
    }

    public void testUIItem_LabelUnchanged_Empty() {
        this.testUIItem_LabelUnchanged("");
    }

    public void testUIItem_LabelUnchanged_String() {
        this.testUIItem_LabelUnchanged("name");
    }

    private void testUIItem_Label(String before, String after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setLabel(before);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setLabel(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerUIItemTest.assertEquals((String)before, (String)window.getLabel());
        this.applyAll(deltas);
        ModelReconcilerUIItemTest.assertEquals((String)after, (String)window.getLabel());
    }

    public void testUIItem_Label_NullNull() {
        this.testUIItem_Label(null, null);
    }

    public void testUIItem_Label_NullEmpty() {
        this.testUIItem_Label(null, "");
    }

    public void testUIItem_Label_NullString() {
        this.testUIItem_Label(null, "name");
    }

    public void testUIItem_Label_EmptyNull() {
        this.testUIItem_Label("", null);
    }

    public void testUIItem_Label_EmptyEmpty() {
        this.testUIItem_Label("", "");
    }

    public void testUIItem_Label_EmptyString() {
        this.testUIItem_Label("", "name");
    }

    public void testUIItem_Label_StringNull() {
        this.testUIItem_Label("name", null);
    }

    public void testUIItem_Label_StringEmpty() {
        this.testUIItem_Label("name", "");
    }

    public void testUIItem_Label_StringStringUnchanged() {
        this.testUIItem_Label("name", "name");
    }

    public void testUIItem_Label_StringStringChanged() {
        this.testUIItem_Label("name", "name2");
    }
}

