/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MMenuItem;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerWindowTest
extends ModelReconcilerTest {
    public void testWindow_X() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setX(100);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setX(200);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)100, (int)window.getX());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)200, (int)window.getX());
    }

    public void testWindow_Y() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setY(100);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setY(200);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)100, (int)window.getY());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)200, (int)window.getY());
    }

    public void testWindow_Width() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setWidth(100);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setWidth(200);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)100, (int)window.getWidth());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)200, (int)window.getWidth());
    }

    public void testWindow_Height() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        window.setHeight(100);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setHeight(200);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)100, (int)window.getHeight());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)200, (int)window.getHeight());
    }

    public void testWindow_Menu_Set() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MMenu menu = MApplicationFactory.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertNull((Object)window.getMainMenu());
        this.applyAll(deltas);
        menu = window.getMainMenu();
        ModelReconcilerWindowTest.assertNotNull((Object)menu);
    }

    public void testWindow_Menu_Unset() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MApplicationFactory.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        window.setMainMenu(null);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertNull((Object)window.getMainMenu());
    }

    private void testWindow_Menu_Visible(boolean before, boolean after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MApplicationFactory.eINSTANCE.createMenu();
        menu.setToBeRendered(before);
        window.setMainMenu(menu);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        menu.setToBeRendered(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((boolean)before, (boolean)menu.isToBeRendered());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((boolean)after, (boolean)menu.isToBeRendered());
    }

    public void testWindow_Menu_Children_Add() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MApplicationFactory.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MMenuItem menuItem = MApplicationFactory.eINSTANCE.createMenuItem();
        menuItem.setLabel("File");
        menu.getChildren().add((Object)menuItem);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerWindowTest.assertEquals((int)0, (int)menu.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerWindowTest.assertEquals((int)1, (int)menu.getChildren().size());
        ModelReconcilerWindowTest.assertNotNull((Object)menu.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((String)"File", (String)((MMenuItem)menu.getChildren().get(0)).getLabel());
    }

    public void testWindow_Menu_Children_Remove() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MApplicationFactory.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        MMenuItem menuItem = MApplicationFactory.eINSTANCE.createMenuItem();
        menuItem.setLabel("File");
        menu.getChildren().add((Object)menuItem);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        menu.getChildren().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerWindowTest.assertEquals((int)1, (int)menu.getChildren().size());
        ModelReconcilerWindowTest.assertNotNull((Object)menu.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((String)"File", (String)((MMenuItem)menu.getChildren().get(0)).getLabel());
        this.applyAll(deltas);
        ModelReconcilerWindowTest.assertEquals((int)1, (int)application.getChildren().size());
        ModelReconcilerWindowTest.assertEquals((Object)window, (Object)application.getChildren().get(0));
        ModelReconcilerWindowTest.assertEquals((Object)menu, (Object)window.getMainMenu());
        ModelReconcilerWindowTest.assertEquals((int)0, (int)menu.getChildren().size());
    }

    public void testWindow_Menu_Visible_TrueTrue() {
        this.testWindow_Menu_Visible(true, true);
    }

    public void testWindow_Menu_Visible_TrueFalse() {
        this.testWindow_Menu_Visible(true, false);
    }

    public void testWindow_Menu_Visible_FalseTrue() {
        this.testWindow_Menu_Visible(false, true);
    }

    public void testWindow_Menu_Visible_FalseFalse() {
        this.testWindow_Menu_Visible(false, false);
    }
}

