/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MMenuItem;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.workbench.swt.internal.E4Application;
import org.eclipse.e4.workbench.ui.internal.E4Workbench;
import org.eclipse.e4.workbench.ui.renderers.swt.TrimmedPartLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class MMenuItemTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.workbench.swt.internal.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        if (this.appContext instanceof IDisposable) {
            ((IDisposable)this.appContext).dispose();
        }
    }

    protected Control[] getPresentationControls(Shell shell) {
        TrimmedPartLayout tpl = (TrimmedPartLayout)shell.getLayout();
        return tpl.clientArea.getChildren();
    }

    private void testMMenuItem_Text(String before, String beforeExpected, String after, String afterExpected) {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        MMenu menu = MApplicationFactory.eINSTANCE.createMenu();
        MMenuItem menuItem = MApplicationFactory.eINSTANCE.createMenuItem();
        menuItem.setLabel(before);
        window.setMainMenu(menu);
        menu.getChildren().add((Object)menuItem);
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = menuItem.getWidget();
        MMenuItemTest.assertNotNull((Object)widget);
        MMenuItemTest.assertTrue((boolean)(widget instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget;
        MMenuItemTest.assertEquals((String)beforeExpected, (String)menuItemWidget.getText());
        menuItem.setLabel(after);
        MMenuItemTest.assertEquals((String)afterExpected, (String)menuItemWidget.getText());
    }

    public void testMMenuItem_Text_NullNull() {
        this.testMMenuItem_Text(null, "", null, "");
    }

    public void testMMenuItem_Text_NullEmpty() {
        this.testMMenuItem_Text(null, "", "", "");
    }

    public void testMMenuItem_Text_NullString() {
        this.testMMenuItem_Text(null, "", "label", "label");
    }

    public void testMMenuItem_Text_EmptyNull() {
        this.testMMenuItem_Text("", "", null, "");
    }

    public void testMMenuItem_Text_EmptyEmpty() {
        this.testMMenuItem_Text("", "", "", "");
    }

    public void testMMenuItem_Text_EmptyString() {
        this.testMMenuItem_Text("", "", "label", "label");
    }

    public void testMMenuItem_Text_StringNull() {
        this.testMMenuItem_Text("label", "label", null, "");
    }

    public void testMMenuItem_Text_StringEmpty() {
        this.testMMenuItem_Text("label", "label", "", "");
    }

    public void testMMenuItem_Text_StringStringUnchanged() {
        this.testMMenuItem_Text("label", "label", "label", "label");
    }

    public void testMMenuItem_Text_StringStringChanged() {
        this.testMMenuItem_Text("label", "label", "label2", "label2");
    }
}

