/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartSashContainer;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.workbench.swt.internal.E4Application;
import org.eclipse.e4.workbench.ui.internal.E4Workbench;
import org.eclipse.e4.workbench.ui.renderers.swt.TrimmedPartLayout;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class MPartSashContainerTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.workbench.swt.internal.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        if (this.appContext instanceof IDisposable) {
            ((IDisposable)this.appContext).dispose();
        }
    }

    protected Control[] getPresentationControls(Shell shell) {
        TrimmedPartLayout tpl = (TrimmedPartLayout)shell.getLayout();
        return tpl.clientArea.getChildren();
    }

    public void testPartSashContainer_Horizontal() {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        MPartSashContainer partSashContainer = MApplicationFactory.eINSTANCE.createPartSashContainer();
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partSashContainer.setHorizontal(true);
        partA.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partB.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add((Object)partSashContainer);
        partSashContainer.getChildren().add((Object)partA);
        partSashContainer.getChildren().add((Object)partB);
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = partSashContainer.getWidget();
        MPartSashContainerTest.assertNotNull((Object)widget);
        MPartSashContainerTest.assertTrue((boolean)(widget instanceof SashForm));
        SashForm sashForm = (SashForm)widget;
        MPartSashContainerTest.assertEquals((int)256, (int)sashForm.getOrientation());
        partSashContainer.setHorizontal(false);
        MPartSashContainerTest.assertEquals((int)512, (int)sashForm.getOrientation());
        partSashContainer.setHorizontal(true);
        MPartSashContainerTest.assertEquals((int)256, (int)sashForm.getOrientation());
        partSashContainer.setHorizontal(true);
        MPartSashContainerTest.assertEquals((int)256, (int)sashForm.getOrientation());
    }
}

