/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MMenuItem;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartSashContainer;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.workbench.swt.internal.AbstractPartRenderer;
import org.eclipse.e4.ui.workbench.swt.internal.E4Application;
import org.eclipse.e4.workbench.ui.internal.E4Workbench;
import org.eclipse.e4.workbench.ui.renderers.swt.TrimmedPartLayout;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class MWindowTest
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.workbench.swt.internal.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        if (this.appContext instanceof IDisposable) {
            ((IDisposable)this.appContext).dispose();
        }
    }

    protected Control[] getPresentationControls(Shell shell) {
        TrimmedPartLayout tpl = (TrimmedPartLayout)shell.getLayout();
        return tpl.clientArea.getChildren();
    }

    public void testCreateWindow() {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setLabel("MyWindow");
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        MWindowTest.assertNotNull((Object)topWidget);
        MWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        MWindowTest.assertEquals((String)"MyWindow", (String)((Shell)topWidget).getText());
        MWindowTest.assertEquals((Object)topWidget, (Object)this.appContext.get("activeShell"));
    }

    public void testWindowVisibility() {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setLabel("MyWindow");
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        MWindowTest.assertNotNull((Object)topWidget);
        MWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        MWindowTest.assertTrue((boolean)shell.getVisible());
        window.setVisible(false);
        MWindowTest.assertTrue((!shell.getVisible() ? 1 : 0) != 0);
        window.setVisible(true);
        MWindowTest.assertTrue((boolean)shell.getVisible());
    }

    public void testWindowInvisibleCreate() {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setLabel("MyWindow");
        window.setVisible(false);
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        MWindowTest.assertNotNull((Object)topWidget);
        MWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        MWindowTest.assertTrue((!shell.getVisible() ? 1 : 0) != 0);
    }

    public void testCreateView() {
        MWindow window = this.createWindowWithOneView();
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        MWindowTest.assertNotNull((Object)topWidget);
        MWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        MWindowTest.assertEquals((String)"MyWindow", (String)shell.getText());
        Control[] controls = this.getPresentationControls(shell);
        MWindowTest.assertEquals((int)1, (int)controls.length);
        SashForm sash = (SashForm)controls[0];
        Control[] sashChildren = sash.getChildren();
        MWindowTest.assertEquals((int)1, (int)sashChildren.length);
        CTabFolder folder = (CTabFolder)sashChildren[0];
        MWindowTest.assertEquals((int)1, (int)folder.getItemCount());
        Control c = folder.getItem(0).getControl();
        MWindowTest.assertTrue((boolean)(c instanceof Composite));
        Control[] viewPart = ((Composite)c).getChildren();
        MWindowTest.assertEquals((int)1, (int)viewPart.length);
        MWindowTest.assertTrue((boolean)(viewPart[0] instanceof Tree));
    }

    public void testContextChildren() {
        MWindow window = this.createWindowWithOneView();
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        MWindowTest.assertNotNull((Object)topWidget);
        MWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        MWindowTest.assertEquals((String)"MyWindow", (String)shell.getText());
        IEclipseContext child = (IEclipseContext)this.appContext.getLocal("activeChildContext");
        MWindowTest.assertNotNull((Object)child);
        MWindowTest.assertEquals((Object)window.getContext(), (Object)child);
        MPart modelPart = this.getContributedPart(window);
        MWindowTest.assertNotNull((Object)modelPart);
        MWindowTest.assertEquals((Object)window, (Object)modelPart.getParent().getParent().getParent());
        AbstractPartRenderer factory = (AbstractPartRenderer)modelPart.getRenderer();
        factory.activate(modelPart);
        IEclipseContext next = (IEclipseContext)child.getLocal("activeChildContext");
        while (next != null) {
            child = next;
            if ((next = (IEclipseContext)child.getLocal("activeChildContext")) != child) continue;
            MWindowTest.fail((String)"Cycle detected in part context");
            break;
        }
        MWindowTest.assertFalse((window.getContext() == child ? 1 : 0) != 0);
        MPart contextPart = (MPart)child.get(MPart.class.getName());
        MWindowTest.assertNotNull((Object)contextPart);
        MWindowTest.assertEquals((Object)window, (Object)contextPart.getParent().getParent().getParent());
    }

    public void testCreateMenu() {
        MWindow window = this.createWindowWithOneViewAndMenu();
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget topWidget = (Widget)window.getWidget();
        MWindowTest.assertNotNull((Object)topWidget);
        MWindowTest.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        Menu menuBar = shell.getMenuBar();
        MWindowTest.assertNotNull((Object)menuBar);
        MWindowTest.assertEquals((int)1, (int)menuBar.getItemCount());
        MenuItem fileItem = menuBar.getItem(0);
        MWindowTest.assertEquals((String)"File", (String)fileItem.getText());
        Menu fileMenu = fileItem.getMenu();
        fileMenu.notifyListeners(22, null);
        MWindowTest.assertEquals((int)2, (int)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
        MMenu mainMenu = window.getMainMenu();
        MMenuItem item2Model = (MMenuItem)((MMenuItem)mainMenu.getChildren().get(0)).getChildren().get(0);
        item2Model.setToBeRendered(false);
        fileMenu.notifyListeners(22, null);
        MWindowTest.assertEquals((int)1, (int)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
        item2Model.setToBeRendered(true);
        fileMenu.notifyListeners(22, null);
        MWindowTest.assertEquals((int)2, (int)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
    }

    public void testWindow_Name() {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setLabel("windowName");
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = window.getWidget();
        MWindowTest.assertNotNull((Object)widget);
        MWindowTest.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        MWindowTest.assertEquals((String)shell.getText(), (String)window.getLabel());
        MWindowTest.assertEquals((String)"windowName", (String)shell.getText());
        window.setLabel("windowName2");
        MWindowTest.assertEquals((String)shell.getText(), (String)window.getLabel());
        MWindowTest.assertEquals((String)"windowName2", (String)shell.getText());
    }

    public void testWindow_X() {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setX(200);
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = window.getWidget();
        MWindowTest.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        Rectangle bounds = shell.getBounds();
        MWindowTest.assertEquals((int)window.getX(), (int)bounds.x);
        MWindowTest.assertEquals((int)200, (int)bounds.x);
        window.setX(300);
        while (shell.getDisplay().readAndDispatch()) {
        }
        bounds = shell.getBounds();
        MWindowTest.assertEquals((int)300, (int)window.getX());
        MWindowTest.assertEquals((int)window.getX(), (int)bounds.x);
        MWindowTest.assertEquals((int)300, (int)bounds.x);
    }

    public void testWindow_Y() {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setY(200);
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = window.getWidget();
        MWindowTest.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        Rectangle bounds = shell.getBounds();
        MWindowTest.assertEquals((int)window.getY(), (int)bounds.y);
        MWindowTest.assertEquals((int)200, (int)bounds.y);
        window.setY(300);
        while (shell.getDisplay().readAndDispatch()) {
        }
        bounds = shell.getBounds();
        MWindowTest.assertEquals((int)300, (int)window.getY());
        MWindowTest.assertEquals((int)window.getY(), (int)bounds.y);
        MWindowTest.assertEquals((int)300, (int)bounds.y);
    }

    public void testWindow_Width() {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setWidth(200);
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = window.getWidget();
        MWindowTest.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        MWindowTest.assertEquals((int)shell.getBounds().width, (int)window.getWidth());
        MWindowTest.assertEquals((int)200, (int)shell.getBounds().width);
        window.setWidth(300);
        while (shell.getDisplay().readAndDispatch()) {
        }
        MWindowTest.assertEquals((int)shell.getBounds().width, (int)window.getWidth());
        MWindowTest.assertEquals((int)300, (int)shell.getBounds().width);
    }

    public void testWindow_Height() {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setHeight(200);
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Object widget = window.getWidget();
        MWindowTest.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        MWindowTest.assertEquals((int)shell.getBounds().height, (int)window.getHeight());
        MWindowTest.assertEquals((int)200, (int)shell.getBounds().height);
        window.setHeight(300);
        while (shell.getDisplay().readAndDispatch()) {
        }
        MWindowTest.assertEquals((int)shell.getBounds().height, (int)window.getHeight());
        MWindowTest.assertEquals((int)300, (int)shell.getBounds().height);
    }

    private MPart getContributedPart(MWindow window) {
        MPartSashContainer psc = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)psc.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        MWindowTest.assertTrue((String)("part is incorrect type " + part), (boolean)(part instanceof MPart));
        return part;
    }

    private MWindow createWindowWithOneView() {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setHeight(300);
        window.setWidth(400);
        window.setLabel("MyWindow");
        MPartSashContainer sash = MApplicationFactory.eINSTANCE.createPartSashContainer();
        window.getChildren().add((Object)sash);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        sash.getChildren().add((Object)stack);
        MPart contributedPart = MApplicationFactory.eINSTANCE.createPart();
        stack.getChildren().add((Object)contributedPart);
        contributedPart.setLabel("Sample View");
        contributedPart.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }

    private MWindow createWindowWithOneViewAndMenu() {
        MWindow window = this.createWindowWithOneView();
        MMenu menuBar = MApplicationFactory.eINSTANCE.createMenu();
        window.setMainMenu(menuBar);
        MMenuItem fileItem = MApplicationFactory.eINSTANCE.createMenuItem();
        fileItem.setLabel("File");
        fileItem.setId("file");
        menuBar.getChildren().add((Object)fileItem);
        MMenuItem item1 = MApplicationFactory.eINSTANCE.createMenuItem();
        item1.setId("item1");
        item1.setLabel("item1");
        fileItem.getChildren().add((Object)item1);
        MMenuItem item2 = MApplicationFactory.eINSTANCE.createMenuItem();
        item2.setId("item2");
        item2.setLabel("item2");
        fileItem.getChildren().add((Object)item2);
        return window;
    }
}

