/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartDescriptor;
import org.eclipse.e4.ui.model.application.MPartSashContainer;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.workbench.swt.internal.E4Application;
import org.eclipse.e4.workbench.modeling.EPartService;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.internal.E4Workbench;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Display;

public class PartRenderingEngineTests
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.workbench.swt.internal.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        if (this.appContext instanceof IDisposable) {
            ((IDisposable)this.appContext).dispose();
        }
    }

    public void testCreateViewBug298415() {
        MWindow window = this.createWindowWithOneView("Part Name");
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        IPresentationEngine renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        renderer.removeGui((MUIElement)part);
        renderer.removeGui((MUIElement)window);
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public void testAddWindowBug299219() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)window.getWidget());
        MWindow window2 = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window2);
        PartRenderingEngineTests.assertNotNull((Object)window2.getWidget());
    }

    public void testPartStack_SetActiveChildBug299379() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        partA.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        partB.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add((Object)partA);
        stack.getChildren().add((Object)partB);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        service.activate(partB);
        PartRenderingEngineTests.assertEquals((String)"Activating another part should've altered the tab folder's selection", (int)1, (int)tabFolder.getSelectionIndex());
    }

    public void testPartStack_SetActiveChild2Bug299379() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        partA.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        partB.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add((Object)partA);
        stack.getChildren().add((Object)partB);
        stack.setSelectedElement((MUIElement)partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        service.showPart(partB.getId(), EPartService.PartState.ACTIVATE);
        PartRenderingEngineTests.assertEquals((String)"Showing a part should alter the tab folder's selection", (int)1, (int)tabFolder.getSelectionIndex());
    }

    public void testPartStack_SetActiveChild3Bug299379() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MPartDescriptor descriptor = MApplicationFactory.eINSTANCE.createPartDescriptor();
        descriptor.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        descriptor.setId("part");
        descriptor.setCategory("aStack");
        application.getDescriptors().add((Object)descriptor);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        stack.setId("aStack");
        window.getChildren().add((Object)stack);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getItemCount());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart shownPart = service.showPart("part", EPartService.PartState.ACTIVATE);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((String)"The shown part should be the active part", (Object)shownPart, (Object)stack.getSelectedElement());
    }

    public void testPartStack_SetActiveChild4Bug299379() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        partA.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        partB.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add((Object)partA);
        stack.getChildren().add((Object)partB);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        stack.setSelectedElement((MUIElement)partB);
        PartRenderingEngineTests.assertEquals((String)"Switching the active child should've changed the folder's selection", (int)1, (int)tabFolder.getSelectionIndex());
    }

    public void testPartStack_SetActiveChild5Bug295250() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add((Object)partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add((Object)partB);
        PartRenderingEngineTests.assertEquals((String)"Adding a part to a stack should not cause the stack's active child to change", (Object)partA, (Object)stack.getSelectedElement());
        PartRenderingEngineTests.assertNull((String)"The object should not have been instantiated", (Object)partB.getObject());
    }

    public void testPartStack_SetActiveChild6Bug298797() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add((Object)partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add((Object)partB);
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        stack.setSelectedElement((MUIElement)partB);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partB, (Object)stack.getSelectedElement());
    }

    public void testCreateGuiBug301021() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MPartDescriptor descriptor = MApplicationFactory.eINSTANCE.createPartDescriptor();
        descriptor.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        descriptor.setId("part");
        descriptor.setCategory("aStack");
        application.getDescriptors().add((Object)descriptor);
        MPartDescriptor descriptor2 = MApplicationFactory.eINSTANCE.createPartDescriptor();
        descriptor2.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        descriptor2.setId("part2");
        descriptor2.setCategory("aStack");
        application.getDescriptors().add((Object)descriptor2);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        MPartSashContainer partSashContainer = MApplicationFactory.eINSTANCE.createPartSashContainer();
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        stack.setId("aStack");
        partSashContainer.getChildren().add((Object)stack);
        window.getChildren().add((Object)partSashContainer);
        application.getChildren().add((Object)window);
        MWindow window2 = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window2);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        this.wb.createAndRunUI((MApplicationElement)window2);
        EPartService service = (EPartService)window2.getContext().get(EPartService.class.getName());
        service.showPart("part", EPartService.PartState.VISIBLE);
        service.showPart("part", EPartService.PartState.CREATE);
        service.showPart("part2", EPartService.PartState.CREATE);
        while (Display.getDefault().readAndDispatch()) {
        }
    }

    public void testPart_ToBeRendered() {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        partA.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        partB.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add((Object)partA);
        stack.getChildren().add((Object)partB);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        service.activate(partB);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getSelectionIndex());
        partB.setToBeRendered(false);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
    }

    public void testPart_ToBeRendered2() throws Exception {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        partA.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        partB.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partB.setToBeRendered(false);
        stack.getChildren().add((Object)partA);
        stack.getChildren().add((Object)partB);
        stack.setSelectedElement((MUIElement)partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        partB.setToBeRendered(true);
        PartRenderingEngineTests.assertEquals((String)"Rendering another part in the stack should not change the selection", (int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        PartRenderingEngineTests.assertEquals((int)2, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertNotNull((Object)partB.getObject());
    }

    public void testClientObjectUnsetWhenNotRenderedBug301439() {
        MWindow window = this.createWindowWithOneView("");
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.getChildren().add((Object)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        PartRenderingEngineTests.assertNotNull((Object)part.getWidget());
        PartRenderingEngineTests.assertNotNull((Object)part.getRenderer());
        PartRenderingEngineTests.assertNotNull((Object)part.getObject());
        part.setToBeRendered(false);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertNull((Object)part.getWidget());
        PartRenderingEngineTests.assertNull((Object)part.getRenderer());
        PartRenderingEngineTests.assertNull((Object)part.getObject());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getItemCount());
    }

    public void testToBeRenderedCausesSelectionChanges() {
        MApplication application = MApplicationFactory.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        application.getChildren().add((Object)window);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        window.getChildren().add((Object)stack);
        MPart partA = MApplicationFactory.eINSTANCE.createPart();
        partA.setId("partA");
        partA.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = MApplicationFactory.eINSTANCE.createPart();
        partB.setId("partB");
        partB.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add((Object)partA);
        stack.getChildren().add((Object)partB);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        service.activate(partB);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getSelectionIndex());
        service.activate(partA);
        partA.setToBeRendered(false);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partB, (Object)stack.getSelectedElement());
    }

    private MWindow createWindowWithOneView(String partName) {
        MWindow window = MApplicationFactory.eINSTANCE.createWindow();
        window.setHeight(300);
        window.setWidth(400);
        window.setLabel("MyWindow");
        MPartSashContainer sash = MApplicationFactory.eINSTANCE.createPartSashContainer();
        window.getChildren().add((Object)sash);
        MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
        sash.getChildren().add((Object)stack);
        MPart contributedPart = MApplicationFactory.eINSTANCE.createPart();
        stack.getChildren().add((Object)contributedPart);
        contributedPart.setLabel(partName);
        contributedPart.setURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }
}

