/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.tests.Activator;
import org.eclipse.e4.ui.tests.workbench.SWTResult;
import org.eclipse.e4.ui.workbench.swt.internal.PartRenderingEngine;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.internal.ReflectionContributionFactory;
import org.eclipse.e4.workbench.ui.internal.Workbench;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.BundleContext;

public class RenderingTestCase
extends TestCase {
    protected static IContributionFactory contributionFactory = new ReflectionContributionFactory(RegistryFactory.getRegistry());
    protected static IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
    protected static MApplication app = MApplicationFactory.eINSTANCE.createApplication();
    protected static Display display = Display.getCurrent() != null ? Display.getCurrent() : new Display();
    protected IPresentationEngine renderer;
    protected IEclipseContext appContext;
    protected Widget topWidget;
    protected long startTime;

    protected void setUp() throws Exception {
        System.out.println("Setup");
        this.startTime = System.currentTimeMillis();
        super.setUp();
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
        this.appContext = Workbench.createWorkbenchContext((IEclipseContext)serviceContext, (IExtensionRegistry)RegistryFactory.getRegistry(), null, null);
        MApplication app = MApplicationFactory.eINSTANCE.createApplication();
        this.appContext.set(MApplication.class.getName(), (Object)app);
        this.appContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        this.appContext.set(IEclipseContext.class.getName(), (Object)this.appContext);
        app.setContext(this.appContext);
    }

    protected void tearDown() throws Exception {
        System.out.print("tearDown");
        super.tearDown();
        this.appContext = null;
        this.renderer = null;
        if (this.topWidget != null) {
            if (!this.topWidget.isDisposed()) {
                this.topWidget.dispose();
            }
            this.topWidget = null;
        }
        System.out.println("  time: " + (System.currentTimeMillis() - this.startTime) + "ms");
    }

    protected void processEventLoop() {
        if (display != null) {
            while (display.readAndDispatch()) {
            }
        }
    }

    protected Widget createModel(final MWindow window) {
        MApplication application = (MApplication)this.appContext.get(MApplication.class.getName());
        application.getChildren().add((Object)window);
        final Widget[] renderedObject = new Widget[]{null};
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                RenderingTestCase.this.renderer = (PartRenderingEngine)contributionFactory.create("platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.workbench.swt.internal.PartRenderingEngine", RenderingTestCase.this.appContext);
                Object o = RenderingTestCase.this.renderer.createGui((MUIElement)window);
                RenderingTestCase.assertTrue((String)("No widget rendered for: " + window.toString()), (o != null ? 1 : 0) != 0);
                RenderingTestCase.assertTrue((String)("Rendered object is not a Widget: " + o.getClass().getName()), (boolean)(o instanceof Widget));
                renderedObject[0] = (Widget)o;
            }
        });
        return renderedObject[0];
    }

    public void checkResults(SWTResult expected, Widget renderedObject) {
    }
}

