/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.tests.Activator;
import org.eclipse.e4.ui.workbench.swt.internal.ResourceUtility;
import org.eclipse.e4.ui.workbench.swt.internal.WorkbenchWindowHandler;
import org.eclipse.e4.workbench.ui.IResourceUtiltities;
import org.eclipse.e4.workbench.ui.IWorkbenchWindowHandler;
import org.eclipse.e4.workbench.ui.internal.Workbench;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class RunApplicationTest
extends TestCase {
    private ServiceTracker instanceLocation;
    private BundleContext bundleContext;
    private ServiceTracker instanceAppContext;
    private ServiceTracker bundleTracker;
    private Workbench workbench;
    private IEclipseContext applicationContext;
    private Display display;

    public RunApplicationTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.bundleContext = Activator.getDefault().getBundle().getBundleContext();
    }

    protected void tearDown() throws Exception {
        if (this.workbench != null && this.display != null) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    RunApplicationTest.this.workbench.close();
                }
            });
        }
        if (this.instanceLocation != null) {
            this.instanceLocation.close();
            this.instanceLocation = null;
        }
        if (this.instanceAppContext != null) {
            this.instanceAppContext.close();
            this.instanceAppContext = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
    }

    protected Location getInstanceLocation() {
        if (this.instanceLocation == null) {
            Filter filter = null;
            try {
                filter = this.bundleContext.createFilter(Location.INSTANCE_FILTER);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
            this.instanceLocation = new ServiceTracker(this.bundleContext, filter, null);
            this.instanceLocation.open();
        }
        return (Location)this.instanceLocation.getService();
    }

    protected IApplicationContext getApplicationContext() {
        if (this.instanceAppContext == null) {
            this.instanceAppContext = new ServiceTracker(this.bundleContext, IApplicationContext.class.getName(), null);
            this.instanceAppContext.open();
        }
        return (IApplicationContext)this.instanceAppContext.getService();
    }

    protected PackageAdmin getBundleAdmin() {
        if (this.bundleTracker == null) {
            if (this.bundleContext == null) {
                return null;
            }
            this.bundleTracker = new ServiceTracker(this.bundleContext, PackageAdmin.class.getName(), null);
            this.bundleTracker.open();
        }
        return (PackageAdmin)this.bundleTracker.getService();
    }

    protected void launchApplication(final String uri) {
        Runnable app = new Runnable(){

            public void run() {
                RunApplicationTest.this.display = new Display();
                final URI initialWorkbenchDefinitionInstance = URI.createPlatformPluginURI((String)uri, (boolean)true);
                Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)RunApplicationTest.this.display), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)RunApplicationTest.this.bundleContext);
                            RunApplicationTest.this.applicationContext = EclipseContextFactory.create((IEclipseContext)serviceContext, null);
                            RunApplicationTest.this.applicationContext.set("debugString", (Object)"application");
                            RunApplicationTest.this.applicationContext.set(IResourceUtiltities.class.getName(), (Object)new ResourceUtility(RunApplicationTest.this.getBundleAdmin()));
                            RunApplicationTest.this.workbench = new Workbench(RunApplicationTest.this.getInstanceLocation(), RegistryFactory.getRegistry(), RunApplicationTest.this.getBundleAdmin(), RunApplicationTest.this.applicationContext, (IWorkbenchWindowHandler)new WorkbenchWindowHandler(), "platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.workbench.swt.internal.PartRenderingEngine");
                            RunApplicationTest.this.workbench.setWorkbenchModelURI(initialWorkbenchDefinitionInstance);
                            RunApplicationTest.this.workbench.createUIFromModel();
                            RunApplicationTest.this.workbench.run();
                        }
                        catch (ThreadDeath th) {
                            throw th;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        catch (Error err) {
                            err.printStackTrace();
                        }
                    }
                });
            }
        };
        new Thread(app).start();
    }

    public void testSampleLookup() throws Exception {
        this.launchApplication("org.eclipse.e4.ui.tests/xmi/CommandLookup.xmi");
        Thread.sleep(1000L);
        this.display.syncExec(new Runnable(){

            public void run() {
                System.err.println(RunApplicationTest.this.applicationContext.get("debugString"));
            }
        });
    }
}

