/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.internal;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.Logger;
import org.eclipse.e4.core.services.annotations.Optional;
import org.eclipse.e4.core.services.annotations.PostConstruct;
import org.eclipse.e4.core.services.annotations.PreDestroy;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.core.services.context.spi.IEclipseContextStrategy;
import org.eclipse.e4.ui.bindings.keys.KeyBindingDispatcher;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MContext;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MGenericStack;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.e4.ui.workbench.swt.internal.AbstractPartRenderer;
import org.eclipse.e4.ui.workbench.swt.internal.CSSStylingSupport;
import org.eclipse.e4.ui.workbench.swt.internal.E4Testable;
import org.eclipse.e4.ui.workbench.swt.internal.ResourceUtility;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.IResourceUtiltities;
import org.eclipse.e4.workbench.ui.IWorkbench;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.e4.workbench.ui.internal.UISchedulerStrategy;
import org.eclipse.e4.workbench.ui.internal.Workbench;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.testing.TestableObject;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartRenderingEngine
implements IPresentationEngine {
    public static final String engineURI = "platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.workbench.swt.internal.PartRenderingEngine";
    private String defaultRenderingFactoryId;
    private String curFactoryId;
    IRendererFactory curFactory;
    private EventHandler toBeRenderedHandler;
    private EventHandler childrenHandler;
    private IEclipseContext appContext;
    protected Shell testShell;
    protected MApplication theApp;
    @Inject
    @Optional
    protected IEventBroker eventBroker;

    public PartRenderingEngine() {
        this.curFactoryId = this.defaultRenderingFactoryId = "org.eclipse.e4.ui.workbench.renderers.default";
        this.curFactory = null;
        this.toBeRenderedHandler = new EventHandler(){

            public void handleEvent(Event event) {
                AbstractPartRenderer parentRenderer;
                MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
                MElementContainer parent = changedElement.getParent();
                AbstractPartRenderer abstractPartRenderer = parentRenderer = parent != null ? PartRenderingEngine.this.getRendererFor((MUIElement)parent) : null;
                if (parentRenderer == null) {
                    return;
                }
                if (changedElement.isToBeRendered()) {
                    Activator.trace((String)"/trace/renderer", (String)"visible -> true", null);
                    PartRenderingEngine.this.createGui(changedElement);
                } else {
                    Activator.trace((String)"/trace/renderer", (String)"visible -> false", null);
                    PartRenderingEngine.this.removeGui(changedElement);
                }
            }
        };
        this.childrenHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object changedObj = event.getProperty("ChangedElement");
                if (!(changedObj instanceof MElementContainer)) {
                    return;
                }
                MElementContainer changedElement = (MElementContainer)changedObj;
                boolean isApplication = changedObj instanceof MApplication;
                AbstractPartRenderer renderer = PartRenderingEngine.this.getRendererFor((MUIElement)changedElement);
                if (!isApplication && renderer == null) {
                    return;
                }
                String eventType = (String)event.getProperty("EventType");
                if ("ADD".equals(eventType)) {
                    boolean renderIt;
                    Activator.trace((String)"/trace/renderer", (String)"Child Added", null);
                    MUIElement added = (MUIElement)event.getProperty("NewValue");
                    boolean isStack = changedObj instanceof MGenericStack;
                    boolean hasWidget = added.getWidget() != null;
                    boolean isSelected = added == changedElement.getSelectedElement();
                    boolean bl = renderIt = !isStack || hasWidget || isSelected;
                    if (renderIt) {
                        Widget w = (Widget)PartRenderingEngine.this.createGui(added);
                        if (w instanceof Control && !(w instanceof Shell)) {
                            ((Control)w).getShell().layout(new Control[]{(Control)w}, 4);
                        }
                    } else if (renderer != null) {
                        renderer.childRendered((MElementContainer<MUIElement>)changedElement, added);
                    }
                } else if ("REMOVE".equals(eventType)) {
                    Activator.trace((String)"/trace/renderer", (String)"Child Removed", null);
                    MUIElement removed = (MUIElement)event.getProperty("OldValue");
                    if (!removed.isToBeRendered()) {
                        return;
                    }
                    if (removed.getWidget() instanceof Control) {
                        Control ctrl = (Control)removed.getWidget();
                        ctrl.setLayoutData(null);
                        ctrl.getParent().layout(new Control[]{ctrl}, 6);
                    }
                    if (renderer != null) {
                        renderer.hideChild((MElementContainer<MUIElement>)changedElement, removed);
                    }
                }
            }
        };
    }

    public PartRenderingEngine(String curFactoryId) {
        this.curFactoryId = this.defaultRenderingFactoryId = "org.eclipse.e4.ui.workbench.renderers.default";
        this.curFactory = null;
        this.toBeRenderedHandler = new /* invalid duplicate definition of identical inner class */;
        this.childrenHandler = new /* invalid duplicate definition of identical inner class */;
        this.curFactoryId = curFactoryId;
    }

    @PostConstruct
    private void initialize(IEclipseContext context) {
        this.appContext = context;
        IExtensionRegistry registry = (IExtensionRegistry)context.get(IExtensionRegistry.class.getName());
        IConfigurationElement[] factories = registry.getConfigurationElementsFor("org.eclipse.e4.workbench.rendererfactory");
        int i = 0;
        while (i < factories.length) {
            String id = factories[i].getAttribute("id");
            if (this.curFactoryId.equals(id)) {
                IRendererFactory factory = null;
                try {
                    factory = (IRendererFactory)factories[i].createExecutableExtension("class");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                if (factory != null) {
                    factory.init(context);
                    this.curFactory = factory;
                }
            }
            ++i;
        }
        context.set(IPresentationEngine.class.getName(), (Object)this);
        IEventBroker eventBroker = (IEventBroker)context.get(IEventBroker.class.getName());
        eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/UIElement", (String)"toBeRendered"), this.toBeRenderedHandler);
        eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/ElementContainer", (String)"children"), this.childrenHandler);
    }

    @PreDestroy
    private void contextDisposed() {
        if (this.eventBroker == null) {
            return;
        }
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
    }

    private static void populateModelInterfaces(MContext contextModel, IEclipseContext context, Class<?>[] interfaces) {
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            Activator.trace((String)"/trace/eclipse.context", (String)("Adding " + intf.getName() + " for " + contextModel.getClass().getName()), null);
            context.set(intf.getName(), (Object)contextModel);
            PartRenderingEngine.populateModelInterfaces(contextModel, context, intf.getInterfaces());
            ++n2;
        }
    }

    public Object createGui(MUIElement element, Object parent) {
        MContext ctxt;
        IEclipseContext lclContext;
        MContext ctxt2;
        if (!element.isToBeRendered()) {
            return null;
        }
        if (element instanceof MContext && (ctxt2 = (MContext)element).getContext() == null) {
            IEclipseContext parentContext = element.getParent() == null ? this.appContext : this.getContext((MElementContainer<MUIElement>)element.getParent());
            lclContext = EclipseContextFactory.create((IEclipseContext)parentContext, (IEclipseContextStrategy)UISchedulerStrategy.getInstance());
            PartRenderingEngine.populateModelInterfaces(ctxt2, lclContext, element.getClass().getInterfaces());
            ctxt2.setContext(lclContext);
            for (String variable : ctxt2.getVariables()) {
                lclContext.declareModifiable(variable);
            }
            Workbench.processHierarchy((Object)element);
        }
        if (element.getWidget() != null && parent instanceof Composite && element.getWidget() instanceof Control) {
            final Composite p = (Composite)parent;
            Control c = (Control)element.getWidget();
            if (c.getParent() == parent) {
                return c;
            }
            c.setVisible(true);
            c.setLayoutData(null);
            c.setParent(p);
            final Control[] changed = new Control[]{c};
            c.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    p.layout(changed, 6);
                    p.getShell().layout(changed, 6);
                }
            });
            if (element instanceof MContext) {
                IEclipseContext ec = ((MContext)element).getContext();
                IEclipseContext pc = this.getContext((MElementContainer<MUIElement>)element.getParent());
                ec.set("parentContext", (Object)pc);
            }
            this.getRendererFor((MUIElement)element.getParent()).childRendered((MElementContainer<MUIElement>)element.getParent(), element);
            return c;
        }
        Object newWidget = this.createWidget(element, parent);
        if (newWidget != null) {
            MElementContainer parentElement;
            AbstractPartRenderer parentRenderer;
            AbstractPartRenderer renderer = this.getRendererFor(element);
            renderer.hookControllerLogic(element);
            if (element instanceof MElementContainer) {
                renderer.processContents((MElementContainer<MUIElement>)((MElementContainer)element));
            }
            renderer.postProcess(element);
            if (element.getParent() instanceof MUIElement && (parentRenderer = this.getRendererFor((MUIElement)(parentElement = element.getParent()))) != null) {
                parentRenderer.childRendered((MElementContainer<MUIElement>)parentElement, element);
            }
        } else if (element instanceof MContext && (lclContext = (ctxt = (MContext)element).getContext()) instanceof IDisposable) {
            ((IDisposable)lclContext).dispose();
        }
        return newWidget;
    }

    private IEclipseContext getContext(MElementContainer<MUIElement> parent) {
        MElementContainer uiElement = parent;
        while (uiElement != null) {
            if (uiElement instanceof MContext) {
                return ((MContext)uiElement).getContext();
            }
            uiElement = uiElement.getParent();
        }
        return null;
    }

    public Object createGui(MUIElement element) {
        AbstractPartRenderer renderer;
        Object parent = null;
        MElementContainer parentME = element.getParent();
        if (parentME != null && (renderer = this.getRendererFor((MUIElement)parentME)) != null) {
            parent = renderer.getUIContainer(element);
        }
        return this.createGui(element, parent);
    }

    public void removeGui(MUIElement element) {
        AbstractPartRenderer parentRenderer;
        AbstractPartRenderer renderer = this.getRendererFor(element);
        Assert.isNotNull((Object)renderer);
        MElementContainer parent = element.getParent();
        AbstractPartRenderer abstractPartRenderer = parentRenderer = parent != null ? this.getRendererFor((MUIElement)parent) : null;
        if (parentRenderer != null) {
            parentRenderer.hideChild((MElementContainer<MUIElement>)element.getParent(), element);
        }
        renderer.disposeWidget(element);
        if (element instanceof MContribution) {
            ((MContribution)element).setObject(null);
        }
        if (element instanceof MContext) {
            MContext ctxt = (MContext)element;
            IEclipseContext lclContext = ctxt.getContext();
            ctxt.setContext(null);
            if (lclContext instanceof IDisposable) {
                ((IDisposable)lclContext).dispose();
            }
        }
    }

    protected Object createWidget(MUIElement element, Object parent) {
        Object newWidget;
        AbstractPartRenderer renderer = this.getRenderer(element, parent);
        if (renderer != null && (newWidget = renderer.createWidget(element, parent)) != null) {
            renderer.bindWidget(element, newWidget);
            return newWidget;
        }
        return null;
    }

    private AbstractPartRenderer getRenderer(MUIElement uiElement, Object parent) {
        return this.curFactory.getRenderer(uiElement, parent);
    }

    protected AbstractPartRenderer getRendererFor(MUIElement element) {
        return (AbstractPartRenderer)element.getRenderer();
    }

    private static void initializeNullStyling(IEclipseContext appContext) {
        appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

            public void setClassname(Object widget, String classname) {
            }

            public void setId(Object widget, String id) {
            }

            public void style(Object widget) {
            }
        });
    }

    public Object run(final MApplicationElement uiRoot, final IEclipseContext appContext) {
        final Display display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            public void run() {
                block19: {
                    Logger logger;
                    String cssURI = (String)appContext.get("applicationCSS");
                    if (cssURI != null) {
                        String cssResourcesURI = (String)appContext.get("applicationCSSResources");
                        CSSStylingSupport.initializeStyling(display, cssURI, cssResourcesURI, appContext);
                    } else {
                        PartRenderingEngine.initializeNullStyling(appContext);
                    }
                    appContext.set(IResourceUtiltities.class.getName(), (Object)new ResourceUtility(Activator.getDefault().getBundleAdmin()));
                    try {
                        KeyBindingDispatcher dispatcher = (KeyBindingDispatcher)ContextInjectionFactory.make(KeyBindingDispatcher.class, (IEclipseContext)appContext);
                        KeyBindingDispatcher.KeyDownFilter listener = dispatcher.getKeyDownFilter();
                        display.addFilter(1, (Listener)listener);
                        display.addFilter(31, (Listener)listener);
                    }
                    catch (InvocationTargetException e) {
                        logger = (Logger)appContext.get(Logger.class.getName());
                        if (logger != null) {
                            logger.error((Throwable)e);
                        }
                    }
                    catch (InstantiationException e) {
                        logger = (Logger)appContext.get(Logger.class.getName());
                        if (logger == null) break block19;
                        logger.error((Throwable)e);
                    }
                }
                PartRenderingEngine.this.testShell = null;
                PartRenderingEngine.this.theApp = null;
                boolean spinOnce = true;
                if (uiRoot instanceof MApplication) {
                    spinOnce = false;
                    PartRenderingEngine.this.theApp = (MApplication)uiRoot;
                    for (MWindow window : PartRenderingEngine.this.theApp.getChildren()) {
                        PartRenderingEngine.this.testShell = (Shell)PartRenderingEngine.this.createGui((MUIElement)window);
                    }
                } else if (uiRoot instanceof MUIElement) {
                    if (uiRoot instanceof MWindow) {
                        PartRenderingEngine.this.testShell = (Shell)PartRenderingEngine.this.createGui((MUIElement)uiRoot);
                    } else {
                        PartRenderingEngine.this.testShell = new Shell(display, 1264);
                        PartRenderingEngine.this.createGui((MUIElement)uiRoot, PartRenderingEngine.this.testShell);
                    }
                }
                TestableObject testableObject = (TestableObject)appContext.get(TestableObject.class.getName());
                if (testableObject instanceof E4Testable) {
                    ((E4Testable)testableObject).init(display, (IWorkbench)appContext.get(IWorkbench.class.getName()));
                }
                while (PartRenderingEngine.this.testShell != null && !PartRenderingEngine.this.testShell.isDisposed() && !display.isDisposed()) {
                    try {
                        if (display.readAndDispatch()) continue;
                        if (spinOnce) {
                            return;
                        }
                        display.sleep();
                    }
                    catch (ThreadDeath th) {
                        throw th;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    catch (Error err) {
                        err.printStackTrace();
                    }
                }
            }
        });
        return IApplication.EXIT_OK;
    }

    public void stop() {
        if (this.theApp != null) {
            for (MWindow window : this.theApp.getChildren()) {
                if (window.getWidget() == null) continue;
                ((Shell)window.getWidget()).close();
            }
        } else if (this.testShell != null && !this.testShell.isDisposed()) {
            this.testShell.close();
        }
    }
}

