/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.util.List;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.Logger;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.IWorkbench;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.e4.workbench.ui.internal.E4CommandProcessor;
import org.eclipse.e4.workbench.ui.internal.UIEventPublisher;
import org.eclipse.e4.workbench.ui.internal.Workbench;
import org.eclipse.emf.common.notify.Notifier;
import org.osgi.framework.BundleContext;

public class E4Workbench
implements IWorkbench {
    public static final String LOCAL_ACTIVE_SHELL = "localActiveShell";
    public static final String XMI_URI_ARG = "applicationXMI";
    public static final String CSS_URI_ARG = "applicationCSS";
    public static final String CSS_RESOURCE_URI_ARG = "applicationCSSResources";
    public static final String PRESENTATION_URI_ARG = "presentationURI";
    IEclipseContext appContext;
    IPresentationEngine renderer;

    public IEclipseContext getContext() {
        return this.appContext;
    }

    public E4Workbench(MApplicationElement uiRoot, IEclipseContext applicationContext) {
        this.appContext = applicationContext;
        this.appContext.set(IWorkbench.class.getName(), (Object)this);
        if (uiRoot instanceof MApplication) {
            this.init((MApplication)uiRoot);
        }
        ((Notifier)uiRoot).eAdapters().add((Object)new UIEventPublisher(this.appContext));
    }

    public void createAndRunUI(MApplicationElement uiRoot) {
        this.renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        if (this.renderer == null) {
            String presentationURI = (String)this.appContext.get(PRESENTATION_URI_ARG);
            if (presentationURI != null) {
                IContributionFactory factory = (IContributionFactory)this.appContext.get(IContributionFactory.class.getName());
                this.renderer = (IPresentationEngine)factory.create(presentationURI, this.appContext);
                this.appContext.set(IPresentationEngine.class.getName(), (Object)this.renderer);
            }
            if (this.renderer == null) {
                Logger logger = (Logger)this.appContext.get(Logger.class.getName());
                logger.error("Failed to create the presentation engine for URI: " + presentationURI);
            }
        }
        if (this.renderer != null) {
            this.renderer.run(uiRoot, this.appContext);
        }
    }

    private void init(MApplication appElement) {
        Activator.trace("/trace/workbench", "init() workbench", null);
        E4CommandProcessor.processCommands(appElement.getContext(), (List<MCommand>)appElement.getCommands());
        Workbench.processHierarchy(appElement);
    }

    public boolean close() {
        if (this.renderer != null) {
            this.renderer.stop();
        }
        return true;
    }

    public int run() {
        return 0;
    }

    public static IEclipseContext getServiceContext() {
        return EclipseContextFactory.getServiceContext((BundleContext)Activator.getDefault().getContext());
    }
}

