/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.e4.core.services.Logger;
import org.eclipse.e4.workbench.modeling.IModelReconcilingService;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;
import org.eclipse.e4.workbench.ui.internal.XMLModelReconciler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelReconcilingService
implements IModelReconcilingService {
    @Inject
    private Logger logger;

    @Override
    public ModelReconciler createModelReconciler() {
        return new XMLModelReconciler();
    }

    @Override
    public IStatus applyDeltas(Collection<ModelDelta> deltas) {
        return this.applyDeltas(deltas, null);
    }

    @Override
    public IStatus applyDeltas(Collection<ModelDelta> deltas, String[] filters) {
        if (filters == null) {
            filters = new String[]{};
        }
        MultiStatus multiStatus = new MultiStatus("org.eclipse.e4.ui.workbench", 0, "", null);
        LinkedList<ModelDelta> delayedDeltas = new LinkedList<ModelDelta>();
        block5: for (ModelDelta delta : deltas) {
            String[] stringArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                if (delta.getAttributeName().equals(filter)) continue block5;
                ++n2;
            }
            IStatus status = delta.apply();
            if (status.getSeverity() == 8) {
                delayedDeltas.add(delta);
                continue;
            }
            multiStatus.add(status);
            switch (status.getCode()) {
                case 1: {
                    this.logger.info(status.getMessage());
                    break;
                }
                case 2: {
                    this.logger.warn(status.getMessage());
                    break;
                }
                case 4: {
                    this.logger.error(status.getMessage());
                }
            }
        }
        Iterator it = delayedDeltas.iterator();
        while (it.hasNext()) {
            ModelDelta delta = (ModelDelta)it.next();
            if (!delta.apply().isOK()) continue;
            it.remove();
        }
        return multiStatus;
    }
}

