/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.services.Logger;
import org.eclipse.e4.core.services.annotations.Optional;
import org.eclipse.e4.core.services.annotations.PostConstruct;
import org.eclipse.e4.core.services.annotations.PreDestroy;
import org.eclipse.e4.core.services.context.ContextChangeEvent;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.IRunAndTrack;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MContext;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartDescriptor;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.services.events.IEventBroker;
import org.eclipse.e4.workbench.modeling.EModelService;
import org.eclipse.e4.workbench.modeling.EPartService;
import org.eclipse.e4.workbench.modeling.IPartListener;
import org.eclipse.e4.workbench.modeling.ISaveHandler;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartServiceImpl
implements EPartService {
    private EventHandler selectedHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Object selected = event.getProperty("NewValue");
            if (selected instanceof MPart && ((MPart)selected).isToBeRendered()) {
                PartServiceImpl.this.firePartBroughtToTop((MPart)selected);
            }
        }
    };
    @Inject
    private MApplication application;
    @Inject
    @Named(value="partServiceRoot")
    @Optional
    private MElementContainer<MUIElement> rootContainer;
    @Inject
    private IPresentationEngine engine;
    @Inject
    private EModelService modelService;
    @Inject
    private Logger logger;
    @Inject
    private ISaveHandler saveHandler;
    @Inject
    private IEventBroker eventBroker;
    private MPart activePart;
    private ListenerList listeners = new ListenerList();
    private boolean constructed = false;

    public static void addListener(IEventBroker broker) {
        EventHandler windowHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MContext contextAware;
                IEclipseContext context;
                Object element = event.getProperty("ChangedElement");
                if (element instanceof MWindow && (context = (contextAware = (MContext)element).getContext()) != null) {
                    context.set("partServiceRoot", element);
                }
            }
        };
        broker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/application/Context", "context"), windowHandler);
    }

    @Inject
    void setPart(@Optional @Named(value="e4ActivePart") MPart p) {
        this.activePart = p;
        if (this.constructed && p != null) {
            this.firePartActivated(p);
        }
    }

    @PostConstruct
    void postConstruct() {
        this.eventBroker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/application/ElementContainer", "selectedElement"), this.selectedHandler);
        this.constructed = true;
        if (this.rootContainer == null) {
            this.application.getContext().runAndTrack(new IRunAndTrack(){

                public boolean notify(ContextChangeEvent event) {
                    IEclipseContext childContext = (IEclipseContext)event.getContext().getLocal("activeChildContext");
                    if (childContext != null) {
                        PartServiceImpl.this.rootContainer = (MElementContainer)childContext.get(MWindow.class.getName());
                    }
                    return true;
                }
            }, null);
        }
    }

    @PreDestroy
    void preDestroy() {
        this.constructed = false;
        this.eventBroker.unsubscribe(this.selectedHandler);
    }

    private void firePartActivated(MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPartListener)listener).partActivated(part);
            ++n2;
        }
    }

    private void firePartBroughtToTop(MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPartListener)listener).partBroughtToTop(part);
            ++n2;
        }
    }

    @Override
    public void addPartListener(IPartListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removePartListener(IPartListener listener) {
        this.listeners.remove((Object)listener);
    }

    private MContext getParentWithContext(MUIElement part) {
        MElementContainer parent = part.getParent();
        while (parent != null) {
            if (parent instanceof MContext && ((MContext)parent).getContext() != null) {
                return (MContext)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Override
    public void bringToTop(MPart part) {
        if (this.isInContainer(part)) {
            part.setToBeRendered(true);
            this.internalBringToTop(part);
        }
    }

    private void internalBringToTop(MPart part) {
        MElementContainer parent = part.getParent();
        MPart oldSelectedElement = (MPart)parent.getSelectedElement();
        if (oldSelectedElement != part) {
            parent.setSelectedElement((MUIElement)part);
            this.internalFixContext(part, oldSelectedElement);
        }
    }

    private void internalFixContext(MPart part, MPart oldSelectedElement) {
        MContext parentPart;
        MContext mContext = parentPart = oldSelectedElement == null ? null : this.getParentWithContext((MUIElement)oldSelectedElement);
        if (parentPart == null) {
            return;
        }
        IEclipseContext parentContext = parentPart.getContext();
        IEclipseContext oldContext = oldSelectedElement.getContext();
        Object child = parentContext.get("activeChildContext");
        if (child == oldContext) {
            parentContext.set("activeChildContext", (Object)(part == null ? null : part.getContext()));
        }
    }

    @Override
    public MPart findPart(String id) {
        MUIElement element = this.modelService.find(id, (MUIElement)this.rootContainer);
        return element instanceof MPart ? (MPart)element : null;
    }

    @Override
    public Collection<MPart> getParts() {
        return this.modelService.findElements((MUIElement)this.rootContainer, null, MPart.class, null);
    }

    @Override
    public boolean isPartVisible(MPart part) {
        if (this.isInContainer(part)) {
            MElementContainer parent = part.getParent();
            if (parent instanceof MPartStack) {
                return parent.getSelectedElement() == part;
            }
            return part.isVisible();
        }
        return false;
    }

    private boolean isInContainer(MPart part) {
        return this.isInContainer(this.rootContainer, part);
    }

    private boolean isInContainer(MElementContainer<?> container, MPart part) {
        for (Object object : container.getChildren()) {
            if (object == part) {
                return true;
            }
            if (!(object instanceof MElementContainer) || !this.isInContainer((MElementContainer)object, part)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void activate(MPart part) {
        if (!this.isInContainer(part)) {
            return;
        }
        curContext = part.getContext();
        pwc = this.getParentWithContext((MUIElement)part);
        curElement = part;
        ** GOTO lbl20
        {
            parent = curElement.getParent();
            curElement.setToBeRendered(true);
            if (parent.getSelectedElement() != curElement) {
                parent.setSelectedElement((MUIElement)curElement);
            }
            curElement = parent;
            do {
                if (curElement != pwc) continue block0;
                if (curContext == null) {
                    curContext = part.getContext();
                }
                if ((parentContext = pwc.getContext()) != null) {
                    parentContext.set("activeChildContext", (Object)curContext);
                    curContext = parentContext;
                }
                pwc = this.getParentWithContext((MUIElement)pwc);
lbl20:
                // 2 sources

            } while (pwc != null);
        }
    }

    @Override
    public MPart getActivePart() {
        return this.activePart;
    }

    @Override
    public void deactivate(MPart part) {
        MElementContainer parent = part.getParent();
        MPart oldSelectedElement = (MPart)parent.getSelectedElement();
        if (oldSelectedElement == part) {
            parent.setSelectedElement(null);
            this.internalFixContext(null, oldSelectedElement);
        }
    }

    private MPartDescriptor findDescriptor(String id) {
        for (MPartDescriptor descriptor : this.application.getDescriptors()) {
            if (!descriptor.getId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    private MPart createPart(MPartDescriptor descriptor) {
        return descriptor == null ? null : (MPart)EcoreUtil.copy((EObject)((EObject)descriptor));
    }

    @Override
    public MPart createPart(String id) {
        MPartDescriptor descriptor = this.findDescriptor(id);
        return this.createPart(descriptor);
    }

    private MPart addPart(MPart providedPart, MPart localPart) {
        if (providedPart == localPart && this.isInContainer(providedPart)) {
            return providedPart;
        }
        MPartDescriptor descriptor = this.findDescriptor(providedPart.getId());
        if (descriptor == null) {
            if (providedPart != localPart) {
                MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
                stack.getChildren().add((Object)providedPart);
                this.rootContainer.getChildren().add((Object)stack);
            }
        } else {
            if (providedPart != localPart && !descriptor.isAllowMultiple()) {
                return localPart;
            }
            String category = descriptor.getCategory();
            MUIElement container = this.modelService.find(category, (MUIElement)this.rootContainer);
            if (container instanceof MElementContainer) {
                ((MElementContainer)container).getChildren().add((Object)providedPart);
            } else {
                MElementContainer<?> lastContainer = this.getLastContainer();
                lastContainer.getChildren().add(providedPart);
                String id = lastContainer.getId();
                if (id == null || id.length() == 0) {
                    lastContainer.setId(category);
                }
            }
        }
        return providedPart;
    }

    private MElementContainer<?> getLastContainer() {
        EList children = this.rootContainer.getChildren();
        if (children.size() == 0) {
            MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
            this.rootContainer.getChildren().add((Object)stack);
            return stack;
        }
        MElementContainer<?> lastContainer = this.getLastContainer(this.rootContainer, (List<?>)children);
        if (lastContainer == null) {
            MPartStack stack = MApplicationFactory.eINSTANCE.createPartStack();
            this.rootContainer.getChildren().add((Object)stack);
            return stack;
        }
        return lastContainer;
    }

    private MElementContainer<?> getLastContainer(MElementContainer<?> container, List<?> children) {
        if (children.isEmpty()) {
            return null;
        }
        int i = children.size() - 1;
        while (i > -1) {
            MElementContainer childContainer;
            MElementContainer<?> lastContainer;
            Object muiElement = children.get(i);
            if (muiElement instanceof MElementContainer && (lastContainer = this.getLastContainer((MElementContainer<?>)(childContainer = (MElementContainer)muiElement), (List<?>)childContainer.getChildren())) != null) {
                return lastContainer;
            }
            --i;
        }
        return container;
    }

    private MPart showExistingPart(EPartService.PartState partState, MPart providedPart, MPart localPart) {
        MPart part = this.addPart(providedPart, localPart);
        switch (partState) {
            case ACTIVATE: {
                this.activate(part);
                return part;
            }
            case VISIBLE: {
                MPart activePart = this.getActivePart();
                if (activePart == part) {
                    part.setToBeRendered(true);
                } else if (activePart.getParent() == part.getParent()) {
                    part.setToBeRendered(true);
                    this.engine.createGui((MUIElement)part);
                } else {
                    this.bringToTop(part);
                }
                return part;
            }
            case CREATE: {
                part.setToBeRendered(true);
                this.engine.createGui((MUIElement)part);
                return part;
            }
        }
        return part;
    }

    private MPart showNewPart(MPart part, EPartService.PartState partState) {
        part = this.addPart(part, part);
        MPart activePart = this.getActivePart();
        if (activePart == null) {
            this.activate(part);
            return part;
        }
        switch (partState) {
            case ACTIVATE: {
                this.activate(part);
                return part;
            }
            case VISIBLE: {
                if (activePart.getParent() == part.getParent()) break;
                this.bringToTop(part);
            }
        }
        return part;
    }

    @Override
    public MPart showPart(String id, EPartService.PartState partState) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)((Object)partState));
        MPart part = this.findPart(id);
        if (part != null) {
            return this.showPart(part, partState);
        }
        MPartDescriptor descriptor = this.findDescriptor(id);
        part = this.createPart(descriptor);
        if (part == null) {
            return null;
        }
        return this.showNewPart(part, partState);
    }

    @Override
    public MPart showPart(MPart part, EPartService.PartState partState) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)((Object)partState));
        MPart localPart = this.findPart(part.getId());
        if (localPart != null) {
            return this.showExistingPart(partState, part, localPart);
        }
        return this.showNewPart(part, partState);
    }

    @Override
    public void hidePart(MPart part) {
        if (this.isInContainer(part)) {
            part.setToBeRendered(false);
            if (part.getTags().contains((Object)"removeOnHide")) {
                MElementContainer parent = part.getParent();
                EList children = parent.getChildren();
                children.remove((Object)part);
                if (parent.getSelectedElement() == part && !children.isEmpty()) {
                    parent.setSelectedElement((MUIElement)children.get(0));
                }
            }
        }
    }

    @Override
    public Collection<MPart> getDirtyParts() {
        ArrayList<MPart> dirtyParts = new ArrayList<MPart>();
        for (MPart part : this.getParts()) {
            if (!part.isDirty()) continue;
            dirtyParts.add(part);
        }
        return dirtyParts;
    }

    @Override
    public boolean savePart(MPart part, boolean confirm) {
        if (!part.isDirty()) {
            return true;
        }
        if (confirm && this.saveHandler != null) {
            switch (this.saveHandler.promptToSave(part)) {
                case NO: {
                    return true;
                }
                case CANCEL: {
                    return false;
                }
            }
        }
        Object client = part.getObject();
        try {
            ContextInjectionFactory.invoke((Object)client, (String)"doSave", (IEclipseContext)part.getContext());
        }
        catch (InvocationTargetException e) {
            this.logger.error(e.getCause());
            return false;
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            Throwable throwable = status.getException();
            if (throwable == null) {
                this.logger.error(status.getMessage());
            } else {
                this.logger.error(throwable);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean saveAll(boolean confirm) {
        Collection<MPart> dirtyParts = this.getDirtyParts();
        if (dirtyParts.isEmpty()) {
            return true;
        }
        if (confirm) {
            ISaveHandler.Save[] decisions;
            List<MPart> dirtyPartsList = Collections.unmodifiableList(new ArrayList<MPart>(dirtyParts));
            ISaveHandler.Save[] saveArray = decisions = this.saveHandler.promptToSave(dirtyPartsList);
            int n = decisions.length;
            int n2 = 0;
            while (n2 < n) {
                ISaveHandler.Save decision = saveArray[n2];
                if (decision == ISaveHandler.Save.CANCEL) {
                    return false;
                }
                ++n2;
            }
            boolean success = true;
            int i = 0;
            while (i < decisions.length) {
                if (decisions[i] == ISaveHandler.Save.YES && !this.savePart(dirtyPartsList.get(i), false)) {
                    return false;
                }
                ++i;
            }
            return success;
        }
        boolean success = true;
        for (MPart dirtyPart : dirtyParts) {
            if (this.savePart(dirtyPart, false)) continue;
            success = false;
        }
        return success;
    }
}

