/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.IContributionFactorySpi;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

public class ReflectionContributionFactory
implements IContributionFactory {
    private IExtensionRegistry registry;
    private Map<String, Object> languages;

    public ReflectionContributionFactory(IExtensionRegistry registry) {
        this.registry = registry;
        this.processLanguages();
    }

    public Object call(Object object, String uriString, String methodName, IEclipseContext context, Object defaultValue) {
        URI uri;
        if (uriString != null && (uri = URI.createURI((String)uriString)).segmentCount() > 3) {
            String prefix = uri.segment(2);
            IContributionFactorySpi factory = (IContributionFactorySpi)this.languages.get(prefix);
            return factory.call(object, methodName, context, defaultValue);
        }
        Method targetMethod = null;
        Method[] methods = object.getClass().getMethods();
        if (methods.length == 1) {
            targetMethod = methods[0];
        } else {
            ArrayList<Method> toSort = new ArrayList<Method>();
            int i = 0;
            while (i < methods.length) {
                Method method = methods[i];
                if ((method.getModifiers() & 1) != 0 && method.getName().equals(methodName)) {
                    toSort.add(method);
                }
                ++i;
            }
            Collections.sort(toSort, new Comparator<Method>(){

                @Override
                public int compare(Method m1, Method m2) {
                    int l1 = m1.getParameterTypes().length;
                    int l2 = m2.getParameterTypes().length;
                    return l1 - l2;
                }
            });
            Iterator iter = toSort.iterator();
            while (iter.hasNext() && targetMethod == null) {
                Method next = (Method)iter.next();
                boolean satisfiable = true;
                Class<?>[] params = next.getParameterTypes();
                int i2 = 0;
                while (i2 < params.length && satisfiable) {
                    Class<?> clazz = params[i2];
                    if (!context.containsKey(clazz.getName()) && !IEclipseContext.class.equals(clazz)) {
                        satisfiable = false;
                    }
                    ++i2;
                }
                if (!satisfiable) continue;
                targetMethod = next;
            }
        }
        if (targetMethod == null) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw new RuntimeException("could not find satisfiable method " + methodName + " in class " + object.getClass());
        }
        Class<?>[] paramKeys = targetMethod.getParameterTypes();
        try {
            Activator.trace("/trace/commands", "calling: " + methodName, null);
            Object[] params = new Object[paramKeys.length];
            int i = 0;
            while (i < params.length) {
                params[i] = IEclipseContext.class.equals(paramKeys[i]) ? context : context.get(paramKeys[i].getName());
                ++i;
            }
            return targetMethod.invoke(object, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public Object create(String uriString, IEclipseContext context) {
        Object contribution;
        if (uriString == null) {
            return null;
        }
        URI uri = URI.createURI((String)uriString);
        Bundle bundle = this.getBundle(uri);
        if (bundle != null) {
            contribution = this.createFromBundle(bundle, context, uri);
        } else {
            contribution = null;
            Activator.log(1, "Unable to retrive the bundle from the URI: " + uriString);
        }
        return contribution;
    }

    protected Object createFromBundle(Bundle bundle, IEclipseContext context, URI uri) {
        Object contribution;
        if (uri.segmentCount() > 3) {
            String prefix = uri.segment(2);
            IContributionFactorySpi factory = (IContributionFactorySpi)this.languages.get(prefix);
            StringBuffer resource = new StringBuffer(uri.segment(3));
            int i = 4;
            while (i < uri.segmentCount()) {
                resource.append('/');
                resource.append(uri.segment(i));
                ++i;
            }
            contribution = factory.create(bundle, resource.toString(), context);
        } else {
            String clazz = uri.segment(2);
            try {
                Class targetClass = bundle.loadClass(clazz);
                contribution = ContextInjectionFactory.make((Class)targetClass, (IEclipseContext)context);
            }
            catch (ClassNotFoundException e) {
                contribution = null;
                String message = "Unable to load class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                Activator.log(1, message, e);
            }
            catch (InvocationTargetException e) {
                contribution = null;
                String message = "Unable to instantiate class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                Activator.log(1, message, e);
            }
            catch (InstantiationException e) {
                contribution = null;
                String message = "Unable to instantiate class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                Activator.log(1, message, e);
            }
        }
        return contribution;
    }

    protected void processLanguages() {
        this.languages = new HashMap<String, Object>();
        String extId = "org.eclipse.e4.languages";
        IConfigurationElement[] languageElements = this.registry.getConfigurationElementsFor(extId);
        int i = 0;
        while (i < languageElements.length) {
            IConfigurationElement languageElement = languageElements[i];
            try {
                this.languages.put(languageElement.getAttribute("name"), languageElement.createExecutableExtension("contributionFactory"));
            }
            catch (InvalidRegistryObjectException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected Bundle getBundle(URI platformURI) {
        return Activator.getDefault().getBundleForName(platformURI.segment(1));
    }
}

