/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.e4.core.services.Logger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationPackage;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.e4.workbench.ui.internal.E4XMIResourceFactory;
import org.eclipse.e4.workbench.ui.internal.ModelExtensionProcessor;
import org.eclipse.e4.workbench.ui.internal.ModelReconcilingService;
import org.eclipse.e4.workbench.ui.internal.XMLModelReconciler;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class ResourceHandler {
    private static final boolean RESTORE_VIA_DELTAS = true;
    private File workbenchData;
    private URI applicationDefinitionInstance;
    private ResourceSetImpl resourceSetImpl;
    private URI restoreLocation;
    private Resource resource;
    private ModelReconciler reconciler;
    private Logger logger;

    public ResourceHandler(Location instanceLocation, URI applicationDefinitionInstance, boolean saveAndRestore, Logger logger) {
        this.applicationDefinitionInstance = applicationDefinitionInstance;
        this.logger = logger;
        this.resourceSetImpl = new ResourceSetImpl();
        this.resourceSetImpl.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new E4XMIResourceFactory());
        this.resourceSetImpl.getPackageRegistry().put((Object)"http://www.eclipse.org/ui/2008/UIModel", (Object)MApplicationPackage.eINSTANCE);
        try {
            this.workbenchData = new File(URIUtil.toURI((URL)instanceLocation.getURL()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.workbenchData = new File(this.workbenchData, ".metadata");
        this.workbenchData = new File(this.workbenchData, ".plugins");
        this.workbenchData = new File(this.workbenchData, "org.eclipse.e4.workbench");
        this.workbenchData = new File(this.workbenchData, "deltas.xml");
        if (this.workbenchData != null && saveAndRestore) {
            this.restoreLocation = URI.createFileURI((String)this.workbenchData.getAbsolutePath());
        }
    }

    public long getLastStoreDatetime() {
        long restoreLastModified = this.restoreLocation == null ? 0L : new File(this.restoreLocation.toFileString()).lastModified();
        return restoreLastModified;
    }

    public Resource loadRestoredModel() {
        Activator.trace("/trace/workbench", "Restoring workbench: " + this.restoreLocation, null);
        this.resource = this.resourceSetImpl.getResource(this.restoreLocation, true);
        return this.resource;
    }

    public Resource loadBaseModel() {
        Activator.trace("/trace/workbench", "Initializing workbench: " + this.applicationDefinitionInstance, null);
        this.resource = new ResourceSetImpl().getResource(this.applicationDefinitionInstance, true);
        return this.resource;
    }

    private MApplication loadDefaultModel(URI defaultModelPath) {
        Resource resource = new ResourceSetImpl().getResource(defaultModelPath, true);
        MApplication app = (MApplication)resource.getContents().get(0);
        return app;
    }

    public void save() throws IOException {
        block2: {
            try {
                Document document = (Document)this.reconciler.serialize();
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                DOMSource source = new DOMSource(document);
                File f = new File(this.restoreLocation.toFileString());
                f.getParentFile().mkdirs();
                StreamResult result = new StreamResult(f);
                transformer.transform(source, result);
            }
            catch (Exception e) {
                if (this.logger == null) break block2;
                this.logger.error((Throwable)e);
            }
        }
    }

    public Resource loadMostRecentModel() {
        block3: {
            try {
                Resource resource = this.loadBaseModel();
                MApplication appElement = (MApplication)resource.getContents().get(0);
                ModelExtensionProcessor extProcessor = new ModelExtensionProcessor(appElement);
                extProcessor.addModelExtensions();
                File file = new File(this.restoreLocation.toFileString());
                this.reconciler = new XMLModelReconciler();
                this.reconciler.recordChanges(appElement);
                if (file.exists()) {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                    ModelReconcilingService modelReconcilingService = new ModelReconcilingService();
                    ModelReconciler modelReconciler = modelReconcilingService.createModelReconciler();
                    document.normalizeDocument();
                    Collection<ModelDelta> deltas = modelReconciler.constructDeltas(resource.getContents().get(0), document);
                    modelReconcilingService.applyDeltas(deltas);
                }
            }
            catch (Exception e) {
                if (this.logger == null) break block3;
                this.logger.error((Throwable)e);
            }
        }
        return this.resource;
    }

    public long getLastApplicationModification() {
        long appLastModified = 0L;
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Map attributes = resourceSetImpl.getURIConverter().getAttributes(this.applicationDefinitionInstance, Collections.singletonMap("requestedAttributes", Collections.singleton("timeStamp")));
        Object timestamp = attributes.get("timeStamp");
        if (timestamp instanceof Long) {
            appLastModified = (Long)timestamp;
        } else if (this.applicationDefinitionInstance.isPlatformPlugin()) {
            try {
                URL url = new URL(this.applicationDefinitionInstance.toString());
                Object[] obj = PlatformURLPluginConnection.parse((String)url.getFile().trim(), (URL)url);
                Bundle b = (Bundle)obj[0];
                URLConnection openConnection = b.getResource((String)obj[1]).openConnection();
                appLastModified = openConnection.getLastModified();
            }
            catch (Exception exception) {}
        }
        return appLastModified;
    }
}

