/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.services.annotations.Optional;
import org.eclipse.e4.core.services.annotations.PostConstruct;
import org.eclipse.e4.core.services.annotations.PreDestroy;
import org.eclipse.e4.core.services.context.ContextChangeEvent;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.IRunAndTrack;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.services.events.IEventBroker;
import org.eclipse.e4.workbench.modeling.EPartService;
import org.eclipse.e4.workbench.modeling.ESelectionService;
import org.eclipse.e4.workbench.modeling.ISelectionListener;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionServiceImpl
implements ESelectionService {
    static final String OUT_SELECTION = "output.selection";
    private Set<ISelectionListener> genericListeners = new HashSet<ISelectionListener>();
    private Map<String, Set<ISelectionListener>> targetedListeners = new HashMap<String, Set<ISelectionListener>>();
    private Set<IEclipseContext> tracked = new HashSet<IEclipseContext>();
    @Inject
    private IEclipseContext context;
    @Inject
    private EPartService partService;
    @Inject
    @Named(value="partServiceRoot")
    private MWindow serviceRoot;
    @Inject
    private IEventBroker eventBroker;
    private EventHandler eventHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MPart part;
            IEclipseContext context;
            Object element = event.getProperty("ChangedElement");
            if (element instanceof MPart && (context = (part = (MPart)element).getContext()) != null && SelectionServiceImpl.this.isInContainer(part)) {
                SelectionServiceImpl.this.track(part);
            }
        }
    };
    private MPart activePart;

    @PreDestroy
    void preDestroy() {
        IEclipseContext rootContext = this.serviceRoot.getContext();
        if (rootContext != this.context) {
            ESelectionService selectionService = (ESelectionService)rootContext.get(ESelectionService.class.getName());
            for (ISelectionListener iSelectionListener : this.genericListeners) {
                selectionService.removeSelectionListener(iSelectionListener);
            }
            for (Map.Entry entry : this.targetedListeners.entrySet()) {
                String partId = (String)entry.getKey();
                for (ISelectionListener listener : (Set)entry.getValue()) {
                    selectionService.removeSelectionListener(partId, listener);
                }
            }
        }
        this.genericListeners.clear();
        this.targetedListeners.clear();
        this.eventBroker.unsubscribe(this.eventHandler);
    }

    @PostConstruct
    void postConstruct() {
        this.eventBroker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/application/Context", "context"), this.eventHandler);
        for (MPart part : this.partService.getParts()) {
            this.track(part);
        }
    }

    @Inject
    void setPart(@Optional @Named(value="e4ActivePart") MPart part) {
        if (part != null) {
            IEclipseContext partContext;
            this.activePart = part;
            IEclipseContext rootContext = this.serviceRoot.getContext();
            if (rootContext == this.context && (partContext = part.getContext()) != null) {
                Object selection = partContext.get(OUT_SELECTION);
                this.notifyListeners(part, selection);
                this.track(part);
            }
        }
    }

    private boolean isInContainer(MPart part) {
        return this.isInContainer((MElementContainer<?>)this.serviceRoot, part);
    }

    private boolean isInContainer(MElementContainer<?> container, MPart part) {
        for (Object object : container.getChildren()) {
            if (object == part) {
                return true;
            }
            if (!(object instanceof MElementContainer) || !this.isInContainer((MElementContainer)object, part)) continue;
            return true;
        }
        return false;
    }

    private void notifyListeners(MPart part, Object selection) {
        for (ISelectionListener listener : this.genericListeners) {
            listener.selectionChanged(part, selection);
        }
        this.notifyTargetedListeners(part, selection);
    }

    private void notifyTargetedListeners(MPart part, Object selection) {
        Set<ISelectionListener> listeners;
        String id = part.getId();
        if (id != null && (listeners = this.targetedListeners.get(id)) != null) {
            for (ISelectionListener listener : listeners) {
                listener.selectionChanged(part, selection);
            }
        }
    }

    private void track(final MPart part) {
        final IEclipseContext context = part.getContext();
        if (context != null && this.tracked.add(context)) {
            context.runAndTrack(new IRunAndTrack(){
                private boolean initial = true;

                public boolean notify(ContextChangeEvent event) {
                    Object selection = context.get(SelectionServiceImpl.OUT_SELECTION);
                    if (this.initial) {
                        this.initial = false;
                        if (selection == null) {
                            return true;
                        }
                    }
                    if (SelectionServiceImpl.this.activePart == part) {
                        SelectionServiceImpl.this.notifyListeners(part, selection);
                    } else {
                        SelectionServiceImpl.this.notifyTargetedListeners(part, selection);
                    }
                    return true;
                }
            }, null);
        }
    }

    @Override
    public void setSelection(Object selection) {
        if (selection != null) {
            this.context.set(OUT_SELECTION, selection);
        } else {
            this.context.remove(OUT_SELECTION);
        }
    }

    @Override
    public Object getSelection() {
        if (this.activePart == null) {
            return null;
        }
        IEclipseContext partContext = this.activePart.getContext();
        return partContext == null ? null : partContext.get("in.selection");
    }

    @Override
    public void addSelectionListener(ISelectionListener listener) {
        IEclipseContext rootContext = this.serviceRoot.getContext();
        if (rootContext != this.context) {
            ESelectionService selectionService = (ESelectionService)rootContext.get(ESelectionService.class.getName());
            selectionService.addSelectionListener(listener);
        }
        this.genericListeners.add(listener);
    }

    @Override
    public void removeSelectionListener(ISelectionListener listener) {
        IEclipseContext rootContext = this.serviceRoot.getContext();
        if (rootContext != this.context) {
            ESelectionService selectionService = (ESelectionService)rootContext.get(ESelectionService.class.getName());
            selectionService.removeSelectionListener(listener);
        }
        this.genericListeners.remove(listener);
    }

    @Override
    public void addSelectionListener(String partId, ISelectionListener listener) {
        Set<ISelectionListener> listeners;
        IEclipseContext rootContext = this.serviceRoot.getContext();
        if (rootContext != this.context) {
            ESelectionService selectionService = (ESelectionService)rootContext.get(ESelectionService.class.getName());
            selectionService.addSelectionListener(partId, listener);
        }
        if ((listeners = this.targetedListeners.get(partId)) == null) {
            listeners = new HashSet<ISelectionListener>();
            this.targetedListeners.put(partId, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public void removeSelectionListener(String partId, ISelectionListener listener) {
        Set<ISelectionListener> listeners;
        IEclipseContext rootContext = this.serviceRoot.getContext();
        if (rootContext != this.context) {
            ESelectionService selectionService = (ESelectionService)rootContext.get(ESelectionService.class.getName());
            selectionService.removeSelectionListener(partId, listener);
        }
        if ((listeners = this.targetedListeners.get(partId)) != null) {
            listeners.remove(listener);
        }
    }

    @Override
    public Object getSelection(String partId) {
        MPart part = this.partService.findPart(partId);
        if (part == null) {
            return null;
        }
        IEclipseContext partContext = part.getContext();
        if (partContext == null) {
            return null;
        }
        return partContext.get(OUT_SELECTION);
    }
}

