/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.services.events.IEventBroker;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIEventPublisher
extends EContentAdapter {
    private IEclipseContext context;

    public UIEventPublisher(IEclipseContext e4Context) {
        this.context = e4Context;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.isTouch()) {
            return;
        }
        HashMap<String, Object> argMap = new HashMap<String, Object>();
        String topic = this.formatData(notification, argMap);
        if (topic != null) {
            IEventBroker eventManager = (IEventBroker)this.context.get(IEventBroker.class.getName());
            eventManager.send(topic, argMap);
        } else {
            System.out.println("Event of unknown type received from the model");
        }
    }

    private String formatData(Notification notification, Map<String, Object> argMap) {
        MApplicationElement appElement = (MApplicationElement)notification.getNotifier();
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        argMap.put("EventType", this.getEventType(notification));
        argMap.put("ChangedElement", appElement);
        argMap.put("AttName", feature.getName());
        if (notification.getEventType() == 1 || notification.getEventType() == 3 || notification.getEventType() == 4) {
            argMap.put("NewValue", notification.getNewValue());
            argMap.put("OldValue", notification.getOldValue());
        }
        if (appElement instanceof MUIElement) {
            argMap.put("Widget", ((MUIElement)appElement).getWidget());
        }
        return this.getTopic(feature, this.getEventType(notification));
    }

    private String getEventType(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                return "ADD";
            }
            case 4: {
                return "REMOVE";
            }
            case 1: {
                return "SET";
            }
        }
        return "UNKNOWN";
    }

    private String getTopic(EStructuralFeature eFeature, String type) {
        EClass eContainingClass = eFeature.getEContainingClass();
        return "org/eclipse/e4/ui/model/" + eContainingClass.getEPackage().getName() + "/" + eContainingClass.getName() + "/" + eFeature.getName() + "/" + type;
    }
}

