/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.internal.runtime.PlatformURLPluginConnection;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.services.IContributionFactory;
import org.eclipse.e4.core.services.Logger;
import org.eclipse.e4.core.services.context.ContextChangeEvent;
import org.eclipse.e4.core.services.context.EclipseContextFactory;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.core.services.context.IRunAndTrack;
import org.eclipse.e4.core.services.context.spi.ContextFunction;
import org.eclipse.e4.core.services.context.spi.ContextInjectionFactory;
import org.eclipse.e4.core.services.context.spi.IEclipseContextStrategy;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.TriggerSequence;
import org.eclipse.e4.ui.internal.services.ActiveContextsFunction;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MBindingContainer;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.model.application.MCommandParameter;
import org.eclipse.e4.ui.model.application.MContext;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MHandler;
import org.eclipse.e4.ui.model.application.MHandlerContainer;
import org.eclipse.e4.ui.model.application.MKeyBinding;
import org.eclipse.e4.ui.model.application.MParameter;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.services.events.IEventBroker;
import org.eclipse.e4.workbench.ui.IExceptionHandler;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.IWorkbench;
import org.eclipse.e4.workbench.ui.IWorkbenchWindowHandler;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.e4.workbench.ui.internal.ActiveChildLookupFunction;
import org.eclipse.e4.workbench.ui.internal.ActivePartLookupFunction;
import org.eclipse.e4.workbench.ui.internal.ExceptionHandler;
import org.eclipse.e4.workbench.ui.internal.Parameter;
import org.eclipse.e4.workbench.ui.internal.PartServiceImpl;
import org.eclipse.e4.workbench.ui.internal.ReflectionContributionFactory;
import org.eclipse.e4.workbench.ui.internal.ResourceHandler;
import org.eclipse.e4.workbench.ui.internal.UIEventPublisher;
import org.eclipse.e4.workbench.ui.internal.UISchedulerStrategy;
import org.eclipse.e4.workbench.ui.internal.WorkbenchLogger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workbench
implements IWorkbench {
    public static final String LOCAL_ACTIVE_SHELL = "localActiveShell";
    public static final String ID = "org.eclipse.e4.workbench.fakedWBWindow";
    private MApplication workbench;
    private static final boolean saveAndRestore = true;
    private IWorkbenchWindowHandler windowHandler;
    private IPresentationEngine renderer;
    private int rv;
    private ExceptionHandler exceptionHandler;
    private IEclipseContext workbenchContext;
    private ReflectionContributionFactory contributionFactory;
    private String renderingEngineURI;
    private ResourceHandler handler;
    private Location instanceLocation;

    public IEclipseContext getContext() {
        return this.workbenchContext;
    }

    public Workbench(Location instanceLocation, IExtensionRegistry registry, PackageAdmin packageAdmin, IEclipseContext applicationContext, IWorkbenchWindowHandler windowHandler, String renderingEngineURI) {
        this.windowHandler = windowHandler;
        this.renderingEngineURI = renderingEngineURI;
        this.instanceLocation = instanceLocation;
        this.exceptionHandler = new ExceptionHandler();
        this.contributionFactory = new ReflectionContributionFactory(registry);
        this.workbenchContext = Workbench.createWorkbenchContext(applicationContext, registry, this.exceptionHandler, this.contributionFactory);
        this.workbenchContext.set(Workbench.class.getName(), (Object)this);
        this.workbenchContext.set(IWorkbench.class.getName(), (Object)this);
        this.workbenchContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        this.workbenchContext.set(IContributionFactory.class.getName(), (Object)this.contributionFactory);
        this.workbenchContext.set(IEclipseContext.class.getName(), (Object)this.workbenchContext);
    }

    public void setWorkbenchModel(MApplication model) {
        this.workbench = model;
        this.init();
    }

    public void setWorkbenchModelURI(URI workbenchXmiURI) {
        this.createWorkbenchModel(workbenchXmiURI);
    }

    public static IEclipseContext createWorkbenchContext(final IEclipseContext applicationContext, IExtensionRegistry registry, IExceptionHandler exceptionHandler, IContributionFactory contributionFactory) {
        Activator.trace("/trace/eclipse.context", "createWorkbenchContext: initialize the workbench context with needed services", null);
        final IEclipseContext mainContext = EclipseContextFactory.create((IEclipseContext)applicationContext, (IEclipseContextStrategy)UISchedulerStrategy.getInstance());
        mainContext.set(Logger.class.getName(), ContextInjectionFactory.inject((Object)((Object)new WorkbenchLogger()), (IEclipseContext)mainContext));
        mainContext.set("debugString", (Object)"WorkbenchContext");
        if (contributionFactory != null) {
            mainContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        }
        mainContext.set(ContextManager.class.getName(), (Object)new ContextManager());
        mainContext.set("activeContexts", (Object)new ActiveContextsFunction());
        mainContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        mainContext.runAndTrack(new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                Object o = mainContext.get("e4ActivePart");
                if (o instanceof MPart) {
                    mainContext.set("activePartId", (Object)((MPart)o).getId());
                }
                return true;
            }

            public String toString() {
                return "activePartId";
            }
        }, null);
        mainContext.set(IExceptionHandler.class.getName(), (Object)exceptionHandler);
        mainContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        mainContext.set("input", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, Object[] arguments) {
                Object adapted;
                IAdapterManager adapters;
                Class adapterType = null;
                if (arguments.length > 0 && arguments[0] instanceof Class) {
                    adapterType = (Class)arguments[0];
                }
                Object newInput = null;
                Object newValue = context.get("selection");
                if (adapterType == null || adapterType.isInstance(newValue)) {
                    newInput = newValue;
                } else if (newValue != null && adapterType != null && (adapters = (IAdapterManager)applicationContext.get(IAdapterManager.class.getName())) != null && (adapted = adapters.loadAdapter(newValue, adapterType.getName())) != null) {
                    newInput = adapted;
                }
                return newInput;
            }
        });
        mainContext.set("activeShell", (Object)new ActiveChildLookupFunction("activeShell", LOCAL_ACTIVE_SHELL));
        Workbench.initializeNullStyling(mainContext);
        return mainContext;
    }

    private MApplication createWorkbenchModel(URI applicationDefinitionInstance) {
        long lastApplicationModification;
        boolean restore;
        this.handler = new ResourceHandler(this.instanceLocation, applicationDefinitionInstance, true, (Logger)this.getContext().get(Logger.class.getName()));
        long restoreLastModified = this.handler.getLastStoreDatetime();
        boolean bl = restore = restoreLastModified > (lastApplicationModification = this.getLastApplicationModification(applicationDefinitionInstance));
        if (restore) {
            Resource resource = this.handler.loadRestoredModel();
            this.workbench = (MApplication)resource.getContents().get(0);
        } else {
            Resource resource = this.handler.loadBaseModel();
            MApplication app = (MApplication)resource.getContents().get(0);
            EList windows = app.getChildren();
            for (MWindow window : windows) {
                this.processPartContributions(resource, window);
            }
            this.workbench = app;
        }
        this.init();
        return this.workbench;
    }

    private long getLastApplicationModification(URI applicationDefinitionInstance) {
        long appLastModified = 0L;
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Map attributes = resourceSetImpl.getURIConverter().getAttributes(applicationDefinitionInstance, Collections.singletonMap("requestedAttributes", Collections.singleton("timeStamp")));
        Object timestamp = attributes.get("timeStamp");
        if (timestamp instanceof Long) {
            appLastModified = (Long)timestamp;
        } else if (applicationDefinitionInstance.isPlatformPlugin()) {
            try {
                URL url = new URL(applicationDefinitionInstance.toString());
                Object[] obj = PlatformURLPluginConnection.parse((String)url.getFile().trim(), (URL)url);
                Bundle b = (Bundle)obj[0];
                URLConnection openConnection = b.getResource((String)obj[1]).openConnection();
                appLastModified = openConnection.getLastModified();
            }
            catch (Exception exception) {}
        }
        return appLastModified;
    }

    private void processPartContributions(Resource resource, MWindow mWindow) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        String extId = "org.eclipse.e4.workbench.parts";
        IConfigurationElement[] parts = registry.getConfigurationElementsFor(extId);
        int i = 0;
        while (i < parts.length) {
            MPart part = MApplicationFactory.eINSTANCE.createPart();
            part.setLabel(parts[i].getAttribute("label"));
            part.setIconURI("platform:/plugin/" + parts[i].getContributor().getName() + "/" + parts[i].getAttribute("icon"));
            part.setURI("platform:/plugin/" + parts[i].getContributor().getName() + "/" + parts[i].getAttribute("class"));
            String parentId = parts[i].getAttribute("parentId");
            EObject parent = this.findObject((TreeIterator<EObject>)resource.getAllContents(), parentId);
            if (parent instanceof MElementContainer) {
                ((MElementContainer)parent).getChildren().add((Object)part);
            }
            ++i;
        }
    }

    private EObject findObject(TreeIterator<EObject> it, String id) {
        while (it.hasNext()) {
            EObject el = (EObject)it.next();
            if (!(el instanceof MApplicationElement) || !el.eResource().getURIFragment(el).equals(id)) continue;
            return el;
        }
        return null;
    }

    private void init() {
        Activator.trace("/trace/workbench", "init() workbench", null);
        this.workbenchContext.set(MApplication.class.getName(), (Object)this.workbench);
        this.workbench.setContext(this.workbenchContext);
        Activator.trace("/trace/commands", "Initialize service from model", null);
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        Category cat = cs.defineCategory(MApplication.class.getName(), "Application Category", null);
        EList commands = this.workbench.getCommands();
        for (MCommand cmd : commands) {
            IParameter[] parms = null;
            String id = cmd.getId();
            String name = cmd.getCommandName();
            EList modelParms = cmd.getParameters();
            if (modelParms != null && !modelParms.isEmpty()) {
                ArrayList<Parameter> parmList = new ArrayList<Parameter>();
                for (MCommandParameter cmdParm : modelParms) {
                    parmList.add(new Parameter(cmdParm.getId(), cmdParm.getName(), null, null, cmdParm.isOptional()));
                }
                parms = parmList.toArray(new Parameter[parmList.size()]);
            }
            cs.defineCommand(id, name, null, cat, parms);
        }
        EList windows = this.workbench.getChildren();
        for (MWindow window : windows) {
            Workbench.initializeContext(this.workbenchContext, (MContext)window);
        }
        Workbench.processHierarchy(this.workbench);
        ((Notifier)this.workbench).eAdapters().add((Object)new UIEventPublisher(this.workbench.getContext()));
    }

    public static IEclipseContext initializeContext(IEclipseContext parentContext, MContext contextModel) {
        Class<?>[] interfaces;
        IEclipseContext context;
        if (contextModel.getContext() != null) {
            context = contextModel.getContext();
        } else {
            context = EclipseContextFactory.create((IEclipseContext)parentContext, (IEclipseContextStrategy)UISchedulerStrategy.getInstance());
            context.set("debugString", (Object)("PartContext(" + contextModel + ')'));
        }
        Activator.trace("/trace/eclipse.context", "initializeContext(" + parentContext.toString() + ", " + contextModel + ")", null);
        Class<?>[] classArray = interfaces = contextModel.getClass().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            Activator.trace("/trace/eclipse.context", "Adding " + intf.getName() + " for " + contextModel.getClass().getName(), null);
            context.set(intf.getName(), (Object)contextModel);
            ++n2;
        }
        EList containedProperties = contextModel.getVariables();
        for (String name : containedProperties) {
            context.declareModifiable(name);
        }
        contextModel.setContext(context);
        return context;
    }

    public void createUIFromModel() {
        EList windows = this.workbench.getChildren();
        for (MWindow wbw : windows) {
            this.createGUI((MUIElement)wbw);
        }
    }

    @Override
    public int run() {
        Activator.trace("/trace/workbench", "running event loop", null);
        this.windowHandler.runEvenLoop(((MWindow)this.workbench.getChildren().get(0)).getWidget());
        if (this.handler != null && this.workbench != null) {
            try {
                Activator.trace("/trace/workbench", "Saving workbench: " + ((EObject)this.workbench).eResource().getURI(), null);
                this.handler.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.rv;
    }

    public static void processHierarchy(Object me) {
        IEclipseContext context;
        MHandlerContainer container;
        MContext contextModel;
        IEclipseContext c;
        MContext contextAware;
        if (me instanceof MApplication) {
            contextAware = (MContext)me;
            c = contextAware.getContext();
            IEventBroker broker = (IEventBroker)c.get(IEventBroker.class.getName());
            PartServiceImpl.addListener(broker);
        }
        if (me instanceof MHandlerContainer) {
            contextModel = (MContext)me;
            container = (MHandlerContainer)contextModel;
            context = contextModel.getContext();
            if (context != null) {
                IContributionFactory cf = (IContributionFactory)context.get(IContributionFactory.class.getName());
                EHandlerService hs = (EHandlerService)context.get(EHandlerService.class.getName());
                EList handlers = container.getHandlers();
                for (MHandler handler : handlers) {
                    String commandId = handler.getCommand().getId();
                    if (handler.getObject() == null) {
                        handler.setObject(cf.create(handler.getURI(), context));
                    }
                    hs.activateHandler(commandId, handler.getObject());
                }
            }
        }
        if (me instanceof MBindingContainer) {
            contextModel = (MContext)me;
            container = (MBindingContainer)me;
            context = contextModel.getContext();
            if (context != null) {
                ECommandService cs = (ECommandService)context.get(ECommandService.class.getName());
                EBindingService bs = (EBindingService)context.get(EBindingService.class.getName());
                EList bindings = container.getBindings();
                for (MKeyBinding binding : bindings) {
                    HashMap<String, String> parameters = null;
                    EList modelParms = binding.getParameters();
                    if (modelParms != null && !modelParms.isEmpty()) {
                        parameters = new HashMap<String, String>();
                        for (MParameter mParm : modelParms) {
                            parameters.put(mParm.getTag(), mParm.getValue());
                        }
                    }
                    ParameterizedCommand cmd = cs.createCommand(binding.getCommand().getId(), parameters);
                    TriggerSequence sequence = bs.createSequence(binding.getKeySequence());
                    if (cmd == null || sequence == null) {
                        System.err.println("Failed to handle binding: " + binding);
                        continue;
                    }
                    bs.activateBinding(sequence, cmd);
                }
            }
        }
        if (me instanceof MWindow && (c = (contextAware = (MContext)me).getContext()) != null) {
            c.set("partServiceRoot", me);
        }
        if (me instanceof MElementContainer) {
            EList children = ((MElementContainer)me).getChildren();
            for (MUIElement e : children) {
                Workbench.processHierarchy(e);
            }
        }
    }

    public void createGUI(MUIElement uiRoot) {
        Object newEngine;
        if (this.renderer == null && (newEngine = this.contributionFactory.create(this.renderingEngineURI, this.workbenchContext)) != null) {
            this.renderer = (IPresentationEngine)newEngine;
        }
        this.renderer.createGui(uiRoot);
        if (uiRoot instanceof MWindow) {
            MWindow wbw = (MWindow)uiRoot;
            Object appWindow = wbw.getWidget();
            this.rv = 0;
            this.windowHandler.setBounds(appWindow, wbw.getX(), wbw.getY(), wbw.getWidth(), wbw.getHeight());
            this.windowHandler.layout(appWindow);
            this.windowHandler.open(appWindow);
        }
    }

    @Override
    public boolean close() {
        EList windows = this.workbench.getChildren();
        for (MWindow window : windows) {
            this.windowHandler.dispose(window.getWidget());
        }
        return true;
    }

    public void closeWindow(MWindow workbenchWindow) {
        this.windowHandler.close(workbenchWindow.getWidget());
    }

    public Object getWindow() {
        return ((MWindow)this.workbench.getChildren().get(0)).getWidget();
    }

    private static void initializeNullStyling(IEclipseContext appContext) {
        appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

            public void setClassname(Object widget, String classname) {
            }

            public void setId(Object widget, String id) {
            }

            public void style(Object widget) {
            }
        });
    }

    public MApplication getModel() {
        return this.workbench;
    }
}

