/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.ui.model.application.ItemType;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MApplicationPackage;
import org.eclipse.e4.ui.model.application.MBindingContainer;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.model.application.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.MDirectToolItem;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.MHandledToolItem;
import org.eclipse.e4.ui.model.application.MHandler;
import org.eclipse.e4.ui.model.application.MHandlerContainer;
import org.eclipse.e4.ui.model.application.MKeyBinding;
import org.eclipse.e4.ui.model.application.MMenu;
import org.eclipse.e4.ui.model.application.MMenuItem;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartDescriptor;
import org.eclipse.e4.ui.model.application.MPartDescriptorContainer;
import org.eclipse.e4.ui.model.application.MPartSashContainer;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MPerspective;
import org.eclipse.e4.ui.model.application.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.MToolBar;
import org.eclipse.e4.ui.model.application.MToolItem;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.model.application.MWindowTrim;
import org.eclipse.e4.ui.model.application.SideValue;
import org.eclipse.e4.workbench.modeling.ModelDelta;
import org.eclipse.e4.workbench.modeling.ModelReconciler;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.e4.workbench.ui.internal.CompositeDelta;
import org.eclipse.e4.workbench.ui.internal.E4XMIResource;
import org.eclipse.e4.workbench.ui.internal.EMFModelDeltaDelayedSet;
import org.eclipse.e4.workbench.ui.internal.EMFModelDeltaSet;
import org.eclipse.e4.workbench.ui.internal.EMFModelDeltaThreeWayDelayedSet;
import org.eclipse.e4.workbench.ui.internal.EMFModelDeltaUnset;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLModelReconciler
extends ModelReconciler {
    private static final String XMIID_ATTNAME = "xmiId";
    private static final String REFERENCE_ELEMENT_NAME = "reference";
    private static final String ORIGINALREFERENCE_ELEMENT_NAME = "originalReference";
    private static final String CHANGES_ATTNAME = "changes";
    private static final String TYPE_ATTNAME = "type";
    private static final String UNSET_ATTNAME = "unset";
    private static final String UNSET_ATTVALUE_TRUE = "true";
    private ChangeRecorder changeRecorder;
    private ChangeDescription changeDescription;
    private EObject rootObject;

    @Override
    public void recordChanges(Object object) {
        Assert.isNotNull((Object)object);
        this.rootObject = (EObject)object;
        this.changeRecorder = new ChangeRecorder(this.rootObject){

            protected boolean shouldRecord(EStructuralFeature feature, EObject eObject) {
                return !feature.isTransient() && super.shouldRecord(feature, eObject);
            }

            protected boolean shouldRecord(EStructuralFeature feature, EReference containment, Notification notification, EObject eObject) {
                return !feature.isTransient() && super.shouldRecord(feature, containment, notification, eObject);
            }
        };
        this.changeDescription = null;
    }

    static List<Object> getReferences(Object object) {
        TreeIterator it = ((EObject)object).eAllContents();
        LinkedList<Object> references = new LinkedList<Object>();
        while (it.hasNext()) {
            Object reference = it.next();
            references.add(reference);
        }
        return references;
    }

    @Override
    public Collection<ModelDelta> constructDeltas(Object object, Object serializedState) {
        this.rootObject = (EObject)object;
        List<Object> references = XMLModelReconciler.getReferences(this.rootObject);
        Document document = (Document)serializedState;
        LinkedList<ModelDelta> deltas = new LinkedList<ModelDelta>();
        NodeList rootNodeList = (NodeList)((Object)document.getDocumentElement());
        int i = 0;
        while (i < rootNodeList.getLength()) {
            Node node = rootNodeList.item(i);
            if (node instanceof Element) {
                Element element = (Element)node;
                this.constructDeltas(deltas, references, this.rootObject, element, element.getAttribute(APPLICATIONELEMENT_ID_ATTNAME));
            }
            ++i;
        }
        return deltas;
    }

    private static EStructuralFeature getStructuralFeature(EObject object, String featureName) {
        if (featureName.equals(APPLICATIONELEMENT_ID_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getApplicationElement_Id();
        }
        if (featureName.equals(APPLICATIONELEMENT_TAGS_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getApplicationElement_Tags();
        }
        if (featureName.equals(APPLICATION_COMMANDS_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getApplication_Commands();
        }
        if (featureName.equals(UILABEL_LABEL_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getUILabel_Label();
        }
        if (featureName.equals(UILABEL_TOOLTIP_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getUILabel_Tooltip();
        }
        if (featureName.equals(UILABEL_ICONURI_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getUILabel_IconURI();
        }
        if (featureName.equals(UIELEMENT_TOBERENDERED_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getUIElement_ToBeRendered();
        }
        if (featureName.equals(UIELEMENT_VISIBLE_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getUIElement_Visible();
        }
        if (featureName.equals(ELEMENTCONTAINER_CHILDREN_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getElementContainer_Children();
        }
        if (featureName.equals(UIELEMENT_PARENT_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getUIElement_Parent();
        }
        if (featureName.equals(UIELEMENT_CONTAINERDATA_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getUIElement_ContainerData();
        }
        if (featureName.equals(ELEMENTCONTAINER_SELECTEDELEMENT_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getElementContainer_SelectedElement();
        }
        if (featureName.equals(COMMAND_COMMANDNAME_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getCommand_CommandName();
        }
        if (featureName.equals(COMMAND_DESCRIPTION_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getCommand_Description();
        }
        if (featureName.equals(KEYSEQUENCE_KEYSEQUENCE_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getKeySequence_KeySequence();
        }
        if (featureName.equals(BINDINGCONTAINER_BINDINGS_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getBindingContainer_Bindings();
        }
        if (featureName.equals(HANDLER_COMMAND_ATTNAME) || featureName.equals(KEYBINDING_COMMAND_ATTNAME) || featureName.equals(HANDLEDITEM_COMMAND_ATTNAME)) {
            if (object instanceof MKeyBinding) {
                return MApplicationPackage.eINSTANCE.getKeyBinding_Command();
            }
            if (object instanceof MHandler) {
                return MApplicationPackage.eINSTANCE.getHandler_Command();
            }
            return MApplicationPackage.eINSTANCE.getHandledItem_Command();
        }
        if (featureName.equals(COMMAND_PARAMETERS_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getKeyBinding_Parameters();
        }
        if (featureName.equals(ITEM_ENABLED_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getItem_Enabled();
        }
        if (featureName.equals(ITEM_SELECTED_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getItem_Selected();
        }
        if (featureName.equals(ITEM_TYPE_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getItem_Type();
        }
        if (featureName.equals(PART_MENUS_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getPart_Menus();
        }
        if (featureName.equals(PART_TOOLBAR_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getPart_Toolbar();
        }
        if (featureName.equals(GENERICTILE_HORIZONTAL_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getGenericTile_Horizontal();
        }
        if (featureName.equals(TRIMCONTAINER_SIDE_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getTrimContainer_Side();
        }
        if (featureName.equals(HANDLERCONTAINER_HANDLERS_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getHandlerContainer_Handlers();
        }
        if (featureName.equals(CONTRIBUTION_PERSISTEDSTATE_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getContribution_PersistedState();
        }
        if (featureName.equals(CONTRIBUTION_URI_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getContribution_URI();
        }
        if (featureName.equals(WINDOW_MAINMENU_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getWindow_MainMenu();
        }
        if (featureName.equals(WINDOW_X_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getWindow_X();
        }
        if (featureName.equals(WINDOW_Y_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getWindow_Y();
        }
        if (featureName.equals(WINDOW_WIDTH_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getWindow_Width();
        }
        if (featureName.equals(WINDOW_HEIGHT_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getWindow_Height();
        }
        if (featureName.equals(PARTDESCRIPTOR_ALLOWMULTIPLE_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getPartDescriptor_AllowMultiple();
        }
        if (featureName.equals(PARTDESCRIPTOR_CATEGORY_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getPartDescriptor_Category();
        }
        if (featureName.equals(PART_CLOSEABLE_ATTNAME)) {
            return MApplicationPackage.eINSTANCE.getPart_Closeable();
        }
        Activator.log(2, "Unknown feature found, reconciliation may fail: " + object.eClass().getName() + '#' + featureName);
        for (EStructuralFeature sf : object.eClass().getEAllStructuralFeatures()) {
            if (!sf.getName().equals(featureName)) continue;
            return sf;
        }
        return null;
    }

    private Object getValue(EStructuralFeature feature, String featureValue) {
        Class instanceClass = feature.getEType().getInstanceClass();
        if (instanceClass == String.class) {
            return featureValue;
        }
        if (instanceClass == Integer.TYPE) {
            return Integer.valueOf(featureValue);
        }
        if (instanceClass == Boolean.TYPE) {
            return Boolean.valueOf(featureValue);
        }
        if (feature == MApplicationPackage.eINSTANCE.getTrimContainer_Side()) {
            return SideValue.getByName((String)featureValue);
        }
        if (feature == MApplicationPackage.eINSTANCE.getItem_Type()) {
            return ItemType.getByName((String)featureValue);
        }
        return null;
    }

    static Object findReference(List<Object> references, String id) {
        for (Object reference : references) {
            if (!XMLModelReconciler.getLocalId(reference).equals(id)) continue;
            return reference;
        }
        return null;
    }

    private boolean constructDeltas(Collection<ModelDelta> deltas, List<Object> references, EObject object, Element element, String id) {
        MWindow window;
        if ((object instanceof MApplicationElement || object instanceof MKeyBinding) && XMLModelReconciler.getLocalId(object).equals(id)) {
            this.constructObjectDeltas(deltas, references, object, element);
            return true;
        }
        if (object instanceof MElementContainer) {
            for (Object child : ((MElementContainer)object).getChildren()) {
                if (!this.constructDeltas(deltas, references, (EObject)child, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MBindingContainer) {
            for (MKeyBinding keyBinding : ((MBindingContainer)object).getBindings()) {
                if (!this.constructDeltas(deltas, references, (EObject)keyBinding, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MHandlerContainer) {
            for (MHandler handler : ((MHandlerContainer)object).getHandlers()) {
                if (!this.constructDeltas(deltas, references, (EObject)handler, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MApplication) {
            for (MCommand command : ((MApplication)object).getCommands()) {
                if (!this.constructDeltas(deltas, references, (EObject)command, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MPartDescriptorContainer) {
            for (MPartDescriptor descriptor : ((MPartDescriptorContainer)object).getDescriptors()) {
                if (!this.constructDeltas(deltas, references, (EObject)descriptor, element, id)) continue;
                return true;
            }
        }
        if (object instanceof MPart) {
            MPart part = (MPart)object;
            for (MMenu menu : part.getMenus()) {
                if (!this.constructDeltas(deltas, references, (EObject)menu, element, id)) continue;
                return true;
            }
            MToolBar toolBar = part.getToolbar();
            if (toolBar != null && this.constructDeltas(deltas, references, (EObject)toolBar, element, id)) {
                return true;
            }
        }
        return object instanceof MWindow && this.constructDeltas(deltas, references, (EObject)(window = (MWindow)object).getMainMenu(), element, id);
    }

    private void constructObjectDeltas(Collection<ModelDelta> deltas, List<Object> references, EObject object, Element element) {
        NodeList nodeList = (NodeList)((Object)element);
        int i = 0;
        while (i < nodeList.getLength()) {
            Element innerElement;
            String featureName;
            EStructuralFeature feature;
            Node node = nodeList.item(i);
            if (node instanceof Element && (feature = XMLModelReconciler.getStructuralFeature(object, featureName = (innerElement = (Element)node).getNodeName())) != null) {
                ModelDelta delta;
                if (XMLModelReconciler.isChainedReference(featureName)) {
                    delta = this.createMultiReferenceDelta(deltas, references, object, feature, innerElement);
                    deltas.add(delta);
                } else if (XMLModelReconciler.isUnset(innerElement)) {
                    delta = new EMFModelDeltaUnset(object, feature);
                    deltas.add(delta);
                } else if (XMLModelReconciler.isDirectReference(featureName)) {
                    delta = this.createDirectReferenceDelta(deltas, references, object, feature, innerElement);
                    deltas.add(delta);
                } else if (XMLModelReconciler.isIndirectReference(featureName)) {
                    delta = this.createIndirectReferenceDelta(references, object, feature, innerElement);
                    deltas.add(delta);
                } else if (XMLModelReconciler.isUnorderedChainedAttribute(featureName)) {
                    delta = this.createUnorderedChainedAttributeDelta(object, feature, innerElement, featureName);
                    deltas.add(delta);
                } else {
                    delta = this.createAttributeDelta(object, feature, innerElement, featureName);
                    deltas.add(delta);
                }
            }
            ++i;
        }
    }

    private ModelDelta createDirectReferenceDelta(Collection<ModelDelta> deltas, List<Object> references, EObject eObject, EStructuralFeature feature, Element node) {
        NodeList referencedIds = (NodeList)((Object)node);
        Element reference = XMLModelReconciler.getFirstElement(referencedIds);
        String referenceId = reference.getAttribute(APPLICATIONELEMENT_ID_ATTNAME);
        Object match = XMLModelReconciler.findReference(references, referenceId);
        if (match == null) {
            match = this.createObject(deltas, reference, references);
        }
        return new EMFModelDeltaSet((Object)eObject, feature, match);
    }

    private static Element getFirstElement(NodeList list) {
        int i = 0;
        while (i < list.getLength()) {
            Node item = list.item(i);
            if (item instanceof Element) {
                return (Element)item;
            }
            ++i;
        }
        return null;
    }

    private ModelDelta createIndirectReferenceDelta(List<Object> references, EObject eObject, EStructuralFeature feature, Element node) {
        NodeList referencedIds = (NodeList)((Object)node);
        Element reference = XMLModelReconciler.getFirstElement(referencedIds);
        String referenceId = reference.getAttribute(APPLICATIONELEMENT_ID_ATTNAME);
        Object match = XMLModelReconciler.findReference(references, referenceId);
        if (match == null) {
            return this.createDelayedDelta(eObject, feature, reference);
        }
        return new EMFModelDeltaSet((Object)eObject, feature, match);
    }

    private ModelDelta createDelayedDelta(EObject object, EStructuralFeature feature, Element element) {
        String referenceId = element.getAttribute(XMIID_ATTNAME);
        return new EMFModelDeltaDelayedSet(object, feature, this.rootObject, referenceId);
    }

    public static List<?> threeWayMerge(List<?> originalReferences, List<?> userReferences, List<?> currentReferences) {
        int userSize = userReferences.size();
        int originalSize = originalReferences.size();
        if (userSize == 0) {
            ArrayList collectedReferences = new ArrayList(currentReferences);
            collectedReferences.removeAll(originalReferences);
            return collectedReferences;
        }
        if (originalSize == 0) {
            ArrayList collectedReferences = new ArrayList(userReferences);
            collectedReferences.addAll(currentReferences);
            return collectedReferences;
        }
        if (currentReferences.isEmpty()) {
            return userReferences;
        }
        if (originalReferences.containsAll(currentReferences) && currentReferences.containsAll(originalReferences)) {
            return userReferences;
        }
        if (originalReferences.containsAll(userReferences) && !userReferences.containsAll(originalReferences)) {
            ArrayList collectedReferences2 = new ArrayList(originalReferences);
            collectedReferences2.removeAll(userReferences);
            ArrayList collectedReferences = new ArrayList(currentReferences);
            collectedReferences.removeAll(collectedReferences2);
            return collectedReferences;
        }
        ArrayList<Position> positions = new ArrayList<Position>();
        int i = 0;
        while (i < userReferences.size()) {
            Object user = userReferences.get(i);
            Position p = XMLModelReconciler.getPosition(originalReferences, userReferences, currentReferences, user, i);
            if (p != null) {
                positions.add(p);
            }
            ++i;
        }
        ArrayList collectedRefs = new ArrayList(currentReferences);
        for (Position position : positions) {
            Object before;
            Object after = position.getAfter();
            if (after != null) {
                int index = currentReferences.indexOf(after);
                collectedRefs.add(index + 1, position.getObject());
            }
            if ((before = position.getBefore()) == null) continue;
            int index = currentReferences.indexOf(before);
            collectedRefs.add(index, position.getObject());
        }
        return collectedRefs;
    }

    private static Position getPosition(List<?> originalReferences, List<?> userReferences, List<?> currentReferences, Object object, int originalIndex) {
        int index = originalReferences.indexOf(object);
        if (index == -1) {
            Object after = null;
            int i = originalIndex - 1;
            while (i > -1) {
                Object afterCandidate = userReferences.get(i);
                int afterIndex = currentReferences.indexOf(afterCandidate);
                if (afterIndex != -1) {
                    after = afterCandidate;
                    break;
                }
                --i;
            }
            Object before = null;
            int i2 = originalIndex + 1;
            while (i2 < userReferences.size()) {
                Object beforeCandidate = userReferences.get(i2);
                int beforeIndex = currentReferences.indexOf(beforeCandidate);
                if (beforeIndex != -1) {
                    before = beforeCandidate;
                    break;
                }
                ++i2;
            }
            return new Position(object, after, before);
        }
        return null;
    }

    private ModelDelta createMultiReferenceDelta(Collection<ModelDelta> deltas, List<Object> references, EObject eObject, EStructuralFeature feature, Element node) {
        NodeList referencedIds = (NodeList)((Object)node);
        ArrayList<Object> originalReferences = new ArrayList<Object>();
        ArrayList<Object> userReferences = new ArrayList<Object>();
        List currentReferences = (List)eObject.eGet(feature);
        int i = 0;
        while (i < referencedIds.getLength()) {
            Node item = referencedIds.item(i);
            if (item instanceof Element) {
                Element reference = (Element)item;
                if (XMLModelReconciler.isUnset(reference)) {
                    userReferences.add(this.createObject(deltas, reference, references));
                } else {
                    String referenceId = reference.getAttribute(APPLICATIONELEMENT_ID_ATTNAME);
                    Object match = XMLModelReconciler.findReference(references, referenceId);
                    if (match != null) {
                        if (reference.getNodeName().equals(REFERENCE_ELEMENT_NAME)) {
                            userReferences.add(match);
                        } else {
                            originalReferences.add(match);
                        }
                    }
                }
            }
            ++i;
        }
        return new EMFModelDeltaThreeWayDelayedSet(eObject, feature, originalReferences, userReferences, currentReferences);
    }

    private static EObject createObject(String type) {
        if (type.equals(MPart.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createPart();
        }
        if (type.equals(MCommand.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createCommand();
        }
        if (type.equals(MHandler.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createHandler();
        }
        if (type.equals(MKeyBinding.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createKeyBinding();
        }
        if (type.equals(MMenu.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createMenu();
        }
        if (type.equals(MWindow.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createWindow();
        }
        if (type.equals(MToolBar.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createToolBar();
        }
        if (type.equals(MToolItem.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createToolItem();
        }
        if (type.equals(MDirectToolItem.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createDirectToolItem();
        }
        if (type.equals(MHandledToolItem.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createHandledToolItem();
        }
        if (type.equals(MMenuItem.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createMenuItem();
        }
        if (type.equals(MDirectMenuItem.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createDirectMenuItem();
        }
        if (type.equals(MHandledMenuItem.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createHandledMenuItem();
        }
        if (type.equals(MPartStack.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createPartStack();
        }
        if (type.equals(MPartSashContainer.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createPartSashContainer();
        }
        if (type.equals(MWindowTrim.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createWindowTrim();
        }
        if (type.equals(MPerspective.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createPerspective();
        }
        if (type.equals(MPerspectiveStack.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createPerspectiveStack();
        }
        if (type.equals(MPartDescriptor.class.getSimpleName())) {
            return (EObject)MApplicationFactory.eINSTANCE.createPartDescriptor();
        }
        return null;
    }

    private Object getReference(Collection<ModelDelta> deltas, Element element, List<Object> references) {
        String id = element.getAttribute(APPLICATIONELEMENT_ID_ATTNAME);
        if (!id.equals("")) {
            return XMLModelReconciler.findReference(references, id);
        }
        return this.createObject(deltas, element, references);
    }

    private Object createObject(Collection<ModelDelta> deltas, String typeName, Element element, List<Object> references) {
        EObject object = XMLModelReconciler.createObject(typeName);
        CompositeDelta compositeDelta = new CompositeDelta(object);
        E4XMIResource resource = (E4XMIResource)this.rootObject.eResource();
        resource.setInternalId(object, element.getAttribute(XMIID_ATTNAME));
        NodeList elementAttributes = (NodeList)((Object)element);
        int i = 0;
        while (i < elementAttributes.getLength()) {
            String attributeName;
            EStructuralFeature attributeFeature;
            Element item;
            Node node = elementAttributes.item(i);
            if (node instanceof Element && !XMLModelReconciler.isUnset(item = (Element)node) && (attributeFeature = XMLModelReconciler.getStructuralFeature(object, attributeName = item.getNodeName())) != null) {
                EMFModelDeltaSet delta;
                Object objectReference;
                String id;
                if (XMLModelReconciler.isDirectReference(attributeName)) {
                    id = item.getAttribute(attributeName);
                    objectReference = XMLModelReconciler.findReference(references, id);
                    if (objectReference == null) {
                        objectReference = this.createObject(deltas, XMLModelReconciler.getFirstElement((NodeList)((Object)item)), references);
                    }
                    delta = new EMFModelDeltaSet((Object)object, attributeFeature, objectReference);
                    compositeDelta.add(delta);
                } else if (XMLModelReconciler.isIndirectReference(attributeName)) {
                    id = item.getAttribute(attributeName);
                    objectReference = XMLModelReconciler.findReference(references, id);
                    if (objectReference == null) {
                        NodeList list = (NodeList)((Object)item);
                        Element refElement = XMLModelReconciler.getFirstElement(list);
                        if (refElement != null) {
                            ModelDelta delta2 = this.createDelayedDelta(object, attributeFeature, refElement);
                            deltas.add(delta2);
                        }
                    } else {
                        delta = new EMFModelDeltaSet((Object)object, attributeFeature, objectReference);
                        compositeDelta.add(delta);
                    }
                } else if (XMLModelReconciler.isChainedReference(attributeName)) {
                    ArrayList<Object> objectReferences = new ArrayList<Object>();
                    NodeList objectReferenceNodes = (NodeList)((Object)item);
                    int j = 0;
                    while (j < objectReferenceNodes.getLength()) {
                        Object objectReference2;
                        Node refNode = objectReferenceNodes.item(j);
                        if (refNode instanceof Element && (objectReference2 = this.getReference(deltas, (Element)refNode, references)) != null) {
                            objectReferences.add(objectReference2);
                        }
                        ++j;
                    }
                    delta = new EMFModelDeltaSet((Object)object, attributeFeature, objectReferences);
                    compositeDelta.add(delta);
                } else if (XMLModelReconciler.isUnorderedChainedAttribute(attributeName)) {
                    ModelDelta delta3 = this.createUnorderedChainedAttributeDelta(object, attributeFeature, item, attributeName);
                    deltas.add(delta3);
                } else {
                    object.eSet(attributeFeature, this.getValue(attributeFeature, item.getAttribute(attributeName)));
                }
            }
            ++i;
        }
        return compositeDelta;
    }

    private Object createObject(Collection<ModelDelta> deltas, Element reference, List<Object> references) {
        return this.createObject(deltas, reference.getAttribute(TYPE_ATTNAME), reference, references);
    }

    private ModelDelta createUnorderedChainedAttributeDelta(EObject object, EStructuralFeature feature, Element node, String featureName) {
        HashSet<Object> values = new HashSet<Object>();
        NodeList attributes = (NodeList)((Object)node);
        int j = 0;
        while (j < attributes.getLength()) {
            Element attribute = (Element)attributes.item(j);
            Object value = this.getValue(feature, attribute.getAttribute(featureName));
            values.add(value);
            ++j;
        }
        List currentValues = (List)object.eGet(feature);
        values.addAll(currentValues);
        return new EMFModelDeltaSet((Object)object, feature, new ArrayList(values));
    }

    private ModelDelta createAttributeDelta(EObject eObject, EStructuralFeature feature, Element node, String featureName) {
        Object value = this.getValue(feature, node.getAttribute(featureName));
        return new EMFModelDeltaSet((Object)eObject, feature, value);
    }

    private Document createDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ChangeDescription calculateDeltas() {
        if (this.changeDescription == null) {
            this.changeDescription = this.changeRecorder.endRecording();
        }
        return this.changeDescription;
    }

    @Override
    public Object serialize() {
        this.calculateDeltas();
        Document document = this.createDocument();
        Element root = document.createElement(CHANGES_ATTNAME);
        document.appendChild(root);
        EMap objectChanges = this.changeDescription.getObjectChanges();
        for (Map.Entry entry : objectChanges.entrySet()) {
            EObject object;
            Element persistedElement = this.persist(document, entry, object = (EObject)entry.getKey());
            if (persistedElement == null) continue;
            root.appendChild(persistedElement);
        }
        return document;
    }

    private Element persist(Document document, Map.Entry<EObject, EList<FeatureChange>> entry, EObject object) {
        if (this.getOriginalId(object) == null) {
            return null;
        }
        Element modelChange = null;
        List featureChanges = (List)entry.getValue();
        for (FeatureChange featureChange : featureChanges) {
            String featureName;
            if (featureChange.getFeature().isTransient() || !XMLModelReconciler.shouldPersist(featureName = featureChange.getFeatureName())) continue;
            if (modelChange == null) {
                modelChange = this.createElement(document, object);
            }
            Element deltaElement = this.createDeltaElement(document, object, featureChange, featureName);
            modelChange.appendChild(deltaElement);
        }
        return modelChange;
    }

    private Element createElement(Document document, EObject object) {
        String id = this.getOriginalId(object);
        Class<?> rootInterface = object.getClass().getInterfaces()[0];
        Element modelChange = document.createElement(rootInterface.getSimpleName());
        modelChange.setAttribute(APPLICATIONELEMENT_ID_ATTNAME, id);
        return modelChange;
    }

    private static String getResourceId(EObject object, EObject container) {
        Resource resource = object.eResource();
        if (resource instanceof XMLResource) {
            return ((XMLResource)resource).getID(object);
        }
        resource = container.eResource();
        if (resource instanceof XMLResource) {
            return ((XMLResource)resource).getID(object);
        }
        throw new IllegalStateException(object + " could not be identified");
    }

    private static String getLocalId(Object object) {
        EObject reference = (EObject)object;
        return XMLModelReconciler.getResourceId(reference, reference.eContainer());
    }

    private EObject getOriginalContainer(EObject reference) {
        List commands;
        EObject key;
        EMap objectChanges;
        if (this.changeDescription == null) {
            return reference.eContainer();
        }
        if (reference instanceof MCommand) {
            objectChanges = this.changeDescription.getObjectChanges();
            boolean commandsChanged = false;
            block0: for (Object entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (key != this.rootObject) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(APPLICATION_COMMANDS_ATTNAME)) continue;
                    commands = (List)change.getValue();
                    for (Object command : commands) {
                        if (command != reference) continue;
                        return key;
                    }
                    commandsChanged = true;
                    break block0;
                }
            }
            if (!commandsChanged) {
                return reference.eContainer();
            }
        }
        if (reference instanceof MHandler) {
            objectChanges = this.changeDescription.getObjectChanges();
            boolean handlersChanged = false;
            block3: for (Object entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (!(key instanceof MHandlerContainer)) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(HANDLERCONTAINER_HANDLERS_ATTNAME)) continue;
                    commands = (List)change.getValue();
                    for (Object command : commands) {
                        if (command != reference) continue;
                        return key;
                    }
                    handlersChanged = true;
                    continue block3;
                }
            }
            if (!handlersChanged) {
                return reference.eContainer();
            }
        }
        if (reference instanceof MKeyBinding) {
            objectChanges = this.changeDescription.getObjectChanges();
            boolean bindingsChanged = false;
            block6: for (Object entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (!(key instanceof MBindingContainer)) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(BINDINGCONTAINER_BINDINGS_ATTNAME)) continue;
                    commands = (List)change.getValue();
                    for (Object command : commands) {
                        if (command != reference) continue;
                        return key;
                    }
                    bindingsChanged = true;
                    continue block6;
                }
            }
            if (!bindingsChanged) {
                return reference.eContainer();
            }
        }
        if (reference instanceof MUIElement) {
            objectChanges = this.changeDescription.getObjectChanges();
            for (Map.Entry entry : objectChanges.entrySet()) {
                EObject key2 = (EObject)entry.getKey();
                if (key2 != reference) continue;
                for (FeatureChange change : (EList)entry.getValue()) {
                    if (!change.getFeatureName().equals(UIELEMENT_PARENT_ATTNAME)) continue;
                    return (EObject)change.getValue();
                }
            }
            if (reference instanceof MMenu) {
                boolean appendedMenu = false;
                block11: for (Object entry : objectChanges.entrySet()) {
                    key = (EObject)entry.getKey();
                    if (!(key instanceof MPart)) continue;
                    for (Object change : (EList)entry.getValue()) {
                        if (!change.getFeatureName().equals(PART_MENUS_ATTNAME)) continue;
                        List originalMenus = (List)change.getValue();
                        if (originalMenus.contains(reference)) {
                            return key;
                        }
                        if (!((MPart)key).getMenus().contains((Object)reference)) continue block11;
                        appendedMenu = true;
                        continue block11;
                    }
                }
                boolean menuSet = false;
                boolean menuChanged = false;
                block13: for (Map.Entry entry : objectChanges.entrySet()) {
                    EObject key3 = (EObject)entry.getKey();
                    if (!(key3 instanceof MWindow)) continue;
                    for (FeatureChange change : (EList)entry.getValue()) {
                        if (!change.getFeatureName().equals(WINDOW_MAINMENU_ATTNAME)) continue;
                        Object oldMenu = change.getValue();
                        if (oldMenu == reference) {
                            return key3;
                        }
                        if (oldMenu == null && ((MWindow)key3).getMainMenu() == reference) {
                            menuSet = true;
                        }
                        menuChanged = true;
                        continue block13;
                    }
                }
                if (menuChanged && menuSet) {
                    return null;
                }
                if (appendedMenu && !menuSet && !menuChanged) {
                    return null;
                }
            }
            if (reference instanceof MToolBar) {
                for (Map.Entry entry : objectChanges.entrySet()) {
                    EObject key4 = (EObject)entry.getKey();
                    if (!(key4 instanceof MPart)) continue;
                    for (FeatureChange change : (EList)entry.getValue()) {
                        if (!change.getFeatureName().equals(PART_TOOLBAR_ATTNAME) || change.getValue() != reference) continue;
                        return key4;
                    }
                }
            }
            boolean newElement = false;
            block17: for (Map.Entry entry : objectChanges.entrySet()) {
                key = (EObject)entry.getKey();
                if (key != reference.eContainer()) continue;
                for (Object change : (EList)entry.getValue()) {
                    if (change.getFeatureName().equals(ELEMENTCONTAINER_CHILDREN_ATTNAME)) {
                        EList value = (EList)change.getValue();
                        if (value.contains((Object)reference)) {
                            return key;
                        }
                        newElement = true;
                        break block17;
                    }
                    if (!change.getFeatureName().equals(PART_TOOLBAR_ATTNAME)) continue;
                    if (reference.equals(change.getValue())) {
                        return key;
                    }
                    newElement = true;
                    break block17;
                }
            }
            if (!newElement) {
                return reference instanceof MApplication ? this.changeDescription : reference.eContainer();
            }
        }
        return null;
    }

    private String getOriginalId(Object object) {
        EObject reference = (EObject)object;
        EObject originalContainer = this.getOriginalContainer(reference);
        if (originalContainer == null) {
            return null;
        }
        if (originalContainer != this.changeDescription) {
            EObject container = originalContainer;
            while (container != this.rootObject) {
                if ((container = this.getOriginalContainer(container)) != null) continue;
                return null;
            }
        }
        return XMLModelReconciler.getResourceId(reference, originalContainer);
    }

    private Element createDeltaElement(Document document, EObject object, FeatureChange featureChange, String featureName) {
        EStructuralFeature feature = featureChange.getFeature();
        if (object.eIsSet(feature)) {
            return this.createSetDeltaElement(document, object, featureChange, featureName, feature);
        }
        return this.createUnsetDeltaElement(document, featureChange, featureName);
    }

    private Element createSetDeltaElement(Document document, EObject object, FeatureChange featureChange, String featureName, EStructuralFeature feature) {
        Element featureElement = document.createElement(featureName);
        Object value = object.eGet(feature);
        if (XMLModelReconciler.isSingleReference(featureName)) {
            Element referenceElement = this.createReferenceElement(document, (EObject)value, featureName);
            featureElement.appendChild(referenceElement);
        } else if (XMLModelReconciler.isChainedReference(featureName)) {
            this.appendReferenceElements(document, featureElement, (List)value);
            this.appendOriginalReferenceElements(document, featureElement, (List)featureChange.getValue());
        } else if (XMLModelReconciler.isUnorderedChainedAttribute(featureName)) {
            List attributes = (List)value;
            for (Object attribute : attributes) {
                Element attributeElement = document.createElement(featureName);
                attributeElement.setAttribute(featureName, String.valueOf(attribute));
                featureElement.appendChild(attributeElement);
            }
        } else {
            featureElement.setAttribute(featureName, String.valueOf(value));
        }
        return featureElement;
    }

    private Element createUnsetDeltaElement(Document document, FeatureChange featureChange, String featureName) {
        Element featureElement = document.createElement(featureName);
        if (XMLModelReconciler.isChainedReference(featureName)) {
            this.appendOriginalReferenceElements(document, featureElement, (List)featureChange.getValue());
        } else {
            featureElement.setAttribute(UNSET_ATTNAME, UNSET_ATTVALUE_TRUE);
        }
        return featureElement;
    }

    private Element createOriginalReferenceElement(Document document, Object reference) {
        Element referenceElement = document.createElement(ORIGINALREFERENCE_ELEMENT_NAME);
        referenceElement.setAttribute(APPLICATIONELEMENT_ID_ATTNAME, this.getOriginalId(reference));
        return referenceElement;
    }

    private void appendOriginalReferenceElements(Document document, Element element, List<?> references) {
        for (Object reference : references) {
            Element referenceElement = this.createOriginalReferenceElement(document, reference);
            element.appendChild(referenceElement);
        }
    }

    private Element createReferenceElement(Document document, EObject eObject, String featureName) {
        String id = this.getOriginalId(eObject);
        if (id == null) {
            if (featureName == null || XMLModelReconciler.isDirectReference(featureName)) {
                return this.createNewReferenceElement(document, eObject);
            }
            return this.createUniqueReferenceElement(document, eObject);
        }
        Element referenceElement = document.createElement(REFERENCE_ELEMENT_NAME);
        referenceElement.setAttribute(APPLICATIONELEMENT_ID_ATTNAME, id);
        return referenceElement;
    }

    private void appendReferenceElements(Document document, Element element, List<?> references) {
        for (Object reference : references) {
            Element ef = this.createReferenceElement(document, (EObject)reference, null);
            element.appendChild(ef);
        }
    }

    private Element createNewReferenceElement(Document document, EObject eObject) {
        Element referenceElement = this.createUniqueReferenceElement(document, eObject);
        referenceElement.setAttribute(UNSET_ATTNAME, UNSET_ATTVALUE_TRUE);
        referenceElement.setAttribute(TYPE_ATTNAME, eObject.getClass().getInterfaces()[0].getSimpleName());
        for (EStructuralFeature collectedFeature : XMLModelReconciler.collectFeatures(eObject)) {
            String featureName = collectedFeature.getName();
            if (collectedFeature.isTransient() || !XMLModelReconciler.shouldPersist(featureName)) continue;
            Element referenceAttributeElement = this.createAttributeElement(document, eObject, collectedFeature, featureName);
            referenceElement.appendChild(referenceAttributeElement);
        }
        return referenceElement;
    }

    private Element createUniqueReferenceElement(Document document, EObject eObject) {
        Element referenceElement = document.createElement(REFERENCE_ELEMENT_NAME);
        E4XMIResource resource = (E4XMIResource)this.rootObject.eResource();
        String internalId = resource.getInternalId(eObject);
        referenceElement.setAttribute(XMIID_ATTNAME, internalId);
        return referenceElement;
    }

    private Element createAttributeElement(Document document, EObject object, EStructuralFeature feature, String featureName) {
        Element referenceAttributeElement = document.createElement(featureName);
        if (object.eIsSet(feature)) {
            if (XMLModelReconciler.isSingleReference(featureName)) {
                Object value = object.eGet(feature);
                String id = this.getOriginalId(value);
                if (id == null) {
                    Element referenceElement = this.createReferenceElement(document, (EObject)value, featureName);
                    referenceAttributeElement.appendChild(referenceElement);
                } else {
                    referenceAttributeElement.setAttribute(featureName, id);
                }
            } else if (XMLModelReconciler.isChainedReference(featureName)) {
                List references = (List)object.eGet(feature);
                this.appendReferenceElements(document, referenceAttributeElement, references);
            } else if (XMLModelReconciler.isUnorderedChainedAttribute(featureName)) {
                List attributes = (List)object.eGet(feature);
                for (Object attribute : attributes) {
                    Element attributeElement = document.createElement(featureName);
                    attributeElement.setAttribute(featureName, String.valueOf(attribute));
                    referenceAttributeElement.appendChild(attributeElement);
                }
            } else {
                referenceAttributeElement.setAttribute(featureName, String.valueOf(object.eGet(feature)));
            }
        } else {
            referenceAttributeElement.setAttribute(UNSET_ATTNAME, UNSET_ATTVALUE_TRUE);
        }
        return referenceAttributeElement;
    }

    private static boolean isDirectReference(String featureName) {
        return featureName.equals(WINDOW_MAINMENU_ATTNAME) || featureName.equals(PART_TOOLBAR_ATTNAME);
    }

    private static boolean isIndirectReference(String featureName) {
        return featureName.equals(ELEMENTCONTAINER_SELECTEDELEMENT_ATTNAME) || featureName.equals(HANDLER_COMMAND_ATTNAME) || featureName.equals(KEYBINDING_COMMAND_ATTNAME);
    }

    private static boolean isSingleReference(String featureName) {
        return XMLModelReconciler.isDirectReference(featureName) || XMLModelReconciler.isIndirectReference(featureName);
    }

    private static boolean isChainedReference(String featureName) {
        return featureName.equals(ELEMENTCONTAINER_CHILDREN_ATTNAME) || featureName.equals(BINDINGCONTAINER_BINDINGS_ATTNAME) || featureName.equals(PART_MENUS_ATTNAME) || featureName.equals(APPLICATION_COMMANDS_ATTNAME) || featureName.equals(HANDLERCONTAINER_HANDLERS_ATTNAME);
    }

    private static boolean isUnorderedChainedAttribute(String featureName) {
        return featureName.equals(APPLICATIONELEMENT_TAGS_ATTNAME);
    }

    private static boolean shouldPersist(String featureName) {
        return !featureName.equals(UIELEMENT_PARENT_ATTNAME) && !featureName.equals(PARTDESCRIPTORCONTAINER_DESCRIPTORS_ATTNAME);
    }

    private static Collection<EStructuralFeature> collectFeatures(Collection<EStructuralFeature> features, EClass eClass) {
        features.addAll((Collection<EStructuralFeature>)eClass.getEStructuralFeatures());
        for (EClass superType : eClass.getESuperTypes()) {
            XMLModelReconciler.collectFeatures(features, superType);
        }
        return features;
    }

    private static Collection<EStructuralFeature> collectFeatures(EObject object) {
        return XMLModelReconciler.collectFeatures(new HashSet<EStructuralFeature>(), object.eClass());
    }

    private static boolean isUnset(Element element) {
        return UNSET_ATTVALUE_TRUE.equals(element.getAttribute(UNSET_ATTNAME));
    }

    static class Position {
        private final Object object;
        private final Object after;
        private final Object before;

        Position(Object object, Object after, Object before) {
            this.object = object;
            this.after = after;
            this.before = before;
        }

        public Object getObject() {
            return this.object;
        }

        public Object getBefore() {
            return this.before;
        }

        public Object getAfter() {
            return this.after;
        }
    }
}

