/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.controls.shell;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

public class Shell_Styles {
    private static List<Shell> shells = new ArrayList<Shell>();

    public static void main(String[] args) {
        URL url = Shell_Styles.class.getResource(String.valueOf(Shell_Styles.class.getSimpleName()) + ".xwt");
        try {
            XWT.open((URL)url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createShell(Event event) {
        Button button = (Button)event.widget;
        Composite parent = button.getParent();
        Control[] children = parent.getChildren();
        int style = 0;
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Group grp;
            String text;
            Control control = controlArray[n2];
            if (control instanceof Group && ("Decoration Styles".equals(text = (grp = (Group)control).getText()) || "Modal Styles".equals(text))) {
                style |= this.createStyle(grp);
            }
            ++n2;
        }
        Shell shell = new Shell(style);
        shell.open();
        shells.add(shell);
    }

    private int createStyle(Group grp) {
        Control[] children;
        int style = 0;
        Control[] controlArray = children = grp.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Button) {
                Button btn = (Button)control;
                String str = btn.getText();
                if (btn.getSelection()) {
                    if ("SWT.NO_TRIM".equals(str)) {
                        style |= 8;
                    } else if ("SWT.CLOSE".equals(str)) {
                        style |= 0x40;
                    } else if ("SWT.MIN".equals(str)) {
                        style |= 0x80;
                    } else if ("SWT.MAX".equals(str)) {
                        style |= 0x400;
                    } else if ("SWT.RESIZE".equals(str)) {
                        style |= 0x10;
                    } else if ("SWT.TOOL".equals(str)) {
                        style |= 4;
                    } else if ("SWT.TITLE".equals(str)) {
                        style |= 0x20;
                    } else if ("SWT.BORDER".equals(str)) {
                        style |= 0x800;
                    } else if ("SWT.ON_TOP".equals(str)) {
                        style |= 0x4000;
                    } else if ("SWT.MODELESS".equals(str)) {
                        style |= 0;
                    } else if ("SWT.PRIMARY_MODAL".equals(str)) {
                        style |= 0x8000;
                    } else if ("SWT.APPLICATION_MODAL".equals(str)) {
                        style |= 0x10000;
                    } else if ("SWT.SYSTEM_MODAL".equals(str)) {
                        style |= 0x20000;
                    }
                }
            }
            ++n2;
        }
        return style;
    }

    protected void closeAllShells(Event event) {
        if (shells.isEmpty()) {
            return;
        }
        for (Shell shell : shells) {
            shell.dispose();
        }
    }
}

