/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tests.xaml;

import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.e4.xwt.internal.xml.Attribute;
import org.eclipse.e4.xwt.internal.xml.DocumentObject;
import org.eclipse.e4.xwt.internal.xml.Element;
import org.eclipse.e4.xwt.internal.xml.ElementManager;

public class BindingExpressionTests
extends TestCase {
    public void testBindingExpression() throws Exception {
        URL url = BindingExpressionTests.class.getResource("BindingExpression.xwt");
        try {
            ElementManager elementManager = new ElementManager();
            Element element = elementManager.load(url);
            this.checkTextValue(element, "path", "name");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testBindingExpression_path() throws Exception {
        URL url = BindingExpressionTests.class.getResource("BindingExpression_Path.xwt");
        try {
            ElementManager elementManager = new ElementManager();
            Element element = elementManager.load(url);
            this.checkTextValue(element, "path", "employees.name");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testBindingExpression_Attached() throws Exception {
        URL url = BindingExpressionTests.class.getResource("BindingExpression_Attached.xwt");
        try {
            ElementManager elementManager = new ElementManager();
            Element element = elementManager.load(url);
            this.checkTextValue(element, "path", "(Person.name)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testBindingExpression_Indexer() throws Exception {
        URL url = BindingExpressionTests.class.getResource("BindingExpression_Indexer.xwt");
        try {
            ElementManager elementManager = new ElementManager();
            Element element = elementManager.load(url);
            this.checkTextValue(element, "path", "persons[1].name");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testBindingExpression_Namespace() throws Exception {
        URL url = BindingExpressionTests.class.getResource("BindingExpression_Namespace.xwt");
        try {
            ElementManager elementManager = new ElementManager();
            Element element = elementManager.load(url);
            this.checkTextValue(element, "path", "(gui.Person.name)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testBindingExpression_NamespaceUpdateSourceTrigger() throws Exception {
        URL url = BindingExpressionTests.class.getResource("BindingExpression_NamespaceUpdateSourceTrigger.xwt");
        try {
            ElementManager elementManager = new ElementManager();
            Element element = elementManager.load(url);
            this.checkTextValue(element, "path", "(gui.Person.name)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testBindingExpression_UpdateSourceTrigger() throws Exception {
        URL url = BindingExpressionTests.class.getResource("BindingExpression_UpdateSourceTrigger.xwt");
        try {
            ElementManager elementManager = new ElementManager();
            Element element = elementManager.load(url);
            this.checkTextValue(element, "UpdateSourceTrigger", "PropertyChanged");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void checkTextValue(Element element, String name, String value) {
        Attribute attribute = element.getAttribute("Text");
        BindingExpressionTests.assertEquals((String)attribute.getName(), (String)"Text");
        BindingExpressionTests.assertEquals((int)attribute.getChildren().length, (int)1);
        DocumentObject child = attribute.getChildren()[0];
        BindingExpressionTests.assertEquals((String)child.getName(), (String)"Binding");
        BindingExpressionTests.assertTrue((boolean)(child instanceof Element));
        Element childElement = (Element)child;
        Attribute pathAttribute = childElement.getAttribute(name);
        BindingExpressionTests.assertTrue((pathAttribute != null ? 1 : 0) != 0);
        BindingExpressionTests.assertEquals((String)pathAttribute.getContent(), (String)value);
    }
}

