/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.editor.actions;

import java.lang.reflect.Constructor;
import java.util.List;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.EditDomain;
import org.eclipse.e4.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.e4.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasteElementAction
extends SelectionAction {
    private XWTDesigner part;
    private Object contents;
    private EditPart parent;

    public PasteElementAction(IWorkbenchPart part) {
        super(part);
        this.part = (XWTDesigner)part;
        this.setText(WorkbenchMessages.Workbench_paste);
        this.setToolTipText(WorkbenchMessages.Workbench_pasteToolTip);
        this.setId(ActionFactory.PASTE.getId());
        this.setAccelerator(SWT.MOD1 | 0x76);
        ISharedImages sharedImages = part.getSite().getWorkbenchWindow().getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
    }

    protected boolean calculateEnabled() {
        this.contents = Clipboard.getDefault().getContents();
        if (this.contents == null) {
            return false;
        }
        if (this.part.getGraphicalViewer() == null) {
            return false;
        }
        List parts = this.part.getGraphicalViewer().getSelectedEditParts();
        if (parts == null || parts.isEmpty()) {
            return false;
        }
        this.parent = (EditPart)parts.get(0);
        Object model = this.parent.getModel();
        if (model == null || !(model instanceof XamlElement)) {
            return false;
        }
        return this.canPaste((XamlElement)model);
    }

    public void run() {
        XamlElement parentNode = (XamlElement)this.parent.getModel();
        List elements = (List)this.contents;
        CompoundCommand cmd = new CompoundCommand("Paste");
        for (XamlElement child : elements) {
            XamlElement newChild = (XamlElement)EcoreUtil.copy((EObject)child);
            cmd.add((Command)new AddNewChildCommand((XamlNode)parentNode, (XamlNode)newChild));
        }
        Command command = cmd.unwrap();
        if (command.canExecute()) {
            EditDomain.getEditDomain((EditPart)this.parent).getCommandStack().execute(command);
        }
    }

    public Boolean canPaste(XamlElement parent) {
        Class<?> parentType = null;
        parentType = this.getType((XamlNode)parent);
        if (parentType == null) {
            return false;
        }
        List contents = (List)Clipboard.getDefault().getContents();
        boolean canCreate = false;
        for (XamlElement element : contents) {
            Class<?> createtype = this.getType((XamlNode)element);
            if (createtype == null) {
                return false;
            }
            if (this.canPaste(createtype, parentType, parent).booleanValue()) continue;
            return false;
        }
        canCreate = true;
        return canCreate;
    }

    public Class<?> getType(XamlNode element) {
        if (element == null) {
            return null;
        }
        IMetaclass metaclass = XWTUtility.getMetaclass(element);
        if (metaclass != null) {
            return metaclass.getType();
        }
        return null;
    }

    public Boolean canPaste(Object createType, Class<?> parentType, XamlElement parent) {
        boolean canCreate = false;
        if (createType instanceof Class) {
            Constructor<?>[] constructors;
            Class type = (Class)createType;
            if (CoolBar.class.isAssignableFrom(parentType) && !CoolItem.class.isAssignableFrom(type)) {
                return false;
            }
            if (ExpandBar.class.isAssignableFrom(parentType) && !ExpandItem.class.isAssignableFrom(type)) {
                return false;
            }
            if (CoolItem.class.isAssignableFrom(parentType) && Control.class.isAssignableFrom(type) && !CoolBar.class.isAssignableFrom(type)) {
                return true;
            }
            if (ExpandItem.class.isAssignableFrom(parentType) && Control.class.isAssignableFrom(type) && !ExpandBar.class.isAssignableFrom(type)) {
                return true;
            }
            Constructor<?>[] constructorArray = constructors = ((Class)createType).getConstructors();
            int n = constructors.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != 0 && parameterTypes[0].isAssignableFrom(parentType)) {
                    canCreate = true;
                    break;
                }
                ++n2;
            }
        } else if (createType instanceof String) {
            String stringType = (String)createType;
            IMetaclass metaclass = XWT.getMetaclass(parentType);
            if (metaclass != null) {
                boolean bl = canCreate = metaclass.findProperty((String)createType) != null;
                if ("menuBar".equals(stringType) || "menu".equals(stringType) || "layoutData".equals(stringType)) {
                    canCreate = canCreate && parent.getAttribute(stringType) == null;
                }
            }
        }
        return canCreate;
    }
}

