/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.editor.event;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.e4.xwt.tools.ui.designer.jdt.ASTHelper;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventHandler {
    private XWTDesigner designer;
    private IType type;

    public EventHandler(XWTDesigner designer, IType type) {
        this.designer = designer;
        this.type = type;
        if (type == null) {
            throw new NullPointerException("Java Source Type is Null!");
        }
    }

    public boolean exist(String handlerName) {
        try {
            IMethod[] methods = this.type.getMethods();
            if (this.findMethod(methods, handlerName) != null) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public String suggestDefaultName(XamlElement element, String value) {
        String name = value;
        if (!this.exist(name)) {
            return name;
        }
        int i = 0;
        String elementName = "";
        XamlAttribute attribute = element.getAttribute("name", "http://www.eclipse.org/xwt");
        if (attribute == null) {
            attribute = element.getAttribute("name", "http://www.eclipse.org/xwt/presentation");
        }
        if (attribute != null) {
            elementName = attribute.getValue().trim();
        }
        if (elementName == null || elementName.length() == 0) {
            elementName = element.getName();
        }
        if (elementName == null) {
            elementName = "";
        }
        if (elementName.length() > 1) {
            elementName = String.valueOf(Character.toUpperCase(elementName.charAt(0))) + elementName.substring(1);
        }
        name = String.valueOf(value) + elementName;
        while (this.exist(name)) {
            name = String.valueOf(value) + elementName + ++i;
        }
        return name;
    }

    private IMethod findMethod(IMethod[] methods, String methodName) {
        int i = 0;
        while (i < methods.length) {
            IMethod method = methods[i];
            if (method.getElementName().equals(methodName)) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public void createHandler(String handlerName) {
        if (handlerName == null) {
            return;
        }
        ArrayList argus = new ArrayList();
        argus.add(Object.class);
        argus.add(Event.class);
        this.createHandler(handlerName, null, null, argus);
    }

    public void createHandler(String methodName, Class<?> returnType, String contentReturnValue, List<Class<?>> arguments) {
        ASTHelper.createMethod(this.type, methodName, returnType, contentReturnValue, arguments);
    }

    public void createHandlers() {
        XamlDocument xamlDocument = (XamlDocument)this.designer.getDocumentRoot();
        XamlElement rootElement = xamlDocument.getRootElement();
        ArrayList<XamlAttribute> handlerAttrs = new ArrayList<XamlAttribute>();
        this.retrieveHandlerAttrs(rootElement, handlerAttrs);
        if (handlerAttrs.isEmpty()) {
            return;
        }
        for (XamlAttribute xamlAttribute : handlerAttrs) {
            String handlerName = xamlAttribute.getValue();
            this.createHandler(handlerName);
        }
    }

    private void retrieveHandlerAttrs(XamlElement element, List<XamlAttribute> handlers) {
        EList attributeNames = element.attributeNames();
        for (String attrName : attributeNames) {
            XamlAttribute attribute;
            if (!attrName.endsWith("Event") || (attribute = element.getAttribute(attrName)) == null || attribute.getValue() == null) continue;
            handlers.add(attribute);
        }
        for (XamlElement child : element.getChildNodes()) {
            this.retrieveHandlerAttrs(child, handlers);
        }
    }
}

