/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.editor.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.Designer;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.text.StructuredTextHelper;
import org.eclipse.e4.xwt.tools.ui.designer.core.model.AbstractModelBuilder;
import org.eclipse.e4.xwt.tools.ui.designer.core.model.IModelBuilder;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.DisplayUtil;
import org.eclipse.e4.xwt.tools.ui.designer.editor.model.BraceHandler;
import org.eclipse.e4.xwt.tools.ui.designer.editor.model.BuilderContext;
import org.eclipse.e4.xwt.tools.ui.designer.editor.model.ModelAdapter;
import org.eclipse.e4.xwt.tools.ui.designer.editor.model.ModelCacheUtility;
import org.eclipse.e4.xwt.tools.ui.designer.editor.model.Synchronizer;
import org.eclipse.e4.xwt.tools.ui.designer.editor.model.TextNotification;
import org.eclipse.e4.xwt.tools.ui.designer.utils.XWTModelUtil;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XWTModelBuilder
extends AbstractModelBuilder
implements IModelBuilder {
    private Designer designer;
    private XamlDocument document;
    private IDocument jfaceDom;
    private IFile input;
    private static Random RANDOM = new Random();
    private BraceHandler braceHandler;
    private BuilderContext fContext;
    private Synchronizer synch;
    private ModelAdapter modelAdapter;
    private ReloadJob reloadJob;
    private NodeAdapter nodeAdapter = new NodeAdapter();

    public static String generateID(String typeName) {
        return String.valueOf(typeName) + RANDOM.nextInt(Integer.MAX_VALUE);
    }

    public boolean doLoad(Designer designer, IProgressMonitor monitor) {
        IDOMDocument textDocument;
        this.designer = designer;
        this.input = designer.getInputFile();
        this.jfaceDom = designer.getDocument();
        if (this.jfaceDom == null) {
            return false;
        }
        if (this.input != null) {
            this.document = ModelCacheUtility.doLoadFromCache(this.input, monitor);
        }
        if (this.document == null) {
            this.document = XamlFactory.eINSTANCE.createXamlDocument();
        }
        if ((textDocument = this.getTextDocument(this.jfaceDom)) == null) {
            return false;
        }
        if (monitor != null) {
            monitor.beginTask("Loading Document", 100);
        }
        this.jfaceDom.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (event.getOffset() == 0 && event.getLength() != 0 && event.getText() != null) {
                    new ReloadJob().schedule();
                }
            }
        });
        if (this.synch == null) {
            this.synch = new Synchronizer();
        }
        this.fContext = new BuilderContext(this, textDocument, this.document, this.synch);
        this.fContext.setNodeAdapter(this.nodeAdapter);
        this.modelAdapter = new ModelAdapter(this.fContext);
        if (!this.document.eAdapters().contains((Object)this.modelAdapter)) {
            this.document.eAdapters().add((Object)this.modelAdapter);
        }
        IDOMElement textElement = (IDOMElement)textDocument.getDocumentElement();
        this.loadingModel(textElement, monitor);
        return true;
    }

    private BraceHandler getBraceHandler() {
        if (this.braceHandler == null) {
            this.braceHandler = this.createBraceHandler(this.document);
        }
        return this.braceHandler;
    }

    protected BraceHandler createBraceHandler(XamlDocument document) {
        return new BraceHandler(document);
    }

    protected void handleDeclaredNamespaces(String prefix, String namespace) {
        if (this.document != null) {
            this.document.getDeclaredNamespaces().put((Object)prefix, (Object)namespace);
        }
    }

    public XamlDocument getDocumentRoot() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadingModel(IDOMElement text, IProgressMonitor monitor) {
        if (!this.synch.isFree()) {
            return;
        }
        Synchronizer synchronizer = this.synch;
        synchronized (synchronizer) {
            this.synch.setEventType(Synchronizer.EventType.LoadingEvent);
            try {
                String name = text.getLocalName();
                String nsURI = text.getNamespaceURI();
                String prefix = text.getPrefix();
                XamlElement rootElement = this.document.getRootElement();
                boolean isNew = false;
                if (rootElement == null || !name.equals(rootElement.getName())) {
                    rootElement = XamlFactory.eINSTANCE.createElement(name, nsURI);
                    isNew = true;
                }
                if (monitor != null) {
                    monitor.subTask("Load element " + name);
                    monitor.worked(1);
                }
                rootElement.setPrefix(prefix);
                this.createChild((XamlNode)rootElement, text, monitor);
                this.fContext.map((XamlNode)rootElement, (IDOMNode)text);
                if (isNew) {
                    this.document.setRootElement(rootElement);
                }
            }
            finally {
                this.synch.setFree();
            }
        }
    }

    protected void createChild(XamlNode parent, IDOMElement text, IProgressMonitor monitor) {
        String content;
        NamedNodeMap attrMap = text.getAttributes();
        if (attrMap != null) {
            int length = attrMap.getLength();
            int i = 0;
            while (i < length) {
                IDOMAttr item = (IDOMAttr)attrMap.item(i);
                String localName = item.getLocalName();
                String value = item.getNodeValue();
                String prefix = item.getPrefix();
                if ("xmlns".equals(localName)) {
                    this.handleDeclaredNamespaces(null, value);
                }
                if ("xmlns".equals(prefix)) {
                    this.handleDeclaredNamespaces(localName, value);
                }
                ++i;
            }
        }
        List<IDOMNode> attributes = this.fContext.getAttributes((IDOMNode)text);
        ArrayList oldAttrs = new ArrayList(parent.getAttributes());
        int i = 0;
        while (i < attributes.size()) {
            IDOMNode attr = attributes.get(i);
            oldAttrs.remove(this.createAttribute(parent, attr, i));
            if (monitor != null) {
                monitor.subTask("Load attr " + attr.getNodeName());
                monitor.worked(1);
            }
            ++i;
        }
        if (!oldAttrs.isEmpty()) {
            parent.getAttributes().removeAll(oldAttrs);
        }
        List<IDOMElement> childNodes = this.fContext.getChildNodes((IDOMNode)text);
        ArrayList oldChildren = new ArrayList(parent.getChildNodes());
        int i2 = 0;
        while (i2 < childNodes.size()) {
            IDOMElement child = childNodes.get(i2);
            oldChildren.remove(this.createElement(parent, child, i2));
            if (monitor != null) {
                monitor.subTask("Load child " + child.getNodeName());
                monitor.worked(1);
            }
            ++i2;
        }
        if (!oldChildren.isEmpty()) {
            parent.getChildNodes().removeAll(oldChildren);
        }
        if ((content = this.fContext.getContent((IDOMNode)text)) != null) {
            parent.setValue(content);
        }
    }

    private String normalizeName(String tagName) {
        if (tagName == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        boolean isH = false;
        int i = 0;
        int len = tagName.length();
        while (i < len) {
            char c = tagName.charAt(i);
            if (i == 0) {
                buffer.append(Character.toUpperCase(c));
            } else {
                switch (c) {
                    case '-': {
                        isH = true;
                        break;
                    }
                    case '.': {
                        isH = true;
                        buffer.append(c);
                        break;
                    }
                    default: {
                        if (isH) {
                            buffer.append(Character.toUpperCase(c));
                            isH = false;
                            break;
                        }
                        buffer.append(c);
                    }
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    protected XamlElement createElement(XamlNode parent, IDOMElement child, int index) {
        String name = child.getLocalName();
        String prefix = child.getPrefix();
        String ns = this.document.getDeclaredNamespace(prefix);
        XamlElement element = parent.getChild(index);
        if (element == null || element.getName() == null || element.getNamespace() == null || !element.getName().equals(name) || !element.getNamespace().equals(ns)) {
            element = XamlFactory.eINSTANCE.createElement(this.normalizeName(name), ns);
            element.setId(XWTModelBuilder.generateID(name));
        }
        this.fContext.map((XamlNode)element, (IDOMNode)child);
        element.setPrefix(prefix);
        this.createChild((XamlNode)element, child, null);
        return this.addChild(parent, element, index);
    }

    protected XamlNode createAttribute(XamlNode parent, IDOMNode attr, int index) {
        if (attr == null) {
            return null;
        }
        String localName = attr.getLocalName();
        String value = attr.getNodeValue();
        String prefix = attr.getPrefix();
        String ns = this.document.getDeclaredNamespace(prefix);
        String name = localName;
        int i = localName.indexOf(".");
        if (i != -1) {
            name = localName.substring(i + 1);
        }
        if (name == null || "".equals(name)) {
            return null;
        }
        if ("xmlns".equals(name)) {
            this.handleDeclaredNamespaces(null, value);
            return null;
        }
        if ("xmlns".equals(prefix)) {
            this.handleDeclaredNamespaces(name, value);
            return null;
        }
        XamlAttribute nameAttr = this.getAttribute(parent, name, ns);
        if (nameAttr == null) {
            nameAttr = XamlFactory.eINSTANCE.createAttribute(this.normalizeName(name), ns);
            nameAttr.setId(XWTModelBuilder.generateID(name));
        }
        if (attr instanceof IDOMElement) {
            IDOMElement child = (IDOMElement)attr;
            this.createChild((XamlNode)nameAttr, child, null);
        }
        nameAttr.setPrefix(prefix);
        if (this.handleBraces(value)) {
            XamlNode valueNode = this.getBraceHandler().parse((XamlNode)nameAttr, value);
            if (valueNode != null && valueNode instanceof XamlElement) {
                this.addChild((XamlNode)nameAttr, (XamlElement)valueNode, -1);
            }
            Iterator iterator = nameAttr.getChildNodes().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() == valueNode) continue;
                iterator.remove();
            }
            nameAttr.setValue(null);
        } else {
            nameAttr.setValue(value);
            if (value != null) {
                nameAttr.getChildNodes().clear();
            }
        }
        this.fContext.map((XamlNode)nameAttr, attr);
        return this.addAttribute(parent, nameAttr, index);
    }

    private boolean handleBraces(String value) {
        return value != null && value.startsWith("{") && value.endsWith("}");
    }

    protected XamlAttribute getAttribute(XamlNode parent, String attrName, String namespace) {
        return XWTModelUtil.getAdaptableAttribute(parent, attrName, namespace);
    }

    protected XamlElement addChild(XamlNode parent, XamlElement n, int index) {
        int oldIndex;
        if (parent == null || n == null) {
            return n;
        }
        EList childNodes = parent.getChildNodes();
        int size = childNodes.size();
        if (!parent.getChildNodes().contains((Object)n)) {
            if (index < 0 || index > size) {
                index = size - 1;
            }
            if (index < 0) {
                index = 0;
            }
            childNodes.add(index, (Object)n);
        } else if (index >= 0 && index < size && (oldIndex = childNodes.indexOf((Object)n)) != index) {
            childNodes.move(index, oldIndex);
        }
        return n;
    }

    protected XamlAttribute addAttribute(XamlNode parent, XamlAttribute a, int index) {
        int oldIndex;
        if (parent == null || a == null) {
            return null;
        }
        EList attributes = parent.getAttributes();
        int size = attributes.size();
        if (!parent.getAttributes().contains((Object)a)) {
            if (index < 0 || index > size) {
                index = size - 1;
            }
            if (index < 0) {
                index = 0;
            }
            attributes.add(index, (Object)a);
        } else if (index >= 0 && index < size && (oldIndex = attributes.indexOf((Object)a)) != index) {
            attributes.move(index, oldIndex);
        }
        return a;
    }

    protected IDOMDocument getTextDocument(IDocument doc) {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(doc);
        if (model != null && model instanceof IDOMModel) {
            return ((IDOMModel)model).getDocument();
        }
        return null;
    }

    protected void format() {
        if (this.jfaceDom != null) {
            IDOMDocument textDocument = this.getTextDocument(this.jfaceDom);
            if (textDocument != null) {
                IDOMElement textElement = (IDOMElement)textDocument.getDocumentElement();
                this.formatRemoveEmpty((Node)textElement);
            }
            StructuredTextHelper.format((IDocument)this.jfaceDom);
        }
    }

    protected void formatRemoveEmpty(Node node) {
        if (node == null) {
            return;
        }
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node item = childNodes.item(i);
                if (item.getNodeType() == 3) {
                    TextImpl t = (TextImpl)item;
                    if (t.isWhitespace() || t.isInvalid()) {
                        Node next = t.getNextSibling();
                        while (next != null && next.getNodeType() == 3 && (((TextImpl)next).isWhitespace() || ((TextImpl)next).isInvalid())) {
                            node.removeChild(next);
                            next = next.getNextSibling();
                        }
                    }
                } else {
                    this.formatRemoveEmpty(item);
                }
                ++i;
            }
        }
    }

    protected boolean contains(Node parent, Attr attr) {
        NamedNodeMap attributes = parent.getAttributes();
        int i = attributes.getLength() - 1;
        while (i >= 0) {
            if (attr == attributes.item(i)) {
                return true;
            }
            --i;
        }
        return false;
    }

    public void reload() {
        if (!this.synch.isFree()) {
            return;
        }
        if (this.document == null || this.jfaceDom == null) {
            return;
        }
        IDOMDocument textDocument = this.getTextDocument(this.jfaceDom);
        if (textDocument == null) {
            return;
        }
        IDOMElement textElement = (IDOMElement)textDocument.getDocumentElement();
        this.loadingModel(textElement, null);
    }

    public void dispose() {
        this.doSave(null);
        this.document = null;
        this.jfaceDom = null;
        this.fContext.clear();
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null || PlatformUI.isWorkbenchRunning()) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        return display;
    }

    protected boolean isValidThread() {
        return this.getDisplay() == null || this.getDisplay().getThread() == Thread.currentThread();
    }

    public void doSave(IProgressMonitor monitor) {
        ModelCacheUtility.doSaveCache(this.document, this.input, monitor);
    }

    public XamlNode getModel(Object textNode) {
        return this.fContext.getModel(textNode);
    }

    public IDOMNode getTextNode(Object model) {
        return this.fContext.getTextNode(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNodeChanged(TextNotification msg) {
        Synchronizer synchronizer = this.synch;
        synchronized (synchronizer) {
            IJobManager jobManager;
            Job currentJob;
            if (!this.synch.isFree()) {
                return;
            }
            INodeNotifier notifier = msg.getNotifier();
            final Object changedFeature = msg.getChangedFeature();
            int eventType = msg.getEventType();
            final Object newValue = msg.getNewValue();
            final XamlNode parentNode = this.fContext.getModel(notifier);
            final XamlNode changedNode = this.fContext.getModel(changedFeature);
            if (eventType == 1 && changedFeature != null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (changedNode != null && newValue == null) {
                            parentNode.getAttributes().remove((Object)changedNode);
                        } else if (parentNode != null && changedFeature instanceof IDOMAttr) {
                            XWTModelBuilder.this.createAttribute(parentNode, (IDOMNode)((IDOMAttr)changedFeature), -1);
                        }
                        XWTModelBuilder.this.synch.setFree();
                    }
                };
                this.synch.setEventType(Synchronizer.EventType.SourceEvent);
                DisplayUtil.asyncExec((Runnable)runnable);
            } else if (eventType == 3 && parentNode != null && changedNode != null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (changedNode instanceof XamlElement) {
                            parentNode.getChildNodes().remove((Object)changedNode);
                        } else if (changedNode instanceof XamlAttribute) {
                            parentNode.getAttributes().remove((Object)changedNode);
                        }
                        XWTModelBuilder.this.synch.setFree();
                    }
                };
                this.synch.setEventType(Synchronizer.EventType.SourceEvent);
                DisplayUtil.asyncExec((Runnable)runnable);
            } else if (!(eventType != 4 || (currentJob = (jobManager = Job.getJobManager()).currentJob()) instanceof ReloadJob || this.reloadJob != null && this.reloadJob.getResult() == null)) {
                this.reloadJob = new ReloadJob();
                this.reloadJob.setRule(new ISchedulingRule(){

                    public boolean contains(ISchedulingRule rule) {
                        return this.getClass() == rule.getClass();
                    }

                    public boolean isConflicting(ISchedulingRule rule) {
                        return this.getClass() == rule.getClass();
                    }
                });
                this.reloadJob.schedule(200L);
            }
        }
    }

    private class NodeAdapter
    implements INodeAdapter {
        private NodeAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == NodeAdapter.class;
        }

        public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
            TextNotification msg = new TextNotification(notifier, eventType, changedFeature, oldValue, newValue, pos);
            XWTModelBuilder.this.handleNodeChanged(msg);
        }
    }

    private class ReloadJob
    extends Job {
        public ReloadJob() {
            super("Reload");
            this.setPriority(20);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            XWTModelBuilder.this.reload();
            return Status.OK_STATUS;
        }
    }
}

