/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.loader;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.e4.xwt.IDataProvider;
import org.eclipse.e4.xwt.IIndexedElement;
import org.eclipse.e4.xwt.ILoadedAction;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.ILogger;
import org.eclipse.e4.xwt.INamespaceHandler;
import org.eclipse.e4.xwt.IStyle;
import org.eclipse.e4.xwt.ResourceDictionary;
import org.eclipse.e4.xwt.Tracking;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTException;
import org.eclipse.e4.xwt.XWTMaps;
import org.eclipse.e4.xwt.annotation.UI;
import org.eclipse.e4.xwt.core.IBinding;
import org.eclipse.e4.xwt.core.IDynamicBinding;
import org.eclipse.e4.xwt.core.IEventHandler;
import org.eclipse.e4.xwt.core.Setter;
import org.eclipse.e4.xwt.core.SetterBase;
import org.eclipse.e4.xwt.core.Style;
import org.eclipse.e4.xwt.core.TriggerBase;
import org.eclipse.e4.xwt.input.ICommand;
import org.eclipse.e4.xwt.internal.core.ScopeKeeper;
import org.eclipse.e4.xwt.internal.utils.LoggerManager;
import org.eclipse.e4.xwt.internal.utils.NamespaceHelper;
import org.eclipse.e4.xwt.internal.utils.ObjectUtil;
import org.eclipse.e4.xwt.internal.utils.TableEditorHelper;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.e4.xwt.javabean.StaticResourceBinding;
import org.eclipse.e4.xwt.javabean.metadata.properties.TableItemProperty;
import org.eclipse.e4.xwt.jface.JFacesHelper;
import org.eclipse.e4.xwt.metadata.IEvent;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.e4.xwt.tools.ui.designer.loader.ClassLoaderUtil;
import org.eclipse.e4.xwt.tools.ui.designer.loader.DataBindingTrack;
import org.eclipse.e4.xwt.tools.ui.designer.loader.NodesSorter;
import org.eclipse.e4.xwt.tools.ui.designer.loader.XWTVisualLoader;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.e4.xwt.utils.PathHelper;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceVisitor {
    public static final String ELEMENT_KEY = "XWTDesigner.Model";
    public static final String UI_FILE_KEY = "XWTDesigner.UIFile";
    static Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    static final String RESOURCE_LOADER_PROPERTY = "XWT.ResourceLoader";
    private static final HashMap<String, Collection<Class<?>>> DELAYED_ATTRIBUTES = new HashMap();
    private static final String COLUMN = "Column";
    protected ResourceVisitor parentLoader;
    protected XWTVisualLoader loader;
    protected Object scopedObject;
    protected ScopeKeeper nameScoped;
    protected LoadingData loadData = new LoadingData();
    private DataBindingTrack dataBindingTrack;

    static {
        ArrayList<Class<TableEditor>> types = new ArrayList<Class<TableEditor>>();
        types.add(Viewer.class);
        DELAYED_ATTRIBUTES.put("input", types);
        types = new ArrayList();
        types.add(Sash.class);
        types.add(SashForm.class);
        DELAYED_ATTRIBUTES.put("weights", types);
        types = new ArrayList();
        types.add(Combo.class);
        types.add(CCombo.class);
        DELAYED_ATTRIBUTES.put("text", types);
        types = new ArrayList();
        types.add(Browser.class);
        DELAYED_ATTRIBUTES.put("url", types);
        types = new ArrayList();
        types.add(TableEditor.class);
        DELAYED_ATTRIBUTES.put("dynamic", types);
    }

    public ResourceVisitor(XWTVisualLoader loader) {
        this.loader = loader;
    }

    public Object createCLRElement(XamlElement element, Map<String, Object> options) {
        try {
            ILoadedAction loadedAction;
            Object styles;
            Object object;
            Composite parent = (Composite)options.get("XWT.Container");
            if (!this.loader.getTrackings().isEmpty()) {
                this.dataBindingTrack = new DataBindingTrack();
            }
            if ((object = options.get(RESOURCE_LOADER_PROPERTY)) instanceof ResourceVisitor) {
                this.parentLoader = (ResourceVisitor)object;
            }
            options.remove(RESOURCE_LOADER_PROPERTY);
            ResourceDictionary resourceDictionary = (ResourceDictionary)options.get("XWT.Resources");
            if (resourceDictionary != null && (styles = resourceDictionary.get((Object)"XWT.DefaultStyles")) != null) {
                this.loadData.setStyles((Collection)styles);
                resourceDictionary.remove((Object)"XWT.DefaultStyles");
            }
            Object control = this.doCreate(parent, element, null, options);
            if (this.dataBindingTrack != null) {
                String dataBindingMessage = this.dataBindingTrack.getDataBindMessage();
                ILogger log = this.loader.getLogger();
                log.addMessage(dataBindingMessage, Tracking.DATABINDING);
                log.printInfo(dataBindingMessage, Tracking.DATABINDING, this.loader.getTrackings());
            }
            if (control instanceof Composite) {
                ((Composite)control).layout();
            }
            if ((loadedAction = (ILoadedAction)options.get("XWT.onLoaded")) != null) {
                loadedAction.onLoaded(control);
            }
            return control;
        }
        catch (Exception e) {
            throw new XWTException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object doCreate(Object parent, XamlElement element, Class<?> constraintType, Map<String, Object> options) throws Exception {
        void var12_22;
        Widget widget;
        int styles = -1;
        if (options.containsKey("XWT.Style")) {
            styles = (Integer)options.get("XWT.Style");
        }
        ResourceDictionary dico = (ResourceDictionary)options.get("XWT.Resources");
        Object dataContext = options.get("XWT.DataContext");
        Object bindingContext = options.get("XWT.BindingContext");
        String name = element.getName();
        String namespace = element.getNamespace();
        if ("http://www.eclipse.org/xwt".equalsIgnoreCase(namespace)) {
            if ("Null".equalsIgnoreCase(name)) {
                return null;
            }
            if (!"Type".equalsIgnoreCase(name) || constraintType == null || constraintType != Class.class) return null;
            XamlNode[] children = (XamlNode[])element.getChildNodes().toArray((Object[])new XamlNode[0]);
            if (children != null && children.length > 0) {
                XamlElement xamlElement;
                IMetaclass metaclass;
                if (!(children[0] instanceof XamlElement) || (metaclass = this.loader.getMetaclass((xamlElement = (XamlElement)children[0]).getName(), xamlElement.getNamespace())) == null) return null;
                return metaclass.getType();
            }
            String string = element.getValue();
            return this.loader.convertFrom(Class.class, string);
        }
        IMetaclass metaclass = this.loader.getMetaclass(name, namespace);
        if (metaclass == null) {
            return null;
        }
        if (!(constraintType == null || IBinding.class.isAssignableFrom(metaclass.getType()) || constraintType.isAssignableFrom(metaclass.getType()) || constraintType.isArray() && constraintType.getComponentType().isAssignableFrom(metaclass.getType()))) {
            return null;
        }
        Object var12_15 = null;
        Integer styleValue = this.getStyleValue(element, styles);
        if (parent == null || metaclass.getType() == Shell.class) {
            if (this.dataBindingTrack != null) {
                this.dataBindingTrack.addWidgetElement(element);
            }
            Shell shell = null;
            if (styleValue == null || styleValue == -1) {
                styleValue = 1264;
            }
            Display display = Display.getDefault();
            Shell shell2 = shell = new Shell(display, styleValue.intValue());
            this.postCreation0(element, shell2);
            this.loadData.setCurrentWidget(shell);
            if (metaclass.getType() != Shell.class) {
                shell.setLayout((Layout)new FillLayout());
                return this.doCreate(shell2, element, constraintType, options);
            }
            if (bindingContext != null) {
                this.setBindingContext(metaclass, shell2, dico, bindingContext);
            }
            if (dataContext != null) {
                this.setDataContext(metaclass, shell2, dico, dataContext);
            }
            this.pushStack(parent);
            XamlAttribute classAttribute = element.getAttribute("Class", "http://www.eclipse.org/xwt");
            if (classAttribute != null) {
                String className = classAttribute.getValue();
                this.loadShellCLR(className, shell);
            }
        } else {
            this.pushStack(parent);
            Class type = metaclass.getType();
            URL file = type.getResource(String.valueOf(type.getSimpleName()) + ".xwt");
            if (file != null && this.nameScoped != null) {
                if (!(parent instanceof Composite)) throw new XWTException("Cannot add user control: Parent is not a composite");
                Object childDataContext = this.getDataContext(element, (Widget)parent);
                Object childBindingContext = this.getBindingContext(element, (Widget)parent);
                if (dataContext != null) {
                    childDataContext = dataContext;
                }
                if (bindingContext != null) {
                    childBindingContext = bindingContext;
                }
                HashMap<String, Object> nestedOptions = new HashMap<String, Object>();
                nestedOptions.put("XWT.Container", parent);
                if (styleValue != null) {
                    nestedOptions.put("XWT.Style", styleValue);
                }
                nestedOptions.put("XWT.DataContext", childDataContext);
                if (childBindingContext != null) {
                    nestedOptions.put("XWT.DataContext", childBindingContext);
                }
                nestedOptions.put(RESOURCE_LOADER_PROPERTY, this);
                Control control = this.loader.loadWithOptions(file, nestedOptions);
                if (control == null) {
                    return null;
                }
                if (control instanceof Widget) {
                    ((Widget)control).setData(UI_FILE_KEY, (Object)file);
                }
            } else {
                void var12_21;
                void var12_19;
                Object parameters = null;
                if (TableViewerColumn.class.isAssignableFrom(type)) {
                    Object[] objectArray;
                    int columnIndex = this.getColumnIndex(element);
                    if (styleValue != null) {
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = parent;
                        objectArray2[1] = styleValue;
                        objectArray = objectArray2;
                        objectArray2[2] = columnIndex;
                    } else {
                        Object[] objectArray3 = new Object[3];
                        objectArray3[0] = parent;
                        objectArray3[1] = 0;
                        objectArray = objectArray3;
                        objectArray3[2] = columnIndex;
                    }
                    parameters = objectArray;
                } else {
                    Object[] objectArray;
                    if (styleValue != null) {
                        Object[] objectArray4 = new Object[2];
                        objectArray4[0] = parent;
                        objectArray = objectArray4;
                        objectArray4[1] = styleValue;
                    } else {
                        Object[] objectArray5 = new Object[1];
                        objectArray = objectArray5;
                        objectArray5[0] = parent;
                    }
                    parameters = objectArray;
                }
                XamlAttribute classAttribute = element.getAttribute("Class", "http://www.eclipse.org/xwt");
                if (classAttribute != null) {
                    String className = classAttribute.getValue();
                    Object object = this.loadCLR(className, (Object[])parameters, metaclass.getType(), options);
                } else {
                    Object clr = options.get("XWT.Class");
                    if (clr != null) {
                        this.loadData.setClr(clr);
                    }
                }
                if (var12_19 == null) {
                    Object clr;
                    Object object = metaclass.newInstance((Object[])parameters);
                    this.postCreation0(element, object);
                    Widget widget2 = UserData.getWidget((Object)object);
                    if (widget2 != null && (clr = this.loadData.getClr()) != null) {
                        UserData.setCLR((Object)widget2, (Object)clr);
                    }
                } else {
                    metaclass = this.loader.getMetaclass(var12_19);
                }
                if (var12_21 == null) {
                    return null;
                }
            }
        }
        if ((widget = UserData.getWidget((Object)var12_22)) != null) {
            this.loadData.setCurrentWidget(var12_22);
        }
        if (this.scopedObject == null && widget != null) {
            this.scopedObject = widget;
            this.nameScoped = new ScopeKeeper(parent == null ? null : UserData.findScopeKeeper((Object)((Widget)parent)), widget);
            UserData.bindNameContext((Object)widget, (ScopeKeeper)this.nameScoped);
        }
        this.setDataContext(metaclass, var12_22, dico, dataContext);
        if (bindingContext != null) {
            this.setBindingContext(metaclass, var12_22, dico, bindingContext);
        }
        this.applyStyles(element, var12_22);
        if (this.dataBindingTrack != null) {
            this.dataBindingTrack.tracking(var12_22, element, dataContext);
        }
        if (var12_22 instanceof Widget) {
            if (parent != null) {
                UserData.setParent((Object)var12_22, (Object)parent);
                ((Widget)var12_22).setData(ELEMENT_KEY, (Object)element);
            }
        } else if (JFacesHelper.isViewer((Object)var12_22)) {
            UserData.setParent((Object)var12_22, (Object)parent);
            UserData.setViewer((Object)var12_22, (Object)var12_22);
            ((Viewer)var12_22).setData(ELEMENT_KEY, (Object)element);
        } else if (var12_22 instanceof TableItemProperty.Cell) {
            ((TableItemProperty.Cell)var12_22).setParent((TableItem)parent);
        }
        for (String key : options.keySet()) {
            if ("XWT.Container".equalsIgnoreCase(key) || "XWT.Style".equalsIgnoreCase(key) || "XWT.DataContext".equalsIgnoreCase(key) || "XWT.BindingContext".equalsIgnoreCase(key) || "XWT.Resources".equalsIgnoreCase(key) || "XWT.Class".equalsIgnoreCase(key) || "XWT.onLoaded".equalsIgnoreCase(key) || "XWT.DesignMode".equalsIgnoreCase(key)) continue;
            IProperty property = metaclass.findProperty(key);
            if (property == null) {
                throw new XWTException("Property " + key + " not found.");
            }
            property.setValue((Object)var12_22, options.get(key));
        }
        ArrayList<String> delayedAttributes = new ArrayList<String>();
        this.init(metaclass, var12_22, (XamlNode)element, delayedAttributes);
        if (var12_22 instanceof Style && element.getChildNodes().size() > 0) {
            ArrayList<Setter> setters = new ArrayList<Setter>();
            for (XamlNode doc : element.getChildNodes()) {
                Object child = this.doCreate(var12_22, (XamlElement)doc, null, Collections.EMPTY_MAP);
                if (!(child instanceof Setter)) {
                    throw new XWTException("Setter is expected in Style.");
                }
                setters.add((Setter)child);
            }
            ((Style)var12_22).setSetters((SetterBase[])setters.toArray(new Setter[setters.size()]));
        } else if (var12_22 instanceof ControlEditor) {
            for (XamlNode doc : element.getChildNodes()) {
                Object editor = this.doCreate(parent, (XamlElement)doc, null, Collections.EMPTY_MAP);
                if (editor == null || !(editor instanceof Control)) continue;
                ((ControlEditor)var12_22).setEditor((Control)editor);
                ((Control)editor).setData("TableEditor of a control", (Object)var12_22);
            }
        } else if (var12_22 instanceof IDataProvider) {
            for (XamlNode doc : element.getChildNodes()) {
                String content;
                if (!"http://www.eclipse.org/xwt".equals(doc.getNamespace()) || (content = doc.getValue()) == null) continue;
                ((IDataProvider)var12_22).setProperty(doc.getName(), (Object)content);
            }
        } else {
            for (XamlNode doc : element.getChildNodes()) {
                this.doCreate(var12_22, (XamlElement)doc, null, Collections.EMPTY_MAP);
            }
        }
        for (String delayed : delayedAttributes) {
            this.initAttribute(metaclass, var12_22, (XamlNode)element, null, delayed);
        }
        this.postCreation(var12_22);
        this.popStack();
        return var12_22;
    }

    protected void postCreation0(XamlElement element, Object targetObject) {
    }

    protected void postCreation(Object target) {
        TriggerBase triggerBase;
        TriggerBase[] triggers;
        Widget widget = UserData.getWidget((Object)target);
        if (widget == null) {
            return;
        }
        TriggerBase[] triggerBaseArray = triggers = UserData.getTriggers((Object)widget);
        int n = triggers.length;
        int n2 = 0;
        while (n2 < n) {
            triggerBase = triggerBaseArray[n2];
            if (triggerBase != null) {
                triggerBase.prepare(target);
            }
            ++n2;
        }
        triggerBaseArray = triggers;
        n = triggers.length;
        n2 = 0;
        while (n2 < n) {
            triggerBase = triggerBaseArray[n2];
            if (triggerBase != null) {
                triggerBase.on(target);
            }
            ++n2;
        }
    }

    protected void setDataContext(IMetaclass metaclass, Object targetObject, ResourceDictionary dico, Object dataContext) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Object control = null;
        IMetaclass widgetMetaclass = metaclass;
        if (JFacesHelper.isViewer((Object)targetObject)) {
            Control widget = JFacesHelper.getControl((Object)targetObject);
            widgetMetaclass = this.loader.getMetaclass(widget.getClass());
            control = targetObject;
        } else {
            control = targetObject instanceof Widget ? targetObject : this.loadData.getCurrentWidget();
        }
        if (control != null) {
            if (targetObject instanceof IDynamicBinding) {
                IDynamicBinding dynamicBinding = (IDynamicBinding)targetObject;
                dynamicBinding.setControl(control);
                dynamicBinding.setHost(this.loadData.getHost());
            }
            if (dico != null) {
                UserData.setResources((Object)control, (Map)dico);
            }
            if (dataContext != null) {
                IProperty property = widgetMetaclass.findProperty("DataContext");
                if (property != null) {
                    property.setValue((Object)UserData.getWidget((Object)control), dataContext);
                } else {
                    throw new XWTException("DataContext is missing in " + widgetMetaclass.getType().getName());
                }
            }
        }
    }

    protected void setBindingContext(IMetaclass metaclass, Object targetObject, ResourceDictionary dico, Object bindingContext) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Object control = null;
        IMetaclass widgetMetaclass = metaclass;
        if (JFacesHelper.isViewer((Object)targetObject)) {
            Control widget = JFacesHelper.getControl((Object)targetObject);
            widgetMetaclass = this.loader.getMetaclass(widget.getClass());
            control = targetObject;
        } else {
            control = targetObject instanceof Widget ? targetObject : this.loadData.getCurrentWidget();
        }
        if (control != null) {
            if (targetObject instanceof IDynamicBinding) {
                IDynamicBinding dynamicBinding = (IDynamicBinding)targetObject;
                dynamicBinding.setControl(control);
                dynamicBinding.setHost(this.loadData.getHost());
            }
            if (dico != null) {
                UserData.setResources((Object)control, (Map)dico);
            }
            if (bindingContext != null) {
                IProperty property = widgetMetaclass.findProperty("BindingContext");
                if (property != null) {
                    property.setValue((Object)UserData.getWidget((Object)control), bindingContext);
                } else {
                    throw new XWTException("BindingContext is missing in " + widgetMetaclass.getType().getName());
                }
            }
        }
    }

    protected void applyStyles(XamlElement element, Object targetObject) throws Exception {
        if (targetObject instanceof Widget) {
            Widget widget = (Widget)targetObject;
            Map dico = UserData.getLocalResources((Object)widget);
            XamlAttribute attribute = element.getAttribute("Resources");
            if (attribute == null) {
                attribute = element.getAttribute("Resources", "http://www.eclipse.org/xwt/presentation");
            }
            if (attribute != null && attribute.getChildNodes().size() > 0) {
                if (dico == null) {
                    dico = new ResourceDictionary();
                    UserData.setResources((Object)widget, (Map)dico);
                }
                for (XamlNode doc : attribute.getChildNodes()) {
                    XamlElement elem = (XamlElement)doc;
                    Object doCreate = this.doCreate(widget, elem, null, EMPTY_MAP);
                    XamlAttribute keyAttribute = elem.getAttribute("Key", "http://www.eclipse.org/xwt");
                    if (keyAttribute == null) {
                        keyAttribute = elem.getAttribute("Type", "http://www.eclipse.org/xwt");
                    }
                    if (keyAttribute != null) {
                        dico.put(keyAttribute.getValue(), doCreate);
                    }
                    if (!(doCreate instanceof IStyle)) continue;
                    IStyle style = (IStyle)doCreate;
                    this.loadData.addStyle(style);
                }
            }
            Widget current = widget;
            while (current != null) {
                dico = UserData.getLocalResources((Object)current);
                if (dico != null) {
                    for (Object value : dico.values()) {
                        Style style;
                        Class targetType;
                        if (!(value instanceof Style) || (targetType = (style = (Style)value).getTargetType()) == null || !targetType.isInstance(widget)) continue;
                        style.apply(targetObject);
                    }
                }
                current = UserData.getParent((Object)current);
            }
        }
        for (IStyle style : this.loadData.getStyles()) {
            style.applyStyle(targetObject);
        }
    }

    protected int getColumnIndex(XamlElement columnElement) {
        String name = columnElement.getName();
        String namespace = columnElement.getNamespace();
        IMetaclass metaclass = this.loader.getMetaclass(name, namespace);
        int index = -1;
        Class type = metaclass.getType();
        if (TableViewerColumn.class.isAssignableFrom(type)) {
            XamlNode parent = (XamlNode)columnElement.eContainer();
            List<XamlNode> children = NodesSorter.sortWithAttr((XamlNode[])parent.getChildNodes().toArray((Object[])new XamlNode[0]), "Index");
            index = children.indexOf(columnElement);
        }
        return index;
    }

    protected void installTableEditors(TableItem tableItem) {
        Table table = tableItem.getParent();
        TableColumn[] columns = table.getColumns();
        if (columns == null || columns.length == 0) {
            return;
        }
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            Object data = tableColumn.getData("Defined table editors");
            if (data != null && data instanceof XamlElement) {
                int column = table.indexOf(tableColumn);
                XamlElement editor = (XamlElement)data;
                try {
                    TableEditor tableEditor = (TableEditor)this.doCreate(table, editor, null, EMPTY_MAP);
                    if (tableEditor != null) {
                        tableEditor.setColumn(column);
                        tableEditor.setItem(tableItem);
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    protected Object getDataContext(XamlElement element, Widget swtObject) {
        try {
            XamlAttribute dataContextAttribute = element.getAttribute("DataContext", "http://www.eclipse.org/xwt/presentation");
            if (dataContextAttribute != null) {
                Widget composite = swtObject;
                XamlNode documentObject = (XamlNode)dataContextAttribute.getChildNodes().get(0);
                if ("StaticResource".equals(documentObject.getName()) || "DynamicResource".equals(documentObject.getName())) {
                    String key = documentObject.getValue();
                    return new StaticResourceBinding((Object)composite, key);
                }
                if ("Binding".equals(documentObject.getName())) {
                    return this.doCreate(swtObject, (XamlElement)documentObject, null, EMPTY_MAP);
                }
                LoggerManager.log((Throwable)new UnsupportedOperationException(documentObject.getName()));
            }
        }
        catch (Exception e) {
            LoggerManager.log((Throwable)e);
        }
        return null;
    }

    protected Object getBindingContext(XamlElement element, Widget swtObject) {
        try {
            XamlAttribute dataContextAttribute = element.getAttribute("BindingContext", "http://www.eclipse.org/xwt/presentation");
            if (dataContextAttribute != null) {
                Widget composite = swtObject;
                XamlNode documentObject = (XamlNode)dataContextAttribute.getChildNodes().get(0);
                if ("StaticResource".equals(documentObject.getName()) || "DynamicResource".equals(documentObject.getName())) {
                    String key = documentObject.getValue();
                    return new StaticResourceBinding((Object)composite, key);
                }
                if ("Binding".equals(documentObject.getName())) {
                    return this.doCreate(swtObject, (XamlElement)documentObject, null, EMPTY_MAP);
                }
                LoggerManager.log((Throwable)new UnsupportedOperationException(documentObject.getName()));
            }
        }
        catch (Exception e) {
            LoggerManager.log((Throwable)e);
        }
        return null;
    }

    protected void pushStack(Object host) {
        this.loadData = new LoadingData(this.loadData, host);
    }

    protected void popStack() {
        LoadingData previous = this.loadData;
        this.loadData = previous.getParent();
        previous.end();
    }

    protected Integer getStyleValue(XamlElement element, int styles) {
        XamlAttribute attribute = element.getAttribute("Style", "http://www.eclipse.org/xwt");
        if (attribute == null) {
            if (styles != -1) {
                return styles;
            }
            return null;
        }
        if (styles == -1) {
            return (Integer)this.loader.findConvertor(String.class, Integer.class).convert((Object)attribute.getValue());
        }
        return styles | (Integer)this.loader.findConvertor(String.class, Integer.class).convert((Object)attribute.getValue());
    }

    protected void init(IMetaclass metaclass, Object targetObject, XamlNode element, List<String> delayedAttributes) throws Exception {
        XamlAttribute dataContextAttribute;
        if (targetObject instanceof TableItem) {
            this.installTableEditors((TableItem)targetObject);
        }
        if ((dataContextAttribute = element.getAttribute("DataContext")) != null) {
            IProperty property = metaclass.findProperty("DataContext");
            Widget composite = (Widget)targetObject;
            XamlNode documentObject = (XamlNode)dataContextAttribute.getChildNodes().get(0);
            if ("StaticResource".equals(documentObject.getName()) || "DynamicResource".equals(documentObject.getName())) {
                String key = documentObject.getValue();
                property.setValue((Object)composite, (Object)new StaticResourceBinding((Object)composite, key));
            } else if ("Binding".equals(documentObject.getName())) {
                Object object = this.doCreate(targetObject, (XamlElement)documentObject, null, EMPTY_MAP);
                property.setValue((Object)composite, object);
            } else {
                LoggerManager.log((Throwable)new UnsupportedOperationException(documentObject.getName()));
            }
        }
        HashSet<String> done = new HashSet<String>();
        XamlAttribute nameAttr = element.getAttribute("Name");
        if (nameAttr == null) {
            nameAttr = element.getAttribute("Name", "http://www.eclipse.org/xwt");
        }
        if (nameAttr != null && UserData.getWidget((Object)targetObject) != null) {
            String value = nameAttr.getValue();
            this.loadData.inject(targetObject, value);
            this.nameScoped.addNamedObject(value, targetObject);
            done.add("Name");
        }
        for (XamlAttribute attr : element.getAttributes()) {
            String namespace = attr.getNamespace();
            String attrName = attr.getName();
            if (!XWT.isXWTNamespace((String)namespace)) {
                INamespaceHandler namespaceHandler = this.loader.getNamespaceHandler(namespace);
                if (namespaceHandler == null) continue;
                Widget widget = UserData.getWidget((Object)this.loadData.getCurrentWidget());
                namespaceHandler.handleAttribute(widget, targetObject, attrName, attr.getValue());
                continue;
            }
            if ("http://www.eclipse.org/xwt".equals(namespace)) {
                if ("class".equalsIgnoreCase(attrName) || "Style".equalsIgnoreCase(attrName)) continue;
                if ("Name".equalsIgnoreCase(attrName)) {
                    this.nameScoped.addNamedObject(element.getAttribute(attrName, namespace).getValue(), targetObject);
                    done.add(attrName);
                    continue;
                }
                if ("DataContext".equalsIgnoreCase(attrName)) continue;
                if ("Array".equalsIgnoreCase(attrName)) {
                    IProperty property = metaclass.findProperty(attrName);
                    Class type = property.getType();
                    Object value = this.getArrayProperty(type, targetObject, element, attrName);
                    if (value == null) continue;
                    property.setValue(targetObject, value);
                    continue;
                }
                if ("Resources".equalsIgnoreCase(attrName) || done.contains(attrName)) continue;
                this.initAttribute(metaclass, targetObject, element, namespace, attrName);
                done.add(attrName);
                continue;
            }
            if (delayedAttributes != null && ResourceVisitor.isDelayedProperty(attrName.toLowerCase(), metaclass.getType())) {
                delayedAttributes.add(attrName);
                continue;
            }
            if (done.contains(attrName)) continue;
            this.initAttribute(metaclass, targetObject, element, namespace, attrName);
            done.add(attrName);
        }
    }

    protected Object getArrayProperty(Class<?> type, Object swtObject, XamlNode element, String attrName) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        if (!type.isArray()) {
            throw new XWTException("Type mismatch: property " + attrName + " isn't an array.");
        }
        Class<?> arrayType = type.getComponentType();
        if (arrayType != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (XamlElement childModel : element.getChildNodes()) {
                Object child = this.createInstance(swtObject, childModel);
                list.add(child);
            }
            Object[] array = (Object[])Array.newInstance(arrayType, list.size());
            list.toArray(array);
            int i = 0;
            while (i < array.length) {
                if (array[i] instanceof IIndexedElement) {
                    ((IIndexedElement)array[i]).setIndex(swtObject, i);
                }
                ++i;
            }
            return array;
        }
        return null;
    }

    protected Object getCollectionProperty(Class<?> type, Object swtObject, XamlNode element, String attrName) throws IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Collection<Object> collector = null;
        if (type.isInterface()) {
            collector = new ArrayList();
        } else {
            if (Modifier.isAbstract(type.getModifiers())) {
                LoggerManager.log((Throwable)new XWTException("Collection " + type.getSimpleName() + " is abstract type"));
            }
            try {
                collector = (Collection)type.newInstance();
            }
            catch (InstantiationException e) {
                LoggerManager.log((Throwable)new XWTException((Throwable)e));
            }
        }
        for (XamlElement childModel : element.getChildNodes()) {
            Object child = this.createInstance(swtObject, childModel);
            collector.add(child);
            if (!(child instanceof IIndexedElement)) continue;
            ((IIndexedElement)child).setIndex(swtObject, collector.size() - 1);
        }
        return collector;
    }

    protected String findNamespace(XamlNode context, String prefix) {
        String namespace;
        while (context != null && !(context instanceof XamlElement)) {
            context = (XamlNode)context.eContainer();
        }
        if (context == null) {
            return null;
        }
        XamlElement element = (XamlElement)context;
        if (prefix != null) {
            String string = prefix = prefix.length() == 0 ? null : prefix;
        }
        if ((namespace = element.getNamespace()) != null) {
            return namespace;
        }
        XamlNode parent = (XamlNode)element.eContainer();
        return this.findNamespace(parent, prefix);
    }

    protected Object createInstance(Object swtObject, XamlElement element) {
        String name = element.getName();
        String namespace = element.getNamespace();
        if ("http://www.eclipse.org/xwt".equalsIgnoreCase(namespace) && "Null".equalsIgnoreCase(name)) {
            return null;
        }
        try {
            Class type = NamespaceHelper.loadCLRClass((ILoadingContext)this.loader.getLoadingContext(), (String)name, (String)namespace);
            IMetaclass metaclass = this.loader.getMetaclass(name, namespace);
            if (type == null && metaclass != null) {
                type = metaclass.getType();
            }
            String content = element.getValue();
            Object instance = null;
            if (content == null) {
                instance = metaclass.newInstance(new Object[]{swtObject});
                if (instance instanceof TableEditor) {
                    TableEditor tableEditor = (TableEditor)instance;
                    if (swtObject instanceof TableItem) {
                        TableItem item = (TableItem)swtObject;
                        tableEditor.setItem(item);
                        for (XamlNode doc : element.getChildNodes()) {
                            Control control = (Control)this.doCreate(((TableItem)swtObject).getParent(), (XamlElement)doc, null, EMPTY_MAP);
                            tableEditor.setEditor(control);
                            int column = ResourceVisitor.getColumnValue(element);
                            TableEditorHelper.initEditor((TableItem)item, (Control)control, (int)column);
                        }
                    }
                }
            } else {
                Constructor constructor = type.getConstructor(type);
                if (constructor != null) {
                    instance = constructor.newInstance(this.loader.convertFrom(type, content));
                } else {
                    LoggerManager.log((Throwable)new XWTException("Constructor \"" + name + "(" + type.getSimpleName() + ")\" is not found"));
                }
            }
            ArrayList<String> delayedAttributes = new ArrayList<String>();
            this.init(metaclass, instance, (XamlNode)element, delayedAttributes);
            for (String delayed : delayedAttributes) {
                this.initAttribute(metaclass, instance, (XamlNode)element, null, delayed);
            }
            for (XamlElement doc : element.getChildNodes()) {
                this.doCreate(instance, doc, null, Collections.EMPTY_MAP);
            }
            return instance;
        }
        catch (Exception e) {
            LoggerManager.log((Throwable)e);
            return null;
        }
    }

    protected static int getColumnValue(XamlElement context) {
        String content;
        XamlAttribute attribute = context.getAttribute(COLUMN);
        if (attribute != null && (content = attribute.getValue()) != null) {
            return Integer.parseInt(content);
        }
        return 0;
    }

    protected void loadShellCLR(String className, Shell shell) {
        Class type = ClassLoaderUtil.loadClass((ILoadingContext)this.loader.getLoadingContext(), (String)className);
        if (type == null) {
            return;
        }
        try {
            Object instance = type.newInstance();
            this.loadData.setClr(instance);
            UserData.setCLR((Object)shell, instance);
        }
        catch (Exception e) {
            LoggerManager.log((Throwable)e);
        }
    }

    protected Object loadCLR(String className, Object[] parameters, Class<?> currentTagType, Map<String, Object> options) {
        Class type = ClassLoaderUtil.loadClass((ILoadingContext)this.loader.getLoadingContext(), (String)className);
        if (type == null) {
            return null;
        }
        try {
            Object clr = options.get("XWT.Class");
            if (clr != null && type != null && type.isInstance(clr)) {
                this.loadData.setClr(clr);
                if (clr instanceof Widget) {
                    UserData.setCLR((Object)((Widget)clr), (Object)clr);
                }
            } else {
                if (currentTagType != null && currentTagType.isAssignableFrom(type)) {
                    IMetaclass metaclass = this.loader.getMetaclass(type);
                    Object instance = metaclass.newInstance(parameters);
                    this.loadData.setClr(instance);
                    if (instance instanceof Widget) {
                        UserData.setCLR((Object)((Widget)instance), (Object)instance);
                    }
                    return instance;
                }
                Object instance = type.newInstance();
                this.loadData.setClr(instance);
                if (instance instanceof Widget) {
                    UserData.setCLR((Object)((Widget)instance), instance);
                }
            }
        }
        catch (Exception e) {
            LoggerManager.log((Throwable)e);
        }
        return null;
    }

    public void initAttribute(IMetaclass metaclass, Object targetObject, XamlNode element, String namespace, String attrName) throws Exception {
        if (attrName.indexOf(46) != -1) {
            String[] segments = attrName.split("\\.");
            IMetaclass currentMetaclass = metaclass;
            Object target = targetObject;
            int i = 0;
            while (i < segments.length - 1) {
                IProperty property = currentMetaclass.findProperty(segments[i]);
                if (property != null) {
                    if ((target = property.getValue(target)) == null) {
                        LoggerManager.log((Throwable)new XWTException("Property \"" + segments[i] + "\" is null."));
                    }
                    currentMetaclass = this.loader.getMetaclass(target);
                } else {
                    LoggerManager.log((Throwable)new XWTException("Property \"" + segments[i] + "\" not found."));
                }
                ++i;
            }
            this.initSegmentAttribute(currentMetaclass, segments[segments.length - 1], target, element, namespace, attrName);
            return;
        }
        this.initSegmentAttribute(metaclass, attrName, targetObject, element, namespace, attrName);
    }

    protected void addCommandExecuteListener(String commandName, final Widget targetButton) {
        final ICommand commandObj = this.loader.getCommand(commandName);
        if (commandObj != null) {
            targetButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    commandObj.execute((Object)targetButton);
                }
            });
        }
    }

    protected void initSegmentAttribute(IMetaclass metaclass, String propertyName, Object target, XamlNode element, String namespace, String attrName) throws Exception {
        XamlAttribute attribute = element.getAttribute(attrName, namespace);
        if (attribute == null) {
            attribute = element.getAttribute(attrName);
        }
        IProperty property = null;
        boolean isAttached = false;
        String groupName = attribute.getGroupName();
        if (groupName == null) {
            property = metaclass.findProperty(propertyName);
        } else {
            IMetaclass metaclassAttached;
            if (groupName.length() > 1) {
                groupName = String.valueOf(Character.toUpperCase(groupName.charAt(0))) + groupName.substring(1);
            }
            if ((metaclassAttached = this.loader.getMetaclass(groupName, attribute.getNamespace())) != null) {
                property = metaclassAttached.findProperty(propertyName);
                isAttached = true;
            } else {
                LoggerManager.log((String)(String.valueOf(attribute.getNamespace()) + " -> " + groupName + " is not found."));
                return;
            }
        }
        if (propertyName.equals("DataContext")) {
            property = null;
        }
        if ("Command".equalsIgnoreCase(propertyName) && ICommand.class.isAssignableFrom(property.getType()) && target instanceof Widget) {
            this.addCommandExecuteListener(attribute.getValue(), (Widget)target);
        }
        if (property == null) {
            IEvent event = metaclass.findEvent(attrName);
            if (event == null) {
                return;
            }
            if (!(target instanceof Widget)) {
                return;
            }
            this.loadData.updateEvent((Widget)target, event, attribute.getValue());
            return;
        }
        try {
            XamlAttribute attributeAccelerator;
            String contentValue = attribute.getValue();
            if ("MenuItem".equalsIgnoreCase(element.getName()) && "Text".equalsIgnoreCase(attrName) && (attributeAccelerator = element.getAttribute("Accelerator")) != null) {
                contentValue = String.valueOf(contentValue) + '\t' + this.getContentValue(attributeAccelerator.getValue());
            }
            if (contentValue != null && "Accelerator".equalsIgnoreCase(attrName) && (contentValue = XWTMaps.getCombAccelerator((String)contentValue)).contains("'")) {
                contentValue = this.removeSubString(contentValue, "'");
            }
            if (contentValue != null && Image.class.isAssignableFrom(property.getType())) {
                contentValue = this.getImagePath(attribute, contentValue);
            }
            if (contentValue != null && URL.class.isAssignableFrom(property.getType())) {
                contentValue = this.getSourceURL(contentValue);
            }
            Object value = null;
            XamlNode[] children = (XamlNode[])attribute.getChildNodes().toArray((Object[])new XamlNode[0]);
            boolean usingExistingValue = false;
            if (contentValue == null) {
                Class type = property.getType();
                if (Collection.class.isAssignableFrom(type)) {
                    value = this.getCollectionProperty(type, target, (XamlNode)attribute, attrName);
                } else {
                    Object directTarget = null;
                    if (TableViewerColumn.class.isAssignableFrom(type) && attrName.equalsIgnoreCase("columns")) {
                        children = NodesSorter.sortWithAttr(children, "Index").toArray(new XamlNode[children.length]);
                    } else {
                        try {
                            Object propertyValue = property.getValue(target);
                            if (UserData.getWidget((Object)propertyValue) != null) {
                                directTarget = propertyValue;
                                if (type != Table.class) {
                                    type = null;
                                    usingExistingValue = true;
                                }
                            }
                        }
                        catch (Exception exception) {}
                    }
                    if (directTarget == null) {
                        directTarget = target;
                    }
                    XamlNode[] xamlNodeArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        XamlNode child = xamlNodeArray[n2];
                        String name = child.getName();
                        String ns = child.getNamespace();
                        if ("Static".equalsIgnoreCase(name) && "http://www.eclipse.org/xwt".equals(ns)) {
                            value = this.getStaticValue(child);
                        } else if ("StaticResource".equalsIgnoreCase(name) && "http://www.eclipse.org/xwt/presentation".equals(ns)) {
                            String key = child.getValue();
                            value = new StaticResourceBinding(this.loadData.getCurrentWidget(), key);
                        } else if ("http://www.eclipse.org/xwt".equals(ns) && "Array".equalsIgnoreCase(name)) {
                            value = this.getArrayProperty(property.getType(), directTarget, child, name);
                        } else {
                            if (property.getType().isArray()) {
                                value = this.getArrayProperty(property.getType(), directTarget, (XamlNode)attribute, name);
                                break;
                            }
                            if (this.isAssignableFrom(element, TableColumn.class) && this.isAssignableFrom(child, TableEditor.class)) {
                                value = child;
                            } else if (TableViewerColumn.class.isAssignableFrom(property.getType()) && attribute.getValue() != null) {
                                value = attribute.getValue();
                            } else {
                                value = this.doCreate(directTarget, (XamlElement)child, type, EMPTY_MAP);
                                if (!(value != null || type == null || type == Table.class && "TableColumn".equals(child.getName()) && Table.class.isInstance(directTarget))) {
                                    throw new XWTException(String.valueOf(child.getName()) + " cannot be a content of " + type.getName() + " " + target.getClass().getName() + "." + property.getName());
                                }
                                if (value instanceof IDynamicBinding) {
                                    ((IDynamicBinding)value).setType(attrName);
                                }
                            }
                        }
                        ++n2;
                    }
                }
            }
            if (contentValue != null && value == null && !"Command".equalsIgnoreCase(propertyName)) {
                int index;
                if (property.getType().isInstance(Class.class) && (index = contentValue.lastIndexOf(58)) != -1) {
                    String prefix = contentValue.substring(0, index);
                    contentValue = String.valueOf(this.findNamespace((XamlNode)attribute, prefix)) + contentValue.substring(index);
                }
                value = this.loader.convertFrom(property.getType(), contentValue);
            }
            if (!usingExistingValue) {
                if (value != null) {
                    Class propertyType = property.getType();
                    if (!propertyType.isAssignableFrom(value.getClass()) || value instanceof IBinding) {
                        Object orginalValue = value;
                        IConverter converter = this.loader.findConvertor(value.getClass(), propertyType);
                        if (converter != null) {
                            if ((value = converter.convert(value)) != null && orginalValue instanceof IBinding && !propertyType.isAssignableFrom(value.getClass())) {
                                converter = this.loader.findConvertor(value.getClass(), propertyType);
                                if (converter != null) {
                                    value = converter.convert(value);
                                } else {
                                    LoggerManager.log((Throwable)new XWTException("Convertor " + value.getClass().getSimpleName() + "->" + propertyType.getSimpleName() + " is not found"));
                                }
                            }
                        } else {
                            LoggerManager.log((Throwable)new XWTException("Convertor " + value.getClass().getSimpleName() + "->" + propertyType.getSimpleName() + " is not found"));
                        }
                    }
                    if (isAttached) {
                        UserData.setLocalData((Object)target, (IProperty)property, (Object)value);
                    } else {
                        property.setValue(target, value);
                    }
                } else {
                    if (value == null) {
                        value = property.getValue(target);
                    }
                    if (value != null) {
                        XamlNode[] xamlNodeArray = children;
                        int converter = children.length;
                        int orginalValue = 0;
                        while (orginalValue < converter) {
                            Class type;
                            XamlNode child = xamlNodeArray[orginalValue];
                            String name = child.getName();
                            String ns = child.getNamespace();
                            if (!("http://www.eclipse.org/xwt".equals(ns) && "Array".equalsIgnoreCase(name) || Collection.class.isAssignableFrom(type = property.getType()))) {
                                this.doCreate(value, (XamlElement)child, null, EMPTY_MAP);
                            }
                            ++orginalValue;
                        }
                    }
                }
            }
            if (attribute.attributeNames("http://www.eclipse.org/xwt/presentation").size() > 0) {
                IMetaclass propertyMetaclass = this.loader.getMetaclass(property.getType());
                if (value == null) {
                    value = property.getValue(target);
                }
                if (value != null) {
                    ArrayList<String> delayedAttributes = new ArrayList<String>();
                    this.init(propertyMetaclass, value, (XamlNode)attribute, delayedAttributes);
                    for (String delayed : delayedAttributes) {
                        this.initAttribute(metaclass, target, element, null, delayed);
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                RuntimeException exception = (RuntimeException)e;
                throw exception;
            }
            throw new XWTException((Throwable)e);
        }
    }

    protected String getSourceURL(String contentValue) {
        URL url = null;
        try {
            url = new URL(contentValue);
        }
        catch (MalformedURLException malformedURLException) {
            if (!contentValue.startsWith("/")) {
                contentValue = "/" + contentValue;
            }
            ILoadingContext loadingContext = this.loader.getLoadingContext();
            URL resource = loadingContext.getResource(contentValue);
            return resource.toString();
        }
        if (url != null) {
            return url.toString();
        }
        return contentValue;
    }

    protected Class<?> getJavaType(XamlNode element) {
        if (!(element instanceof XamlElement)) {
            return null;
        }
        String name = element.getName();
        String namespace = element.getNamespace();
        if ("http://www.eclipse.org/xwt".equalsIgnoreCase(namespace) && "Null".equalsIgnoreCase(name)) {
            return null;
        }
        IMetaclass metaclass = this.loader.getMetaclass(name, namespace);
        if (metaclass == null) {
            return null;
        }
        return metaclass.getType();
    }

    protected boolean isAssignableFrom(XamlNode element, Class<?> type) {
        Class<?> targetType = this.getJavaType(element);
        if (targetType == null) {
            return false;
        }
        return targetType.isAssignableFrom(type);
    }

    protected Object getStaticValue(XamlNode child) {
        XamlElement element;
        XamlNode[] children = (XamlNode[])child.getChildNodes().toArray((Object[])new XamlNode[0]);
        if (children.length == 1 && (element = (XamlElement)children[0]) != null) {
            return ClassLoaderUtil.loadStaticMember(this.loader.getLoadingContext(), (XamlNode)element);
        }
        return null;
    }

    protected String getImagePath(XamlAttribute attribute, String contentValue) {
        try {
            ILoadingContext loadingContext;
            URL resource;
            File file = new File(contentValue);
            if (file.exists()) {
                return file.toURI().toURL().toString();
            }
            if (!contentValue.startsWith("/")) {
                contentValue = "/" + contentValue;
            }
            if ((resource = (loadingContext = this.loader.getLoadingContext()).getResource(contentValue)) == null) {
                URL resourcePath = this.loader.getResourcePath();
                String fPath = resourcePath.getFile();
                String absolutePath = PathHelper.getAbsolutePath((String)fPath, (String)contentValue);
                file = new File(absolutePath);
                if (file.exists()) {
                    return file.toURI().toURL().toString();
                }
                resource = new URL(absolutePath);
            }
            return resource.toString();
        }
        catch (MalformedURLException malformedURLException) {
            return contentValue;
        }
    }

    protected String removeSubString(String str, String subString) {
        int i;
        StringBuffer stringBuffer = new StringBuffer();
        int lenOfsource = str.length();
        int posStart = 0;
        while ((i = str.indexOf(subString, posStart)) >= 0) {
            stringBuffer.append(str.substring(posStart, i));
            posStart = i + subString.length();
        }
        if (posStart < lenOfsource) {
            stringBuffer.append(str.substring(posStart));
        }
        return stringBuffer.toString();
    }

    protected String getContentValue(String text) {
        StringBuffer stringBuffer = new StringBuffer();
        String subString = "SWT.";
        String str = XWTMaps.getCombAccelerator((String)text);
        if (str.contains(subString)) {
            str = this.removeSubString(str, subString);
        }
        if (str.contains("'")) {
            str = this.removeSubString(str, "'");
        }
        if (str.contains(" ")) {
            str = this.removeSubString(str, " ");
        }
        if (str.contains("|")) {
            str = str.replace('|', '+');
        }
        stringBuffer.append(str);
        return stringBuffer.toString();
    }

    protected static boolean isDelayedProperty(String attr, Class<?> type) {
        Collection<Class<?>> types = DELAYED_ATTRIBUTES.get(attr);
        if (types == null) {
            return false;
        }
        if (types.contains(type)) {
            return true;
        }
        for (Class<?> class1 : types) {
            if (!class1.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoadingData {
        protected LoadingData parent;
        protected Object clr;
        protected Collection<IStyle> styles = Collections.emptyList();
        private Object loadedObject = null;
        private Method loadedMethod = null;
        private Widget hostCLRWidget = null;
        private Object currentWidget = null;
        private Object host = null;

        public Object getHost() {
            return this.host;
        }

        public Object getCurrentWidget() {
            return this.currentWidget;
        }

        public void setCurrentWidget(Object currentWidget) {
            this.currentWidget = currentWidget;
        }

        public LoadingData getParent() {
            return this.parent;
        }

        public LoadingData() {
        }

        public LoadingData(LoadingData loadingData, Object host) {
            this.loadedObject = loadingData.loadedObject;
            this.loadedMethod = loadingData.loadedMethod;
            this.hostCLRWidget = loadingData.hostCLRWidget;
            this.parent = loadingData;
            this.styles = loadingData.styles;
            this.clr = loadingData.clr;
            this.currentWidget = loadingData.currentWidget;
            this.host = host;
        }

        public void inject(Object targetObject, String name) {
            this.doInject(targetObject, name, null);
        }

        protected void doInject(Object targetObject, String name, Object previousClr) {
            Class<?> filedType = targetObject.getClass();
            if (this.clr != null && (previousClr != this.clr || previousClr == null)) {
                Field[] fieldArray = this.clr.getClass().getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    UI annotation = field.getAnnotation(UI.class);
                    if (annotation != null && field.getType().isAssignableFrom(filedType)) {
                        String annotationValue = annotation.value();
                        if (annotationValue == null || annotationValue.length() == 0) {
                            if (field.getName().equals(name)) {
                                field.setAccessible(true);
                                try {
                                    field.set(this.clr, targetObject);
                                    return;
                                }
                                catch (Exception exception) {}
                            }
                        } else if (annotationValue.equals(name)) {
                            field.setAccessible(true);
                            try {
                                field.set(this.clr, targetObject);
                                break;
                            }
                            catch (Exception exception) {}
                        }
                    }
                    ++n2;
                }
            }
            if (this.parent != null) {
                this.parent.doInject(targetObject, name, this.clr);
            }
        }

        public Collection<IStyle> getStyles() {
            return this.styles;
        }

        public void setStyles(Collection<IStyle> styles) {
            this.styles = styles;
        }

        public Object getClr() {
            return this.clr;
        }

        public void setClr(Object clr) {
            this.clr = clr;
        }

        public void updateEvent(Widget control, IEvent event, String handler) {
            IEventHandler eventController = UserData.updateEventController((Object)control);
            Method method = null;
            Object clrObject = null;
            LoadingData current = this;
            ResourceVisitor currentParentLoader = ResourceVisitor.this.parentLoader;
            while (current != null) {
                Object receiver = current.getClr();
                if (receiver != null) {
                    Class clazz = receiver.getClass();
                    method = ObjectUtil.findMethod(clazz, (String)handler, (Class[])new Class[]{Object.class, Event.class});
                    if (method == null) {
                        method = ObjectUtil.findMethod(clazz, (String)handler, (Class[])new Class[]{Event.class});
                    }
                    if (method == null && (method = ObjectUtil.findMethod((Class)(clazz = ClassLoaderUtil.loadClass((ILoadingContext)ResourceVisitor.this.loader.getLoadingContext(), (String)clazz.getName())), (String)handler, (Class[])new Class[]{Object.class, Event.class})) == null) {
                        method = ObjectUtil.findMethod((Class)clazz, (String)handler, (Class[])new Class[]{Event.class});
                    }
                    if (method != null) {
                        clrObject = receiver;
                        if (event.getName().equalsIgnoreCase("Loaded")) {
                            method.setAccessible(true);
                            this.loadedObject = receiver;
                            this.loadedMethod = method;
                            this.hostCLRWidget = control;
                        }
                        eventController.setEvent(event, control, clrObject, (Object)control, method);
                        break;
                    }
                }
                if ((current = current.getParent()) != null || currentParentLoader == null) continue;
                current = currentParentLoader.loadData;
                currentParentLoader = currentParentLoader.parentLoader;
            }
            if (method == null) {
                throw new XWTException("Event handler \"" + handler + "\" is not found.");
            }
        }

        public void end() {
            if (this.parent == null || this.clr != this.parent.getClr()) {
                Method method = ObjectUtil.findDeclaredMethod(this.clr.getClass(), (String)"initializeComponent", (Class[])new Class[0]);
                if (method == null) {
                    method = ObjectUtil.findDeclaredMethod(this.clr.getClass(), (String)"InitializeComponent", (Class[])new Class[0]);
                }
                if (method != null) {
                    try {
                        method.setAccessible(true);
                        method.invoke(this.clr, new Object[0]);
                    }
                    catch (Exception e) {
                        LoggerManager.log((Throwable)e);
                    }
                }
            }
            if (this.loadedObject != null && this.loadedMethod != null && this.hostCLRWidget != null) {
                Event event = new Event();
                event.doit = true;
                event.widget = this.hostCLRWidget;
                try {
                    this.loadedMethod.invoke(this.loadedObject, event);
                }
                catch (Exception exception) {
                    throw new XWTException("");
                }
                this.loadedObject = null;
                this.loadedMethod = null;
                this.hostCLRWidget = null;
            }
        }

        public void addStyle(IStyle style) {
            if (this.styles == Collections.EMPTY_LIST) {
                this.styles = new ArrayList<IStyle>();
            }
            this.styles.add(style);
        }
    }
}

