/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.wizards.pages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.e4.xwt.tools.ui.designer.dialogs.AccessorConfigurationDialog;
import org.eclipse.e4.xwt.tools.ui.designer.providers.ExternalizeStringContentProvider;
import org.eclipse.e4.xwt.tools.ui.designer.providers.ExternalizeStringLabelProvider;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.AccessorConfigureInfo;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.ExternalizeStringsCommon;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.TableCellModifier;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.TableViewerListener;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.models.TextValueEntry;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.models.TextValueModel;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ExternalizeStringsWizardPage
extends WizardPage {
    private ISelection selection;
    private TextValueModel checkedItems;
    private TextValueModel textValueEntrys;
    private TableViewer tableViewer;
    private Text commonPrefixText;
    private boolean isChecked = false;
    private int checkCount = 0;
    public static final String CHECK_COLUMN_ID = "";
    public static final String VALUE_COLUMN_ID = "Value";
    public static final String KEY_COLUMN_ID = "Key";
    private String defaultFolder;
    private String defaultPackage;
    private IPackageFragmentRoot defaultRoot;
    private AccessorConfigureInfo info = new AccessorConfigureInfo();
    private Combo combo;
    private ArrayList duplicateKeys;
    private final TableViewerListener tableViewerListener = new TableViewerListener(){

        public void valueChanged(TextValueEntry textValueEntry) {
            ExternalizeStringsWizardPage.this.tableViewer.refresh((Object)textValueEntry, true);
            ExternalizeStringsWizardPage.this.changeContents();
        }
    };

    public ExternalizeStringsWizardPage(ISelection selection, TextValueModel textValueEntrys) {
        super("wizardPage");
        this.setTitle("Externalize Strings");
        this.setDescription("Externalizes strings from code into a properties file. The auto-generated keys should be adjusted.");
        this.textValueEntrys = textValueEntrys;
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Composite childcontainer = new Composite(container, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        childcontainer.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        childcontainer.setLayoutData((Object)gridData);
        Label commonPrefixLabel = new Label(childcontainer, 0);
        commonPrefixLabel.setText("Enter common prefix for generated keys(optional):");
        this.commonPrefixText = new Text(childcontainer, 2048);
        gridData = new GridData(768);
        this.commonPrefixText.setText("Text_");
        this.commonPrefixText.setLayoutData((Object)gridData);
        this.commonPrefixText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExternalizeStringsWizardPage.this.tableViewer.setLabelProvider((IBaseLabelProvider)new ExternalizeStringLabelProvider(ExternalizeStringsWizardPage.this.commonPrefixText.getText()));
                if (ExternalizeStringsWizardPage.this.checkCount > 0) {
                    ExternalizeStringsWizardPage.this.checkPrefix();
                }
                ExternalizeStringsWizardPage.this.changeContents();
            }
        });
        this.setPageComplete(false);
        this.createWidgetObserve(container);
        this.createSelectAllButton(container);
        this.createAccessorConfigure(container);
        this.setControl((Control)container);
        String defaultFilePath = "/" + this.defaultFolder + "/" + this.defaultPackage.replace(".", "/");
        this.info.setClassFilePath(defaultFilePath);
        this.info.setClassRoot(this.defaultRoot);
        this.info.setSourceFolder(this.defaultFolder);
        this.info.setSourcePackage(this.defaultPackage);
        this.info.setClassName("Messages");
        this.info.setPropertyFilePath(defaultFilePath);
        this.info.setPropertyRoot(this.defaultRoot);
        this.info.setPropertyFolder(this.defaultFolder);
        this.info.setPropertyPackage(this.defaultPackage);
        this.info.setPropertyName("messages");
    }

    private void createSelectAllButton(Composite container) {
        Button button = new Button(container, 8);
        button.setText("Select All");
        GridData gridData = new GridData(768);
        button.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int length = ExternalizeStringsWizardPage.this.tableViewer.getTable().getItems().length;
                if (ExternalizeStringsWizardPage.this.checkCount < length) {
                    int i = 0;
                    while (i < length) {
                        ExternalizeStringsWizardPage.this.tableViewer.getTable().getItem(i).setChecked(true);
                        ExternalizeStringsWizardPage.this.tableViewer.getTable().getItem(i).setBackground(new Color((Device)Display.getDefault(), 226, 226, 226));
                        ++i;
                    }
                    ExternalizeStringsWizardPage.this.checkCount = length;
                } else {
                    int i = 0;
                    while (i < length) {
                        ExternalizeStringsWizardPage.this.tableViewer.getTable().getItem(i).setChecked(false);
                        ExternalizeStringsWizardPage.this.tableViewer.getTable().getItem(i).setBackground(ColorConstants.listBackground);
                        ++i;
                    }
                    ExternalizeStringsWizardPage.this.checkCount = 0;
                }
                ExternalizeStringsWizardPage.this.changeContents();
                ExternalizeStringsWizardPage.this.updatePageComplete(ExternalizeStringsWizardPage.this.checkCount);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createAccessorConfigure(Composite container) {
        this.combo = new Combo(container, 8);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertWidthInCharsToPixels(30);
        this.combo.setLayoutData((Object)gridData);
        this.combo.setItems(new String[]{String.valueOf(this.defaultPackage) + ".Messages.java - " + this.defaultPackage + ".messages.properties"});
        this.combo.select(0);
        Button configureButton = new Button(container, 8);
        configureButton.setText("Configure...");
        gridData = new GridData();
        configureButton.setLayoutData((Object)gridData);
        configureButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AccessorConfigurationDialog dialog = new AccessorConfigurationDialog(ExternalizeStringsWizardPage.this.getShell(), ExternalizeStringsWizardPage.this.info);
                dialog.setTitle("Configure Accessor Class");
                if (dialog.open() == 0) {
                    ExternalizeStringsWizardPage.this.info.setClassFilePath(dialog.getClassFilePath());
                    ExternalizeStringsWizardPage.this.info.setClassRoot(dialog.getclassRoot());
                    ExternalizeStringsWizardPage.this.info.setSourceFolder(dialog.getSourceFolder());
                    ExternalizeStringsWizardPage.this.info.setSourcePackage(dialog.getSourcePackage());
                    ExternalizeStringsWizardPage.this.info.setClassName(dialog.getClassName());
                    ExternalizeStringsWizardPage.this.info.setPropertyFilePath(dialog.getPropertyFilePath());
                    ExternalizeStringsWizardPage.this.info.setPropertyRoot(dialog.getPropertyRoot());
                    ExternalizeStringsWizardPage.this.info.setPropertyFolder(dialog.getPropertyFolder());
                    ExternalizeStringsWizardPage.this.info.setPropertyPackage(dialog.getPropertyPackage());
                    ExternalizeStringsWizardPage.this.info.setPropertyName(dialog.getPropertyName());
                    ExternalizeStringsWizardPage.this.combo.setItems(new String[]{String.valueOf(dialog.getSourcePackage()) + (dialog.getSourcePackage() == null || ExternalizeStringsWizardPage.CHECK_COLUMN_ID.equals(dialog.getSourcePackage()) ? ExternalizeStringsWizardPage.CHECK_COLUMN_ID : ".") + dialog.getClassName() + ".java - " + dialog.getPropertyPackage() + "." + dialog.getPropertyName() + ".properties"});
                    ExternalizeStringsWizardPage.this.combo.select(0);
                    ExternalizeStringsWizardPage.this.changeContents();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createWidgetObserve(Composite container) {
        Composite viewContainer = new Composite(container, 2048);
        GridLayout layout = new GridLayout();
        viewContainer.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        viewContainer.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(viewContainer, 66336);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData.heightHint = table.getItemHeight() * 11;
        table.setLayoutData((Object)gridData);
        String[] colNames = new String[]{CHECK_COLUMN_ID, VALUE_COLUMN_ID, KEY_COLUMN_ID};
        int[] colWidths = new int[]{50, 300, 300};
        int i = 0;
        while (i < colNames.length) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(colNames[i]);
            tableColumn.setWidth(colWidths[i]);
            ++i;
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ExternalizeStringLabelProvider(this.commonPrefixText.getText()));
        this.tableViewer.setContentProvider((IContentProvider)new ExternalizeStringContentProvider());
        this.tableViewer.setInput((Object)this.textValueEntrys);
        this.tableViewer.getTable().getDisplay().asyncExec(new Runnable(){

            public void run() {
                TextValueModel textValueModel = (TextValueModel)ExternalizeStringsWizardPage.this.tableViewer.getInput();
                textValueModel.addPropertyChangeListener(ExternalizeStringsWizardPage.this.tableViewerListener);
            }
        });
        this.initTableEditor();
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExternalizeStringsWizardPage.this.changeContents();
                ExternalizeStringsWizardPage.this.updatePageComplete(ExternalizeStringsWizardPage.this.checkCount);
            }
        });
    }

    private void initTableEditor() {
        this.tableViewer.setColumnProperties(new String[]{CHECK_COLUMN_ID, VALUE_COLUMN_ID, KEY_COLUMN_ID});
        TextCellEditor valueEditor = new TextCellEditor((Composite)this.tableViewer.getTable());
        TextCellEditor keyEditor = new TextCellEditor((Composite)this.tableViewer.getTable());
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = valueEditor;
        cellEditorArray[2] = keyEditor;
        this.tableViewer.setCellEditors(cellEditorArray);
        this.tableViewer.setCellModifier((ICellModifier)new TableCellModifier());
    }

    public TextValueModel getCheckedItems() {
        return this.checkedItems;
    }

    private void updatePageComplete(int checkNum) {
        this.isChecked = false;
        if (checkNum > 0) {
            this.isChecked = true;
            if (this.getErrorMessage() != null) {
                this.setPageComplete(false);
            } else {
                this.setPageComplete(true);
            }
        } else {
            this.updateStatus(null);
        }
    }

    private void checkPrefix() {
        String checkValue = this.commonPrefixText.getText();
        if (!CHECK_COLUMN_ID.equals(checkValue)) {
            String regex = "^([_|a-zA-Z])[_\\w]*$";
            this.checkFormat(checkValue, regex);
        }
    }

    private boolean checkKeyValue(String keyValue) {
        String regex = "^([_|a-zA-Z])[_\\w]*$";
        return this.checkFormat(keyValue, regex);
    }

    private boolean checkFormat(String value, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(value);
        if (!matcher.find()) {
            this.updateStatus("Some selected keys are not valid Java identifiers.");
            return false;
        }
        this.updateStatus(null);
        return true;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null && this.isChecked);
    }

    private void changeContents() {
        int count = this.tableViewer.getTable().getItemCount();
        String checkValue = CHECK_COLUMN_ID;
        this.checkedItems = new TextValueModel();
        int i = 0;
        while (i < count) {
            if (this.tableViewer.getTable().getItem(i).getChecked()) {
                this.tableViewer.getTable().getItem(i).setBackground(new Color((Device)Display.getDefault(), 226, 226, 226));
                if (this.tableViewer.getElementAt(i) instanceof TextValueEntry) {
                    String value = ((TextValueEntry)this.tableViewer.getElementAt(i)).getValue();
                    String key = String.valueOf(this.commonPrefixText.getText()) + ((TextValueEntry)this.tableViewer.getElementAt(i)).getKey();
                    this.checkedItems.add(new TextValueEntry(value, key));
                }
                if (!this.checkKeyValue(checkValue = String.valueOf(this.commonPrefixText.getText()) + ((TextValueEntry)this.tableViewer.getElementAt(i)).getKey())) {
                    break;
                }
            } else {
                this.tableViewer.getTable().getItem(i).setBackground(ColorConstants.listBackground);
            }
            ++i;
        }
        this.checkSameValue();
        this.checkDuplicate(this.info.getClassFilePath(), String.valueOf(this.info.getClassName()) + ".java", this.info.getPropertyFilePath(), String.valueOf(this.info.getPropertyName()) + ".properties");
        this.checkCount = this.getCheckNum();
    }

    private int getCheckNum() {
        int checkNum = 0;
        int i = 0;
        while (i < this.tableViewer.getTable().getItems().length) {
            if (this.tableViewer.getTable().getItem(i).getChecked()) {
                ++checkNum;
            }
            ++i;
        }
        return checkNum;
    }

    private void checkSameValue() {
        Object[] selectedKeys = this.checkedItems.elements();
        String errorMsg = "Conflicting entries: Same key but different values";
        int i = 0;
        while (i < selectedKeys.length) {
            if (selectedKeys[i] instanceof TextValueEntry) {
                String key = ((TextValueEntry)selectedKeys[i]).getKey();
                String value = ((TextValueEntry)selectedKeys[i]).getValue();
                int j = i + 1;
                while (j < selectedKeys.length) {
                    String compareKey = ((TextValueEntry)selectedKeys[j]).getKey();
                    String comparevalue = ((TextValueEntry)selectedKeys[j]).getValue();
                    if (compareKey.equals(key) && !comparevalue.equals(value)) {
                        this.updateStatus(errorMsg);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void checkDuplicate(String sourceFolderName, String className, String propertyFolderName, String propertyName) {
        try {
            this.duplicateKeys = new ArrayList();
            if (ExternalizeStringsCommon.getIFile(sourceFolderName, className).exists()) {
                StringBuffer classHistoryContents = ExternalizeStringsCommon.getHistoryContents(ExternalizeStringsCommon.getIFile(sourceFolderName, className));
                this.checkDuplicateKey(this.checkedItems, classHistoryContents, true);
            }
            if (ExternalizeStringsCommon.getIFile(propertyFolderName, propertyName).exists()) {
                StringBuffer PropertyHistoryContents = ExternalizeStringsCommon.getHistoryContents(ExternalizeStringsCommon.getIFile(propertyFolderName, propertyName));
                this.checkDuplicateKey(this.checkedItems, PropertyHistoryContents, false);
            }
            if (this.duplicateKeys.size() > 0) {
                String dialogMessage = "Key: ";
                ArrayList keys = new ArrayList();
                int i = 0;
                while (i < this.duplicateKeys.size()) {
                    if (keys.indexOf(this.duplicateKeys.get(i)) == -1) {
                        keys.add(this.duplicateKeys.get(i));
                        dialogMessage = String.valueOf(dialogMessage) + "\"" + this.duplicateKeys.get(i) + "\" ";
                    }
                    ++i;
                }
                dialogMessage = String.valueOf(dialogMessage) + "already exist in files. Please rename.";
                this.updateStatus(dialogMessage);
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void checkDuplicateKey(TextValueModel checkedItems, StringBuffer historyContent, boolean isClassFile) {
        String regexSuffix;
        String regexPrefix;
        if (isClassFile) {
            regexPrefix = "[\t ]+";
            regexSuffix = "([\t ]*[\r ]*[\t ]*)*[;]";
        } else {
            regexPrefix = "[\t ]*";
            regexSuffix = "[\t ]*[=]";
        }
        int i = 0;
        while (i < checkedItems.elements().length) {
            String key = ((TextValueEntry)checkedItems.elements()[i]).getKey();
            if (!this.checkKeyValue(key)) {
                return;
            }
            String regex = String.valueOf(regexPrefix) + key + regexSuffix;
            Matcher matcher = Pattern.compile(regex).matcher(historyContent.toString());
            if (matcher.find()) {
                this.duplicateKeys.add(key);
            }
            ++i;
        }
    }

    public void setDefaultFolder(String defaultFolder) {
        this.defaultFolder = defaultFolder;
    }

    public void setDefaultRoot(IPackageFragmentRoot defaultRoot) {
        this.defaultRoot = defaultRoot;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public AccessorConfigureInfo getInfo() {
        return this.info;
    }
}

