/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.core;

import java.lang.reflect.Method;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.annotation.Containment;
import org.eclipse.e4.xwt.core.IEventHandler;
import org.eclipse.e4.xwt.core.TriggerAction;
import org.eclipse.e4.xwt.core.TriggerBase;
import org.eclipse.e4.xwt.internal.utils.LoggerManager;
import org.eclipse.e4.xwt.internal.utils.UserData;
import org.eclipse.e4.xwt.metadata.IEvent;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.ModelUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class EventTrigger
extends TriggerBase {
    private String sourceName;
    private String routedEvent;
    private TriggerAction[] actions = TriggerAction.EMPTY_ARRAY;

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getRoutedEvent() {
        return this.routedEvent;
    }

    public void setRoutedEvent(String routedEvent) {
        this.routedEvent = routedEvent;
    }

    @Containment
    public TriggerAction[] getActions() {
        return this.actions;
    }

    public void setActions(TriggerAction[] actions) {
        this.actions = actions;
    }

    public void prepare(Object target) {
        String routedEvent = this.getRoutedEvent();
        if (routedEvent != null) {
            Object source = EventTrigger.getElementByName(target, this.getSourceName());
            IMetaclass metaclass = XWT.getMetaclass(source);
            IEvent event = metaclass.findEvent(ModelUtils.normalizeEventName(routedEvent));
            if (event == null) {
                if (routedEvent != null && !routedEvent.toLowerCase().endsWith("event")) {
                    LoggerManager.log("Event " + routedEvent + " is not found in " + source.getClass().getName() + ". Please add a suffix \"Event\"!");
                } else {
                    LoggerManager.log("Event " + routedEvent + " is not found in " + source.getClass().getName());
                }
                return;
            }
            TriggerAction[] triggerActionArray = this.getActions();
            int n = triggerActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                TriggerAction triggerAction = triggerActionArray[n2];
                triggerAction.initialize(target);
                ++n2;
            }
            Widget widget = UserData.getWidget(source);
            IEventHandler eventController = UserData.updateEventController(source);
            RunableAction runnable = this.createRunnable(source);
            try {
                Method method = runnable.getClass().getDeclaredMethod("run", Object.class, Event.class);
                eventController.setEvent(event, widget, runnable, this, method);
            }
            catch (Exception e) {
                LoggerManager.log(e);
            }
        }
    }

    public void on(Object target) {
    }

    protected RunableAction createRunnable(Object target) {
        return new RunableAction(target);
    }

    class RunableAction {
        protected Object target;

        public RunableAction(Object target) {
            this.target = target;
        }

        public void run(Object object, Event event) {
            TriggerAction[] triggerActionArray = EventTrigger.this.getActions();
            int n = triggerActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                TriggerAction triggerAction = triggerActionArray[n2];
                triggerAction.run(this.target);
                ++n2;
            }
        }
    }
}

