/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import junit.framework.Assert;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.spi.ISemanticFileHistoryProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.test.TestsContentProviderBase;
import org.eclipse.core.resources.semantic.test.provider.MemoryCachingTestContentProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.history.HistoryPageSource;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.junit.Test;

public class TestsMemoryCachingProvider
extends TestsContentProviderBase {
    public TestsMemoryCachingProvider() {
        super(true, "MemoryCachingTests", MemoryCachingTestContentProvider.class.getName());
    }

    @Test
    public void testHistoryProvider() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        final ISemanticFolder sfolder = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
        final ISemanticFile sfile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
        final ISemanticFileStore sfs = (ISemanticFileStore)EFS.getStore((URI)file.getLocationURI());
        final ISemanticFileHistoryProvider provider = (ISemanticFileHistoryProvider)sfs.getEffectiveContentProvider().getAdapter(ISemanticFileHistoryProvider.class);
        if (provider != null) {
            Object runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IViewPart histView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.team.ui.GenericHistoryView");
                    ((IHistoryView)histView).showHistoryFor((Object)file);
                    sfolder.addFile("File1", TestsMemoryCachingProvider.this.options, monitor);
                    parent.refreshLocal(2, monitor);
                    IFileHistory hist = provider.getHistoryFor(sfs, 0, monitor);
                    Assert.assertNotNull((String)"Should return a history", (Object)hist);
                    Assert.assertTrue((String)"Should have one history entry", (hist.getFileRevisions().length == 1 ? 1 : 0) != 0);
                    sfile.validateEdit(null);
                    try {
                        file.setContents((InputStream)new ByteArrayInputStream("New".getBytes("UTF-8")), 0, monitor);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                    sfile.synchronizeContentWithRemote(SyncDirection.OUTGOING, TestsMemoryCachingProvider.this.options, monitor);
                    file.getParent().refreshLocal(2, monitor);
                    hist = provider.getHistoryFor(sfs, 0, monitor);
                    Assert.assertTrue((String)"Should have two history entries", (hist.getFileRevisions().length == 2 ? 1 : 0) != 0);
                    RepositoryProvider rProvivder = RepositoryProvider.getProvider((IProject)TestsMemoryCachingProvider.this.testProject);
                    IFileHistory rHist = rProvivder.getFileHistoryProvider().getFileHistoryFor((IFileStore)sfs, 0, monitor);
                    Assert.assertTrue((String)"Should have two history entries", (rHist.getFileRevisions().length == 2 ? 1 : 0) != 0);
                    rHist = rProvivder.getFileHistoryProvider().getFileHistoryFor((IResource)file, 0, monitor);
                    Assert.assertTrue((String)"Should have two history entries", (rHist.getFileRevisions().length == 2 ? 1 : 0) != 0);
                    IFileRevision wrev = rProvivder.getFileHistoryProvider().getWorkspaceFileRevision((IResource)file);
                    Assert.assertNotNull((String)"Workspace version should not be null", (Object)wrev);
                    boolean canShow = HistoryPageSource.getHistoryPageSource((Object)file).canShowHistoryFor((Object)file);
                    Assert.assertTrue((String)"Should be able to show history view", (boolean)canShow);
                    IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.team.ui.GenericHistoryView");
                    Assert.assertNotNull((String)"History page part should not be null", (Object)part);
                    IViewReference ref = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("org.eclipse.team.ui.GenericHistoryView");
                    Assert.assertNotNull((String)"View reference must not be null", (Object)ref);
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
            runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    sfolder.remove(TestsMemoryCachingProvider.this.options, monitor);
                    file.getProject().refreshLocal(2, monitor);
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
        } else {
            Assert.fail((String)"No Histoy provider");
        }
    }
}

