/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFile;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.resources.semantic.test.TestsContentProviderUtil;
import org.eclipse.core.resources.semantic.test.provider.CachingTestContentProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.fileSystem.FileSystemContributor;
import org.eclipse.ui.internal.ide.filesystem.FileSystemConfiguration;
import org.eclipse.ui.internal.ide.filesystem.FileSystemSupportRegistry;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestsSFSUi
extends TestsContentProviderUtil {
    RemoteFile file1;

    public TestsSFSUi() {
        super(true, "TestsSemanticFileSystemUI", CachingTestContentProvider.class.getName());
    }

    @Before
    public void beforeMethod() throws Exception {
        String[] roots;
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.testProject = workspace.getRoot().getProject(this.projectName);
        if (this.testProject.exists()) {
            throw new IllegalStateException("Project exists");
        }
        IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProjectDescription description = workspace.newProjectDescription(TestsSFSUi.this.projectName);
                try {
                    description.setLocationURI(new URI("semanticfs:/" + TestsSFSUi.this.projectName));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                TestsSFSUi.this.testProject.create(description, monitor);
                TestsSFSUi.this.testProject.open(monitor);
                RemoteStoreTransient store = (RemoteStoreTransient)TestsSFSUi.this.testProject.getAdapter(RemoteStoreTransient.class);
                RemoteFolder f1 = store.getRootFolder().addFolder("Folder1");
                try {
                    TestsSFSUi.this.file1 = f1.addFile("File1", "Hello".getBytes("UTF-8"), store.newTime());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                f1.addFolder("Folder11");
                RepositoryProvider.map((IProject)TestsSFSUi.this.testProject, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
                ISemanticProject spr = (ISemanticProject)TestsSFSUi.this.testProject.getAdapter(ISemanticProject.class);
                HashMap<QualifiedName, String> properties = new HashMap<QualifiedName, String>();
                properties.put(TEMPLATE_PROP, "World");
                spr.addFolder("root", TestsSFSUi.this.providerName, properties, TestsSFSUi.this.options, monitor);
                TestsSFSUi.this.testProject.refreshLocal(2, monitor);
            }
        };
        workspace.run(myRunnable, (ISchedulingRule)workspace.getRoot(), 1, null);
        String projectName1 = this.testProject.getName();
        String[] stringArray = roots = ((ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs")).getRootNames();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            if (root.equals(projectName1)) {
                return;
            }
            ++n2;
        }
        Assert.fail((String)"Project should be in the list of root names");
    }

    @After
    public void afterMethod() throws Exception {
        RemoteStoreTransient store = (RemoteStoreTransient)this.testProject.getAdapter(RemoteStoreTransient.class);
        store.reset();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(this.projectName);
        this.testProject = null;
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.delete(true, monitor);
                project.refreshLocal(2, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testPropertiesPage() throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder f1 = (ISemanticFolder)TestsSFSUi.this.testProject.getFolder("root").getFolder("Folder1").getAdapter(ISemanticFolder.class);
                f1.addFile("File1", 0, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
        Shell shell = new Shell(Display.getCurrent());
        PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)this.testProject, (String)"org.eclipse.core.resources.semantic.propertyPage", null, null);
        dialog.setBlockOnOpen(false);
        dialog.open();
        dialog.close();
        IFolder folder = this.testProject.getFolder("root").getFolder("Folder1");
        dialog = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)folder, (String)"org.eclipse.core.resources.semantic.propertyPage", null, null);
        dialog.setBlockOnOpen(false);
        dialog.open();
        dialog.close();
        IFile file = folder.getFile("File1");
        dialog = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)file, (String)"org.eclipse.core.resources.semantic.propertyPage", null, null);
        dialog.setBlockOnOpen(false);
        dialog.open();
        dialog.close();
    }

    @Test
    public void testPreferencePage() {
        Shell shell = new Shell(Display.getCurrent());
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.core.resources.semantic.preferencePage", null, null);
        dialog.setBlockOnOpen(false);
        dialog.open();
        dialog.close();
    }

    @Test
    public void testBrowser() throws CoreException {
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.core.resources.semantic.resourceView");
        Assert.assertNotNull((String)"View should not be null", (Object)part);
    }

    @Test
    public void testContributor() throws CoreException {
        FileSystemConfiguration[] configs;
        FileSystemContributor contributor = null;
        FileSystemConfiguration[] fileSystemConfigurationArray = configs = FileSystemSupportRegistry.getInstance().getConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            FileSystemConfiguration config = fileSystemConfigurationArray[n2];
            if (config.getContributor().getClass().getName().equals("org.eclipse.core.internal.resources.semantic.ui.SemanticFileSystemContributor")) {
                contributor = config.getContributor();
            }
            ++n2;
        }
        if (contributor == null) {
            Assert.fail((String)"Contributor not found");
            return;
        }
        URI test1 = contributor.getURI("/test/Uri");
        Assert.assertEquals((String)"URI result", (Object)"semanticfs:/test/Uri", (Object)test1.toString());
        test1 = contributor.getURI("semanticfs:\\test/Uri2");
        Assert.assertEquals((String)"URI result", (Object)"semanticfs:/test/Uri2", (Object)test1.toString());
        URI test = contributor.browseFileSystem("semanticfs:/" + this.testProject.getName() + "/" + "root", null);
        Assert.assertEquals((String)"URI result", (Object)"semanticfs:/TestsSemanticFileSystemUI/root", (Object)test.toString());
    }

    @Test
    public void testLockUnlockActions() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder f1 = (ISemanticFolder)TestsSFSUi.this.testProject.getFolder("root").getFolder("Folder1").getAdapter(ISemanticFolder.class);
                f1.addFile("File1", 0, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
        ISemanticFile sFile = (ISemanticFile)this.testProject.getFile((IPath)new Path("root/Folder1/File1")).getAdapter(ISemanticFile.class);
        Assert.assertEquals((String)"Lock state", (Object)false, (Object)sFile.fetchResourceInfo(2, null).isLocked());
        this.runCommandByAction("LockCommand", (ISemanticResource)sFile);
        Assert.assertEquals((String)"Lock state", (Object)true, (Object)sFile.fetchResourceInfo(2, null).isLocked());
        this.runCommandByAction("UnlockCommand", (ISemanticResource)sFile);
        Assert.assertEquals((String)"Lock state", (Object)false, (Object)sFile.fetchResourceInfo(2, null).isLocked());
    }

    @Test
    public void testRemoveAction() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder f1 = (ISemanticFolder)TestsSFSUi.this.testProject.getFolder("root").getFolder("Folder1").getAdapter(ISemanticFolder.class);
                f1.addFile("File1", 0, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
        ISemanticFile sFile = (ISemanticFile)this.testProject.getFile((IPath)new Path("root/Folder1/File1")).getAdapter(ISemanticFile.class);
        Assert.assertEquals((String)"File existence", (Object)true, (Object)sFile.getAdaptedFile().exists());
        this.runCommandByAction("RemoveCommand", (ISemanticResource)sFile);
        Assert.assertEquals((String)"File existence", (Object)false, (Object)sFile.getAdaptedFile().exists());
        Assert.assertEquals((String)"Remote File existence", (Object)true, (Object)sFile.fetchResourceInfo(32, null).existsRemotely());
    }

    @Test
    public void testHistoryAction() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder f1 = (ISemanticFolder)TestsSFSUi.this.testProject.getFolder("root").getFolder("Folder1").getAdapter(ISemanticFolder.class);
                f1.addFile("File1", 0, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
        ISemanticFile sFile = (ISemanticFile)this.testProject.getFile((IPath)new Path("root/Folder1/File1")).getAdapter(ISemanticFile.class);
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.team.ui.GenericHistoryView");
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(part);
        final ArrayList partIds = new ArrayList();
        IPartListener2 listener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                partIds.add(partRef.getId());
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener(listener);
        this.runCommandByAction("RemoteHistoryCommand", (ISemanticResource)sFile);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().removePartListener(listener);
        Assert.assertTrue((String)"History part should have been opened", (boolean)partIds.contains("org.eclipse.team.ui.GenericHistoryView"));
    }

    @Test
    @Ignore
    public void testSynchronizeAction() throws Exception {
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder f1 = (ISemanticFolder)TestsSFSUi.this.testProject.getFolder("root").getFolder("Folder1").getAdapter(ISemanticFolder.class);
                f1.addFile("File1", 0, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
        final ISemanticFile sFile = (ISemanticFile)this.testProject.getFile((IPath)new Path("root/Folder1/File1")).getAdapter(ISemanticFile.class);
        this.assertContentsEqual(sFile.getAdaptedFile(), "Hello");
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IStatus stat = sFile.validateEdit(null);
                Assert.assertTrue((String)"Validate Edit should be ok", (boolean)stat.isOK());
                try {
                    sFile.getAdaptedFile().setContents((InputStream)new ByteArrayInputStream("Test".getBytes("UTF-8")), 0, null);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
        this.assertContentsEqual(sFile.getAdaptedFile(), "Test");
        this.runCommandByAction("SynchronizeCommand", (ISemanticResource)sFile);
        Assert.assertEquals((String)"Remote content", (Object)"Test", (Object)new String(this.file1.getContent(), "UTF-8"));
        byte[] bytes = "NewRemote".getBytes("UTF-8");
        ByteArrayOutputStream os = null;
        try {
            os = this.file1.getOutputStream(false);
            ((OutputStream)os).write(bytes, 0, bytes.length);
        }
        catch (Throwable throwable) {
            Util.safeClose(os);
            throw throwable;
        }
        Util.safeClose((OutputStream)os);
        Assert.assertEquals((String)"Remote content", (Object)"NewRemote", (Object)new String(this.file1.getContent(), "UTF-8"));
        this.runCommandByAction("SynchronizeCommand", (ISemanticResource)sFile);
        this.assertContentsEqual(sFile.getAdaptedFile(), "NewRemote");
    }

    @Test
    public void testDeleteAction() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder f1 = (ISemanticFolder)TestsSFSUi.this.testProject.getFolder("root").getFolder("Folder1").getAdapter(ISemanticFolder.class);
                f1.addFile("File1", 0, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
        ISemanticFile sFile = (ISemanticFile)this.testProject.getFile((IPath)new Path("root/Folder1/File1")).getAdapter(ISemanticFile.class);
        Assert.assertEquals((String)"File existence", (Object)true, (Object)sFile.getAdaptedFile().exists());
        this.runCommandByAction("DeleteCommand", (ISemanticResource)sFile);
        Assert.assertEquals((String)"File existence", (Object)false, (Object)sFile.getAdaptedFile().exists());
        Assert.assertEquals((String)"Remote File existence", (Object)false, (Object)sFile.fetchResourceInfo(32, null).existsRemotely());
    }

    @Test
    public void testDiffAction() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder f1 = (ISemanticFolder)TestsSFSUi.this.testProject.getFolder("root").getFolder("Folder1").getAdapter(ISemanticFolder.class);
                f1.addFile("File1", 0, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
        ISemanticFile sFile = (ISemanticFile)this.testProject.getFile((IPath)new Path("root/Folder1/File1")).getAdapter(ISemanticFile.class);
        Assert.assertEquals((String)"File existence", (Object)true, (Object)sFile.getAdaptedFile().exists());
        this.runCommandByAction("DiffCommand", (ISemanticResource)sFile);
        Assert.assertEquals((String)"File existence", (Object)true, (Object)sFile.getAdaptedFile().exists());
    }

    @Test
    public void testEditRevertActions() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder f1 = (ISemanticFolder)TestsSFSUi.this.testProject.getFolder("root").getFolder("Folder1").getAdapter(ISemanticFolder.class);
                f1.addFile("File1", 0, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null);
        ISemanticFile sFile = (ISemanticFile)this.testProject.getFile((IPath)new Path("root/Folder1/File1")).getAdapter(ISemanticFile.class);
        Assert.assertEquals((String)"Read-only state", (Object)true, (Object)sFile.fetchResourceInfo(16, null).isReadOnly());
        this.runCommandByAction("OpenForEditCommand", (ISemanticResource)sFile);
        Assert.assertEquals((String)"Read-only state", (Object)false, (Object)sFile.fetchResourceInfo(16, null).isReadOnly());
        this.runCommandByAction("RevertCommand", (ISemanticResource)sFile);
        Assert.assertEquals((String)"Read-only state", (Object)true, (Object)sFile.fetchResourceInfo(16, null).isReadOnly());
    }

    @Test
    public void testUnmapAction() throws Exception {
        ISemanticProject project = (ISemanticProject)this.testProject.getAdapter(ISemanticProject.class);
        Assert.assertNotNull((String)"Mapping", (Object)RepositoryProvider.getProvider((IProject)this.testProject, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider"));
        this.runCommandByAction("UnshareCommand", (ISemanticResource)project);
        Assert.assertNull((String)"Mapping", (Object)RepositoryProvider.getProvider((IProject)this.testProject, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider"));
    }

    private void runCommandByAction(String actionName, ISemanticResource resource) throws Exception {
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.navigator.ProjectExplorer");
        ICommandService csrv = (ICommandService)part.getSite().getService(ICommandService.class);
        Command commandToRun = csrv.getCommand("org.eclipse.core.resources.semantic.ui." + actionName);
        if (commandToRun == null || !commandToRun.isDefined()) {
            throw new RuntimeException("Command not found for " + actionName);
        }
        IHandlerService srv = (IHandlerService)part.getSite().getService(IHandlerService.class);
        IEvaluationContext ctx = srv.createContextSnapshot(true);
        ctx.addVariable("selection", (Object)new StructuredSelection((Object)resource));
        ctx.addVariable("activeMenuSelection", (Object)new StructuredSelection((Object)resource));
        ExecutionEvent event = new ExecutionEvent(commandToRun, new HashMap(), (Object)resource, (Object)ctx);
        commandToRun.executeWithChecks(event);
    }
}

