/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.core.resources.semantic.examples.SelectScenarioPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDemoProjectPage
extends WizardPage {
    String projectName;
    String directoryName = "";
    boolean useOtherProject = false;
    private Set<SelectScenarioPage.Scenario> scenarios = new HashSet<SelectScenarioPage.Scenario>();

    public CreateDemoProjectPage() {
        super(CreateDemoProjectPage.class.getName());
        this.setTitle(Messages.CreateDemoProjectPage_CreateProject_XGRP);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        Label nameLabel = new Label(main, 0);
        nameLabel.setText(Messages.CreateDemoProjectPage_ProjectName_XFLD);
        final Text name = new Text(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)name);
        Label dirLabel = new Label(main, 0);
        dirLabel.setText(Messages.CreateDemoProjectPage_TempDir_XFLD);
        final Text dir = new Text(main, 2048);
        dir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String dirname = dir.getText();
                if (dirname.equals("")) {
                    CreateDemoProjectPage.this.setErrorMessage(Messages.CreateDemoProjectPage_DirRequired_XMSG);
                    CreateDemoProjectPage.this.directoryName = null;
                    CreateDemoProjectPage.this.setPageComplete(false);
                } else {
                    CreateDemoProjectPage.this.setErrorMessage(null);
                    CreateDemoProjectPage.this.directoryName = dirname;
                    CreateDemoProjectPage.this.setPageComplete(true);
                }
            }
        });
        dir.setText(System.getProperty("java.io.tmpdir"));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)dir);
        Button browse = new Button(main, 8);
        browse.setText(Messages.CreateDemoProjectPage_Browse_XBUT);
        browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog fd = new DirectoryDialog(CreateDemoProjectPage.this.getShell());
                fd.setFilterPath(dir.getText());
                String result = fd.open();
                if (result != null) {
                    dir.setText(result);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button separateProject = new Button(main, 32);
        separateProject.setText(Messages.CreateDemoProjectPage_UseSeparateProject_XRBL);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)separateProject);
        separateProject.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateDemoProjectPage.this.useOtherProject = separateProject.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pname = name.getText();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pname);
                if (project.exists()) {
                    CreateDemoProjectPage.this.setErrorMessage(Messages.CreateDemoProjectPage_ProjectExists_XMSG);
                    CreateDemoProjectPage.this.projectName = null;
                    CreateDemoProjectPage.this.setPageComplete(false);
                } else {
                    CreateDemoProjectPage.this.setErrorMessage(null);
                    CreateDemoProjectPage.this.projectName = pname;
                    CreateDemoProjectPage.this.setPageComplete(true);
                }
            }
        });
        name.setText("SemanticFileSystemDemo");
        this.setControl((Control)main);
    }

    public Set<SelectScenarioPage.Scenario> getScenarios() {
        return this.scenarios;
    }

    public void setScenarios(Set<SelectScenarioPage.Scenario> scenarios) {
        this.scenarios = scenarios;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getDirectoryName() {
        return this.directoryName.replace('\\', '/');
    }

    public boolean isUseOtherProject() {
        return this.useOtherProject;
    }
}

