/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.ui.Messages;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.spi.SemanticFileCache;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SemanticFileSystemPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        Label pathLabel = new Label(main, 0);
        pathLabel.setText(Messages.SemanticFileSystemPreferencePage_PathToDb_XFLD);
        final Text path = new Text(main, 2048);
        path.setEditable(false);
        try {
            ISemanticFileSystem sfs = (ISemanticFileSystem)EFS.getFileSystem((String)"semanticfs");
            path.setText(sfs.getPathToDb());
        }
        catch (CoreException coreException) {
            path.setText(Messages.SemanticFileSystemPreferencePage_Exception_GetPath_XMSG);
        }
        Label cachePathLabel = new Label(main, 0);
        cachePathLabel.setText(Messages.SemanticFileSystemPreferencePage_PathToCache_XFLD);
        final Text cachePath = new Text(main, 2048);
        cachePath.setEditable(false);
        try {
            File cacheFile = SemanticFileCache.getCache().getCacheDir();
            cachePath.setText(cacheFile.getAbsolutePath());
        }
        catch (CoreException coreException) {
            cachePath.setText(Messages.SemanticFileSystemPreferencePage_Exception_GetPath_XMSG);
        }
        Button delete = new Button(main, 8);
        GridDataFactory.fillDefaults().span(2, 1).align(16384, 0x1000000).applyTo((Control)delete);
        delete.setText(Messages.SemanticFileSystemPreferencePage_Delete_XBUT);
        delete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean ok = MessageDialog.openConfirm((Shell)SemanticFileSystemPreferencePage.this.getShell(), (String)Messages.SemanticFileSystemPreferencePage_Confirm_XGRP, (String)Messages.SemanticFileSystemPreferencePage_Confirm_XMSG);
                if (ok) {
                    boolean deleted = true;
                    File db = new File(path.getText());
                    if (db.exists() && !(deleted = db.delete())) {
                        db.deleteOnExit();
                    }
                    boolean cacheDeleted = true;
                    File cache = new File(cachePath.getText());
                    if (cache.exists()) {
                        try {
                            SemanticFileSystemPreferencePage.this.delete(cache);
                        }
                        catch (CoreException coreException) {
                            cacheDeleted = false;
                        }
                        if (!cacheDeleted) {
                            cache.deleteOnExit();
                        }
                    }
                    MessageDialog.openConfirm((Shell)SemanticFileSystemPreferencePage.this.getShell(), (String)Messages.SemanticFileSystemPreferencePage_Restart_XGRP, (String)Messages.SemanticFileSystemPreferencePage_Restart_XMSG);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return main;
    }

    public void init(IWorkbench workbench) {
    }

    void delete(File file) throws CoreException {
        MultiStatus status = new MultiStatus("org.eclipse.ui.resources.semantic", 0, NLS.bind((String)Messages.SemanticFileSystemPreferencePage_DeletingFile_XMSG, (Object)file.getPath()), null);
        if (file.exists()) {
            this.deleteFile(file, status);
            if (!status.isOK()) {
                throw new CoreException((IStatus)status);
            }
        }
    }

    private void deleteFile(File actFile, MultiStatus status) {
        if (actFile.isDirectory()) {
            File[] fileArray = actFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.deleteFile(child, status);
                ++n2;
            }
        }
        if (!actFile.delete()) {
            status.add((IStatus)new Status(4, "org.eclipse.ui.resources.semantic", NLS.bind((String)Messages.SemanticFileSystemPreferencePage_CouldNotDelete_XMSG, (Object)actFile.getPath().toString())));
        }
    }
}

