/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;

public class FieldBinding
extends VariableBinding {
    public ReferenceBinding declaringClass;

    protected FieldBinding() {
        super(null, null, 0);
    }

    public FieldBinding(char[] name, TypeBinding type, int modifiers, ReferenceBinding declaringClass) {
        super(name, type, modifiers);
        this.declaringClass = declaringClass;
    }

    public FieldBinding(InferredAttribute field, TypeBinding type, int modifiers, ReferenceBinding declaringClass) {
        this(field.name, type, modifiers, declaringClass);
        field.binding = this;
    }

    public FieldBinding(FieldBinding initialFieldBinding, ReferenceBinding declaringClass) {
        super(initialFieldBinding.name, initialFieldBinding.type, initialFieldBinding.modifiers);
        this.declaringClass = declaringClass;
        this.id = initialFieldBinding.id;
    }

    public final int kind() {
        return 1;
    }

    public final boolean canBeSeenBy(PackageBinding invocationPackage) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return invocationPackage == this.declaringClass.getPackage();
    }

    public final boolean canBeSeenBy(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        if (!this.isPublic()) {
            // empty if block
        }
        return true;
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        char[] cArray;
        char[] declaringKey = this.declaringClass == null ? CharOperation.NO_CHAR : this.declaringClass.computeUniqueKey(false);
        int declaringLength = declaringKey.length;
        int nameLength = this.name.length;
        if (this.type == null) {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = 86;
        } else {
            cArray = this.type.computeUniqueKey(false);
        }
        char[] returnTypeKey = cArray;
        int returnTypeLength = returnTypeKey.length;
        char[] uniqueKey = new char[declaringLength + 1 + nameLength + 1 + returnTypeLength];
        int index = 0;
        System.arraycopy(declaringKey, 0, uniqueKey, index, declaringLength);
        index += declaringLength;
        uniqueKey[index++] = 46;
        System.arraycopy(this.name, 0, uniqueKey, index, nameLength);
        index += nameLength;
        uniqueKey[index++] = 41;
        System.arraycopy(returnTypeKey, 0, uniqueKey, index, returnTypeLength);
        return uniqueKey;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public FieldBinding original() {
        return this;
    }

    public boolean isFor(AbstractVariableDeclaration variableDeclaration) {
        return false;
    }
}

