/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDMaxFacetImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDMaxExclusiveFacetImpl
extends XSDMaxFacetImpl
implements XSDMaxExclusiveFacet {
    public static XSDMaxExclusiveFacet createMaxExclusiveFacet(Node node) {
        if (XSDConstants.nodeType(node) == 23) {
            XSDMaxExclusiveFacet xsdMaxExclusiveFacet = XSDFactory.eINSTANCE.createXSDMaxExclusiveFacet();
            xsdMaxExclusiveFacet.setElement((Element)node);
            return xsdMaxExclusiveFacet;
        }
        return null;
    }

    protected XSDMaxExclusiveFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.Literals.XSD_MAX_EXCLUSIVE_FACET;
    }

    public Element createElement() {
        Element newElement = this.createElement(23);
        this.setElement(newElement);
        return newElement;
    }

    protected boolean analyze() {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition;
        super.analyze();
        String theLexicalValue = this.getLexicalValue();
        Object newValue = null;
        if (theLexicalValue != null && (xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.getContainer()) != null) {
            try {
                newValue = xsdSimpleTypeDefinition.getValue(this.getElement(), theLexicalValue);
            }
            catch (RuntimeException runtimeException) {}
        }
        if (newValue == null ? this.getValue() != null : !newValue.equals(this.getValue())) {
            this.setValue(newValue);
        }
        return true;
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (eAttribute == XSDPackage.Literals.XSD_FACET__LEXICAL_VALUE) {
            this.traverseToRootForAnalysis();
        }
    }

    public boolean isConstraintSatisfied(Object value) {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.getContainer();
        if (xsdSimpleTypeDefinition != null) {
            return xsdSimpleTypeDefinition.compareValues(value, this.getValue()) < 0;
        }
        return false;
    }

    public Object getEffectiveValue() {
        return this.getValue();
    }

    public boolean isExclusive() {
        return true;
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDMaxExclusiveFacetImpl clonedMaxExclusiveFacet = (XSDMaxExclusiveFacetImpl)this.getXSDFactory().createXSDMaxExclusiveFacet();
        clonedMaxExclusiveFacet.isReconciling = true;
        if (this.getLexicalValue() != null) {
            clonedMaxExclusiveFacet.setLexicalValue(this.getLexicalValue());
        }
        if (this.isSetFixed()) {
            clonedMaxExclusiveFacet.setFixed(this.isFixed());
        }
        if (deep && this.getAnnotation() != null) {
            clonedMaxExclusiveFacet.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedMaxExclusiveFacet.setElement(this.getElement());
        }
        clonedMaxExclusiveFacet.isReconciling = shareDOM;
        return clonedMaxExclusiveFacet;
    }
}

