/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.builders.BuildErrorReporter;
import org.eclipse.pde.internal.core.builders.SourceEntryErrorReporter;

public class SourceEntryErrorReporter
extends BuildErrorReporter {
    private HashMap fSourceFolderMap = new HashMap(4);
    private HashMap fOutputFolderMap = new HashMap(4);

    public SourceEntryErrorReporter(IFile file) {
        super(file);
    }

    public void initialize(ArrayList sourceEntries, ArrayList outputEntries, IClasspathEntry[] cpes, IProject project) {
        IPath path;
        String[] tokens;
        String libName;
        this.fProject = project;
        IPath defaultOutputLocation = null;
        IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
        try {
            defaultOutputLocation = javaProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {}
        int i = 0;
        while (i < cpes.length) {
            IPath outputPath;
            OutputFolder outputFolder;
            if (cpes[i].getEntryKind() == 3) {
                SourceFolder sourceFolder;
                IPath sourcePath = cpes[i].getPath().removeFirstSegments(1).addTrailingSeparator();
                IPath outputLocation = cpes[i].getOutputLocation();
                if (outputLocation == null) {
                    outputLocation = defaultOutputLocation;
                }
                if ((outputFolder = (OutputFolder)this.fOutputFolderMap.get(outputPath = outputLocation.removeFirstSegments(1).addTrailingSeparator())) == null) {
                    outputFolder = new OutputFolder(outputPath);
                }
                if ((sourceFolder = (SourceFolder)this.fSourceFolderMap.get(sourcePath)) == null) {
                    sourceFolder = new SourceFolder(sourcePath, outputFolder);
                }
                outputFolder.addSourceFolder(sourceFolder);
                this.fOutputFolderMap.put(outputPath, outputFolder);
                this.fSourceFolderMap.put(sourcePath, sourceFolder);
            } else if (cpes[i].getEntryKind() == 1) {
                IClasspathEntry entry = cpes[i];
                IPackageFragmentRoot[] roots = javaProject.findPackageFragmentRoots(entry);
                outputPath = null;
                if (roots.length == 1) {
                    outputPath = roots[0].getResource() != null ? entry.getPath().removeFirstSegments(1).addTrailingSeparator() : entry.getPath();
                }
                outputFolder = new OutputFolder(outputPath, true);
                this.fOutputFolderMap.put(outputPath, outputFolder);
            }
            ++i;
        }
        Iterator iterator = sourceEntries.iterator();
        while (iterator.hasNext()) {
            IBuildEntry sourceEntry = (IBuildEntry)iterator.next();
            libName = sourceEntry.getName().substring("source.".length());
            tokens = sourceEntry.getTokens();
            int i2 = 0;
            while (i2 < tokens.length) {
                path = new Path(tokens[i2]).addTrailingSeparator();
                SourceFolder sourceFolder = (SourceFolder)this.fSourceFolderMap.get(path);
                if (sourceFolder == null) {
                    sourceFolder = new SourceFolder(path, null);
                    this.fSourceFolderMap.put(path, sourceFolder);
                }
                sourceFolder.setToken(tokens[i2]);
                sourceFolder.addLib(libName);
                ++i2;
            }
        }
        iterator = outputEntries.iterator();
        while (iterator.hasNext()) {
            IBuildEntry outputEntry = (IBuildEntry)iterator.next();
            libName = outputEntry.getName().substring("output.".length());
            tokens = outputEntry.getTokens();
            int i3 = 0;
            while (i3 < tokens.length) {
                OutputFolder outputFolder;
                path = new Path(tokens[i3]).addTrailingSeparator();
                if (path.segmentCount() == 1 && path.segment(0).equals(".")) {
                    path = Path.ROOT;
                }
                if ((outputFolder = (OutputFolder)this.fOutputFolderMap.get(path)) == null) {
                    outputFolder = new OutputFolder(path);
                    this.fOutputFolderMap.put(path, outputFolder);
                }
                outputFolder.setToken(tokens[i3]);
                outputFolder.addLib(libName);
                ++i3;
            }
        }
    }

    public void validate() {
        Iterator iterator = this.fOutputFolderMap.keySet().iterator();
        while (iterator.hasNext()) {
            IPath outputPath = (IPath)iterator.next();
            OutputFolder outputFolder = (OutputFolder)this.fOutputFolderMap.get(outputPath);
            ArrayList sourceFolders = outputFolder.getSourceFolders();
            ArrayList outputFolderLibs = new ArrayList(outputFolder.getLibs());
            if (sourceFolders.size() == 0) {
                if (outputFolder.isLibrary()) continue;
                Iterator libNameiterator = outputFolderLibs.iterator();
                while (libNameiterator.hasNext()) {
                    String libName = (String)libNameiterator.next();
                    IResource folderEntry = this.fProject.findMember(outputPath);
                    String message = folderEntry == null || !folderEntry.exists() || !(folderEntry instanceof IContainer) ? NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFolder, (Object)outputPath.toString()) : NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_InvalidOutputFolder, (Object)outputPath.toString());
                    this.prepareError("output." + libName, outputFolder.getToken(), message, 8197, this.fOututLibSeverity, "");
                }
                continue;
            }
            String srcFolderLibName = null;
            int i = 0;
            while (i < sourceFolders.size()) {
                SourceFolder sourceFolder = (SourceFolder)sourceFolders.get(i);
                ArrayList srcFolderLibs = sourceFolder.getLibs();
                outputFolderLibs.removeAll(srcFolderLibs);
                switch (srcFolderLibs.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (srcFolderLibName == null) {
                            srcFolderLibName = (String)srcFolderLibs.get(0);
                            break;
                        }
                        if (srcFolderLibName.equals(srcFolderLibs.get(0))) break;
                    }
                    default: {
                        String erringSrcFolders = this.join(sourceFolders.toArray(new SourceFolder[sourceFolders.size()]));
                        int j = 0;
                        while (j < sourceFolders.size()) {
                            SourceFolder srcFolder = (SourceFolder)sourceFolders.get(j);
                            int k = 0;
                            while (k < srcFolder.getLibs().size()) {
                                String libName = (String)srcFolder.getLibs().get(k);
                                String message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_DifferentTargetLibrary, (Object)erringSrcFolders);
                                this.prepareError("source." + libName, srcFolder.getToken(), message, -1, this.fSrcLibSeverity, "");
                                ++k;
                            }
                            ++j;
                        }
                        break block0;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < outputFolderLibs.size()) {
                String message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_ExtraOutputFolder, (Object)outputFolder.getPath().toString(), (Object)("source." + outputFolderLibs.get(i)));
                this.prepareError("output." + outputFolderLibs.get(i), outputFolder.getToken(), message, 8197, this.fOututLibSeverity, "");
                ++i;
            }
            if (outputFolder.getDupeLibName() == null) continue;
            String message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_DupeOutputFolder, (Object)outputPath.toString(), (Object)("output." + outputFolder.getDupeLibName()));
            this.prepareError("output." + outputFolder.getDupeLibName(), outputFolder.getToken(), message, -1, this.fOututLibSeverity, "");
        }
        class MissingOutputEntry {
            public StringBuffer fSsrcFolders;
            public StringBuffer fOutputFolders;
            final /* synthetic */ SourceEntryErrorReporter this$0;

            MissingOutputEntry(SourceEntryErrorReporter sourceEntryErrorReporter) {
                this.this$0 = sourceEntryErrorReporter;
                this.fSsrcFolders = new StringBuffer();
                this.fOutputFolders = new StringBuffer();
            }

            public String get(StringBuffer field) {
                if (field.charAt(field.length() - 1) == ',') {
                    field.deleteCharAt(field.length() - 1);
                }
                return field.toString().trim();
            }
        }
        HashMap<String, MissingOutputEntry> missingOutputEntryErrors = new HashMap<String, MissingOutputEntry>(4);
        Iterator iterator2 = this.fSourceFolderMap.keySet().iterator();
        while (iterator2.hasNext()) {
            IPath sourcePath = (IPath)iterator2.next();
            SourceFolder sourceFolder = (SourceFolder)this.fSourceFolderMap.get(sourcePath);
            OutputFolder outputFolder = sourceFolder.getOutputLocation();
            if (outputFolder == null) {
                IResource folderEntry = this.fProject.findMember(sourcePath);
                String message = folderEntry == null || !folderEntry.exists() || !(folderEntry instanceof IContainer) ? NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFolder, (Object)sourcePath.toString()) : NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_InvalidSourceFolder, (Object)sourcePath.toString());
                ArrayList srcLibs = sourceFolder.getLibs();
                int i = 0;
                while (i < srcLibs.size()) {
                    String libName = (String)srcLibs.get(i);
                    this.prepareError("source." + libName, sourceFolder.getToken(), message, 8197, this.fSrcLibSeverity, "");
                    ++i;
                }
                continue;
            }
            if (outputFolder.getLibs().size() == 0 && sourceFolder.getLibs().size() == 1) {
                String libName = (String)sourceFolder.getLibs().get(0);
                MissingOutputEntry errorEntry = (MissingOutputEntry)missingOutputEntryErrors.get(libName);
                if (errorEntry == null) {
                    errorEntry = new MissingOutputEntry(this);
                }
                if (errorEntry.fSsrcFolders.indexOf(String.valueOf(sourcePath.toString()) + ',') < 0) {
                    errorEntry.fSsrcFolders.append(String.valueOf(' ') + sourcePath.toString() + ',');
                }
                if (errorEntry.fOutputFolders.indexOf(String.valueOf(outputFolder.getToken()) + ',') < 0) {
                    errorEntry.fOutputFolders.append(String.valueOf(' ') + outputFolder.getToken() + ',');
                }
                missingOutputEntryErrors.put(libName, errorEntry);
            }
            if (sourceFolder.getDupeLibName() == null) continue;
            String message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_DupeSourceFolder, (Object)sourcePath.toString(), (Object)("source." + sourceFolder.getDupeLibName()));
            this.prepareError("source." + sourceFolder.getDupeLibName(), sourceFolder.getToken(), message, -1, this.fSrcLibSeverity, "");
        }
        Iterator iter = missingOutputEntryErrors.keySet().iterator();
        while (iter.hasNext()) {
            String libName = (String)iter.next();
            MissingOutputEntry errorEntry = (MissingOutputEntry)missingOutputEntryErrors.get(libName);
            String message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingOutputEntry, (Object)errorEntry.get(errorEntry.fSsrcFolders), (Object)("output." + libName));
            this.prepareError("output." + libName, errorEntry.get(errorEntry.fOutputFolders), message, 8195, this.fMissingOutputLibSeverity, "");
        }
    }

    private String join(ProjectFolder[] folders) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < folders.length) {
            String text = folders[i].getPath().toString().trim();
            if (text.length() > 0) {
                result.append(text);
                result.append(',');
            }
            ++i;
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public ArrayList getProblemList() {
        return this.fProblemList;
    }

    class OutputFolder
    extends ProjectFolder {
        private ArrayList fSourceFolders = new ArrayList();
        private boolean fIsLibrary = false;

        public OutputFolder(IPath path) {
            super(path);
        }

        public OutputFolder(IPath path, boolean isLibrary) {
            this(path);
            this.fIsLibrary = isLibrary;
        }

        public void addSourceFolder(SourceFolder sourceFolder) {
            if (!this.fSourceFolders.contains(sourceFolder)) {
                this.fSourceFolders.add(sourceFolder);
            }
        }

        public boolean isLibrary() {
            return this.fIsLibrary;
        }

        public ArrayList getSourceFolders() {
            return this.fSourceFolders;
        }
    }

    class ProjectFolder {
        IPath fPath;
        String fToken;
        ArrayList fLibs = new ArrayList(1);
        String dupeLibName = null;

        public ProjectFolder(IPath path) {
            this.fPath = path;
        }

        public IPath getPath() {
            return this.fPath;
        }

        void setToken(String token) {
            this.fToken = token;
        }

        public String getToken() {
            if (this.fToken == null) {
                return this.fPath.toString();
            }
            return this.fToken;
        }

        public void addLib(String libName) {
            if (this.fLibs.contains(libName)) {
                this.dupeLibName = libName;
            } else {
                this.fLibs.add(libName);
            }
        }

        public ArrayList getLibs() {
            return this.fLibs;
        }

        public String getDupeLibName() {
            return this.dupeLibName;
        }
    }

    class SourceFolder
    extends ProjectFolder {
        OutputFolder fOutputFolder;

        public SourceFolder(IPath path, OutputFolder outputFolder) {
            super(path);
            this.fOutputFolder = outputFolder;
        }

        public OutputFolder getOutputLocation() {
            return this.fOutputFolder;
        }
    }
}

