/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.ide.dialogs.UIResourceFilterDescription;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FilterCopy;
import org.eclipse.ui.internal.ide.dialogs.FilterEditDialog;
import org.eclipse.ui.internal.ide.dialogs.FilterTypeUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ResourceFilterGroup {
    private Button addButton = null;
    private Button removeButton = null;
    private Button upButton = null;
    private Button downButton = null;
    private Button editButton = null;
    private TreeViewer filterView;
    private Filters filters;
    private UIResourceFilterDescription[] initialFilters = new UIResourceFilterDescription[0];
    private LabelProvider labelProvider;
    private Image checkIcon = null;
    private boolean tableViewCellEditorAdequatlyUsable = false;
    private boolean allowReordering = false;
    private Shell shell;
    private IContainer nonExistantResource;
    private IContainer resource = this.nonExistantResource = this.getNonExistantResource();
    Action addSubFilterAction = new AddSubFilterAction();
    private FilterCopyTransfer filterCopyTransfer = new FilterCopyTransfer();

    public ResourceFilterGroup() {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/header_complete.gif");
        if (descriptor != null) {
            this.checkIcon = descriptor.createImage();
        }
    }

    public void setContainer(IContainer res) {
        this.resource = res;
    }

    private IContainer getNonExistantResource() {
        String projectName = "nonExistantProject_";
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        int iteration = 0;
        while (p.exists()) {
            p = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(projectName) + iteration);
            ++iteration;
        }
        return p;
    }

    public Control createContents(Composite parent) {
        Font font = parent.getFont();
        this.shell = parent.getShell();
        if (this.resource == null) {
            Label label = new Label(parent, 0);
            label.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_noResource, null));
            label.setFont(font);
            return label;
        }
        this.filters = this.resource == this.nonExistantResource ? new Filters(this.initialFilters) : new Filters(this.resource);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        Label label = new Label(composite, 0);
        label.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_title, null));
        data = new GridData(4);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.createViewerGroup(composite);
        this.createButtonGroup(composite);
        this.refreshEnablement();
        return composite;
    }

    private void createViewerGroup(Composite parent) {
        this.filterView = new TreeViewer(parent, 67840);
        GridData data = new GridData(4, 4, true, true);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.filterView.getTree().setLayoutData((Object)data);
        this.filterView.setColumnProperties(FilterTypeUtil.columnNames);
        this.filterView.setContentProvider((IContentProvider)new TreeContentProvider());
        this.filterView.setInput((Object)this.filters);
        this.filterView.getTree().setFont(parent.getFont());
        this.filterView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceFilterGroup.this.refreshEnablement();
            }
        });
        TreeColumn column = new TreeColumn(this.filterView.getTree(), 0);
        column.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterMode, null));
        column.setData((Object)FilterTypeUtil.MODE);
        column.setResizable(true);
        column.setMoveable(false);
        column.setWidth(ResourceFilterGroup.getMinimumColumnWidth(column, 130));
        column = new TreeColumn(this.filterView.getTree(), 0);
        column.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterArguments, null));
        column.setData((Object)FilterTypeUtil.ARGUMENTS);
        column.setResizable(true);
        column.setMoveable(true);
        column.setWidth(ResourceFilterGroup.getMinimumColumnWidth(column, 120));
        column = new TreeColumn(this.filterView.getTree(), 0);
        column.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_columnFilterInheritable, null));
        column.setData((Object)FilterTypeUtil.INHERITABLE);
        column.setResizable(true);
        column.setMoveable(false);
        column.setAlignment(0x1000000);
        column.setWidth(ResourceFilterGroup.getMinimumColumnWidth(column, 70));
        this.filterView.getTree().setHeaderVisible(true);
        this.filterView.getTree().showColumn(this.filterView.getTree().getColumn(0));
        this.labelProvider = new LabelProvider();
        this.filterView.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        CellEditor[] editors = new CellEditor[]{new ComboBoxCellEditor((Composite)this.filterView.getTree(), FilterTypeUtil.getFilterNames(false), 8), new ComboBoxCellEditor((Composite)this.filterView.getTree(), FilterTypeUtil.getModes(), 8), new ComboBoxCellEditor((Composite)this.filterView.getTree(), FilterTypeUtil.getTargets(), 8), new CheckboxCellEditor((Composite)this.filterView.getTree()), new TextCellEditor((Composite)this.filterView.getTree())};
        if (this.tableViewCellEditorAdequatlyUsable) {
            this.filterView.setCellEditors(editors);
            this.filterView.setCellModifier((ICellModifier)new CellModifier());
        }
        this.filterView.getTree().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ResourceFilterGroup.this.handleEdit();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        FilterCopyDrag drag = new FilterCopyDrag();
        int ops = 2;
        Transfer[] transfers = new Transfer[]{this.filterCopyTransfer};
        this.filterView.addDragSupport(ops, transfers, (DragSourceListener)drag);
        this.filterView.addDropSupport(ops, transfers, (DropTargetListener)new FilterCopyDrop((Viewer)this.filterView));
        this.filterView.getTree().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                MenuManager mgr = new MenuManager();
                mgr.add((IAction)ResourceFilterGroup.this.addSubFilterAction);
                ResourceFilterGroup.this.filterView.getControl().setMenu(mgr.createContextMenu(ResourceFilterGroup.this.filterView.getControl()));
            }
        });
    }

    private static int getMinimumColumnWidth(TreeColumn column, int hint) {
        FontMetrics fontMetrics;
        Assert.isNotNull((Object)column);
        GC gc = new GC((Drawable)column.getParent());
        try {
            gc.setFont(column.getParent().getFont());
            fontMetrics = gc.getFontMetrics();
        }
        finally {
            gc.dispose();
        }
        return Math.max(hint, fontMetrics.getAverageCharWidth() * column.getText().length());
    }

    private void createButtonGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, false, false);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.addButton = new Button(composite, 8);
        this.addButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_addButtonLabel, null));
        data = new GridData(4, 4, false, false);
        this.addButton.setLayoutData((Object)data);
        ResourceFilterGroup.setButtonDimensionHint(this.addButton);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ResourceFilterGroup.this.handleAdd();
            }
        });
        this.editButton = new Button(composite, 8);
        this.editButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_editButtonLabel, null));
        data = new GridData(4, 4, false, false);
        this.editButton.setLayoutData((Object)data);
        ResourceFilterGroup.setButtonDimensionHint(this.editButton);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ResourceFilterGroup.this.handleEdit();
            }
        });
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_removeButtonLabel, null));
        data = new GridData(4, 4, false, false);
        this.removeButton.setLayoutData((Object)data);
        ResourceFilterGroup.setButtonDimensionHint(this.removeButton);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ResourceFilterGroup.this.handleRemove();
            }
        });
        if (this.allowReordering) {
            this.upButton = new Button(composite, 8);
            this.upButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_upButtonLabel, null));
            data = new GridData(4, 4, false, false);
            this.upButton.setLayoutData((Object)data);
            ResourceFilterGroup.setButtonDimensionHint(this.upButton);
            this.upButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ResourceFilterGroup.this.handleUp();
                }
            });
            this.downButton = new Button(composite, 8);
            this.downButton.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_downButtonLabel, null));
            data = new GridData(4, 4, false, false);
            this.downButton.setLayoutData((Object)data);
            ResourceFilterGroup.setButtonDimensionHint(this.downButton);
            this.downButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ResourceFilterGroup.this.handleDown();
                }
            });
        }
    }

    private void refreshEnablement() {
        this.addButton.setEnabled(true);
        ISelection selection = this.filterView.getSelection();
        IStructuredSelection structuredSelection = null;
        if (selection instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)selection;
        }
        this.removeButton.setEnabled(structuredSelection != null && structuredSelection.size() > 0);
        this.editButton.setEnabled(structuredSelection != null && structuredSelection.size() == 1);
        if (this.upButton != null) {
            this.upButton.setEnabled(structuredSelection != null && structuredSelection.size() > 0 && !this.isFirst(structuredSelection.getFirstElement()));
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(structuredSelection != null && structuredSelection.size() > 0 && !this.isLast(structuredSelection.getFirstElement()));
        }
    }

    private boolean isFirst(Object o) {
        return this.filters.isFirst((FilterCopy)o);
    }

    private boolean isLast(Object o) {
        return this.filters.isLast((FilterCopy)o);
    }

    private void handleAdd() {
        FilterCopy newFilter = new FilterCopy();
        FilterEditDialog dialog = new FilterEditDialog((IResource)this.resource, this.shell, newFilter);
        if (dialog.open() == 0) {
            this.filters.add(newFilter);
            this.filterView.refresh();
        }
    }

    private void handleEdit() {
        ISelection selection = this.filterView.getSelection();
        if (selection instanceof IStructuredSelection) {
            FilterCopy filter = (FilterCopy)((IStructuredSelection)selection).getFirstElement();
            FilterCopy copy = new FilterCopy(filter);
            copy.setParent(filter.getParent());
            FilterEditDialog dialog = new FilterEditDialog((IResource)this.resource, this.shell, copy);
            if (dialog.open() == 0 && copy.hasChanged()) {
                filter.copy(copy);
                this.filterView.refresh();
            }
        }
    }

    private FilterCopy[] getFilterCopySelection() {
        ISelection selection = this.filterView.getSelection();
        IStructuredSelection structuredSelection = null;
        if (selection instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)selection;
            FilterCopy[] tmp = new FilterCopy[structuredSelection.size()];
            System.arraycopy(structuredSelection.toArray(), 0, tmp, 0, tmp.length);
            return tmp;
        }
        return new FilterCopy[0];
    }

    private void handleRemove() {
        ISelection selection = this.filterView.getSelection();
        IStructuredSelection structuredSelection = null;
        if (selection instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)selection;
            Iterator it = structuredSelection.iterator();
            while (it.hasNext()) {
                FilterCopy filter = (FilterCopy)it.next();
                filter.getParent().removeChild(filter);
            }
            this.filterView.refresh();
        }
    }

    private void handleUp() {
        ISelection selection = this.filterView.getSelection();
        if (selection instanceof IStructuredSelection) {
            FilterCopy filter = (FilterCopy)((IStructuredSelection)selection).getFirstElement();
            this.filters.moveUp(filter);
        }
        this.filterView.refresh();
        this.refreshEnablement();
    }

    private void handleDown() {
        ISelection selection = this.filterView.getSelection();
        if (selection instanceof IStructuredSelection) {
            FilterCopy filter = (FilterCopy)((IStructuredSelection)selection).getFirstElement();
            this.filters.moveDown(filter);
        }
        this.filterView.refresh();
        this.refreshEnablement();
    }

    private static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).widthHint = ResourceFilterGroup.getButtonWidthHint(button);
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    private static int getButtonWidthHint(Button button) {
        FontMetrics fontMetrics;
        button.setFont(JFaceResources.getDialogFont());
        GC gc = new GC((Drawable)button);
        try {
            gc.setFont(button.getFont());
            fontMetrics = gc.getFontMetrics();
        }
        finally {
            gc.dispose();
        }
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public void performDefaults() {
        if (this.resource == null) {
            return;
        }
        this.filters = new Filters(this.resource);
        this.filters.removeAll();
        this.filterView.setInput((Object)this.filters);
        this.filterView.refresh();
    }

    public UIResourceFilterDescription[] getFilters() {
        FilterCopy[] newFilters = this.filters.getChildren();
        UIResourceFilterDescription[] result = new UIResourceFilterDescription[newFilters.length];
        int i = 0;
        while (i < newFilters.length) {
            result[i] = newFilters[i];
            ++i;
        }
        return result;
    }

    public void setFilters(IResourceFilterDescription[] filters) {
        this.initialFilters = new UIResourceFilterDescription[filters.length];
        int i = 0;
        while (i < filters.length) {
            this.initialFilters[i] = UIResourceFilterDescription.wrap(filters[i]);
            ++i;
        }
    }

    public void setFilters(UIResourceFilterDescription[] filters) {
        this.initialFilters = filters;
    }

    public boolean performOk() {
        if (this.filters.hasChanged()) {
            if (this.resource == null) {
                return true;
            }
            try {
                if (this.resource != this.nonExistantResource) {
                    IResourceFilterDescription[] oldFilters = this.resource.getFilters();
                    int i = 0;
                    while (i < oldFilters.length) {
                        oldFilters[i].delete(128, (IProgressMonitor)new NullProgressMonitor());
                        ++i;
                    }
                    FilterCopy[] newFilters = this.filters.getChildren();
                    int i2 = 0;
                    while (i2 < newFilters.length) {
                        this.resource.createFilter(newFilters[i2].getType(), newFilters[i2].getFileInfoMatcherDescription(), 128, (IProgressMonitor)new NullProgressMonitor());
                        ++i2;
                    }
                }
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.shell, (String)NLS.bind((String)IDEWorkbenchMessages.InternalError, null), (String)e.getLocalizedMessage(), (IStatus)e.getStatus());
            }
        }
        return true;
    }

    public void dispose() {
        if (this.checkIcon != null) {
            this.checkIcon.dispose();
            this.checkIcon = null;
        }
    }

    class AddSubFilterAction
    extends Action {
        public AddSubFilterAction() {
            this.setText(NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_addSubFilterActionLabel, null));
        }

        public void run() {
            FilterCopy filter;
            ISelection selection = ResourceFilterGroup.this.filterView.getSelection();
            if (selection instanceof IStructuredSelection && (filter = (FilterCopy)((IStructuredSelection)selection).getFirstElement()).getChildrenLimit() > 0) {
                FilterCopy newFilter = new FilterCopy();
                newFilter.setParent(filter);
                FilterEditDialog dialog = new FilterEditDialog((IResource)ResourceFilterGroup.this.resource, ResourceFilterGroup.this.shell, newFilter);
                if (dialog.open() == 0) {
                    filter.addChild(newFilter);
                    ResourceFilterGroup.this.filterView.refresh();
                }
            }
        }

        public boolean isEnabled() {
            ISelection selection = ResourceFilterGroup.this.filterView.getSelection();
            if (selection instanceof IStructuredSelection) {
                FilterCopy filter = (FilterCopy)((IStructuredSelection)selection).getFirstElement();
                return filter.getChildrenLimit() > 0;
            }
            return false;
        }
    }

    class CellModifier
    implements ICellModifier {
        CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            FilterCopy filter = (FilterCopy)element;
            return !property.equals(FilterTypeUtil.ARGUMENTS) || filter.hasStringArguments();
        }

        public Object getValue(Object element, String property) {
            FilterCopy filter = (FilterCopy)element;
            return FilterTypeUtil.getValue(filter, property);
        }

        public void modify(Object element, String property, Object value) {
            FilterCopy filter = (FilterCopy)((TableItem)element).getData();
            FilterTypeUtil.setValue(filter, property, value);
            ResourceFilterGroup.this.filterView.refresh((Object)filter);
        }
    }

    class FilterCopyDrag
    implements DragSourceListener {
        FilterCopyDrag() {
        }

        public void dragFinished(DragSourceEvent event) {
            int cfr_ignored_0 = event.detail;
        }

        public void dragSetData(DragSourceEvent event) {
            if (ResourceFilterGroup.this.filterCopyTransfer.isSupportedType(event.dataType)) {
                event.data = ResourceFilterGroup.this.getFilterCopySelection();
            }
        }

        public void dragStart(DragSourceEvent event) {
            if (ResourceFilterGroup.this.getFilterCopySelection().length == 0) {
                event.doit = false;
            }
        }
    }

    class FilterCopyDrop
    extends ViewerDropAdapter {
        protected FilterCopyDrop(Viewer viewer) {
            super(viewer);
        }

        public boolean performDrop(Object data) {
            int i;
            Object target = this.getCurrentTarget();
            if (target == null) {
                target = ResourceFilterGroup.this.filters;
            }
            FilterCopy[] toDrop = (FilterCopy[])data;
            if (target instanceof FilterCopy) {
                i = 0;
                while (i < toDrop.length) {
                    if (toDrop[i].equals(target) || ((FilterCopy)target).hasParent(toDrop[i])) {
                        return false;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < toDrop.length) {
                if (target instanceof Filters) {
                    ResourceFilterGroup.this.filters.add(toDrop[i]);
                }
                if (target instanceof FilterCopy) {
                    ((FilterCopy)target).addChild(toDrop[i]);
                }
                ResourceFilterGroup.this.filterView.refresh();
                ResourceFilterGroup.this.filterView.reveal((Object)toDrop[i]);
                ++i;
            }
            return true;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            if (ResourceFilterGroup.this.filterCopyTransfer.isSupportedType(transferType)) {
                if (target instanceof FilterCopy) {
                    return ((FilterCopy)target).canAcceptDrop();
                }
                return true;
            }
            return false;
        }
    }

    class FilterCopyTransfer
    extends ByteArrayTransfer {
        private final String MYTYPENAME = "org.eclipse.ui.ide.internal.filterCopy";
        private final int MYTYPEID = FilterCopyTransfer.registerType((String)"org.eclipse.ui.ide.internal.filterCopy");

        private FilterCopyTransfer() {
        }

        public void javaToNative(Object object, TransferData transferData) {
            if (object == null || !(object instanceof FilterCopy[])) {
                return;
            }
            if (this.isSupportedType(transferData)) {
                FilterCopy[] myTypes = (FilterCopy[])object;
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    DataOutputStream writeOut = new DataOutputStream(out);
                    writeOut.writeInt(myTypes.length);
                    int i = 0;
                    while (i < myTypes.length) {
                        writeOut.writeInt(myTypes[i].getSerialNumber());
                        ++i;
                    }
                    byte[] buffer = out.toByteArray();
                    writeOut.close();
                    super.javaToNative((Object)buffer, transferData);
                }
                catch (IOException iOException) {}
            }
        }

        public Object nativeToJava(TransferData transferData) {
            if (this.isSupportedType(transferData)) {
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                if (buffer == null) {
                    return null;
                }
                FilterCopy[] myData = new FilterCopy[]{};
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                    DataInputStream readIn = new DataInputStream(in);
                    int size = readIn.readInt();
                    LinkedList<FilterCopy> droppedFilters = new LinkedList<FilterCopy>();
                    int i = 0;
                    while (i < size) {
                        int serialNumber = readIn.readInt();
                        FilterCopy tmp = ResourceFilterGroup.this.filters.findBySerialNumber(serialNumber);
                        if (tmp != null) {
                            droppedFilters.add(tmp);
                        }
                        ++i;
                    }
                    myData = droppedFilters.toArray(new FilterCopy[0]);
                    readIn.close();
                }
                catch (IOException iOException) {
                    return null;
                }
                return myData;
            }
            return null;
        }

        protected String[] getTypeNames() {
            return new String[]{"org.eclipse.ui.ide.internal.filterCopy"};
        }

        protected int[] getTypeIds() {
            return new int[]{this.MYTYPEID};
        }
    }

    class Filters
    extends FilterCopy {
        boolean changed = false;
        public LinkedList trash = new LinkedList();

        public Filters(IContainer resource) {
            try {
                IResourceFilterDescription[] tmp = resource.getFilters();
                this.children = new LinkedList();
                int i = 0;
                while (i < tmp.length) {
                    this.addChild(new FilterCopy(UIResourceFilterDescription.wrap(tmp[i])));
                    ++i;
                }
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)ResourceFilterGroup.this.shell, (String)NLS.bind((String)IDEWorkbenchMessages.InternalError, null), (String)e.getLocalizedMessage(), (IStatus)e.getStatus());
            }
        }

        public Filters(IResourceFilterDescription[] filters) {
            this.children = new LinkedList();
            if (filters != null) {
                int i = 0;
                while (i < filters.length) {
                    this.addChild(new FilterCopy(UIResourceFilterDescription.wrap(filters[i])));
                    ++i;
                }
            }
        }

        public Filters(UIResourceFilterDescription[] filters) {
            this.children = new LinkedList();
            if (filters != null) {
                int i = 0;
                while (i < filters.length) {
                    this.addChild(new FilterCopy(filters[i]));
                    ++i;
                }
            }
        }

        public void add(FilterCopy newFilter) {
            super.addChild(newFilter);
            this.changed = true;
        }

        public void remove(FilterCopy filter) {
            super.removeChild(filter);
            if (filter.original != null) {
                this.trash.add(filter);
            }
            this.changed = true;
        }

        public void moveUp(UIResourceFilterDescription filter) {
            FilterCopy[] content = this.getChildren();
            int i = 1;
            while (i < content.length) {
                if (content[i] == filter) {
                    FilterCopy tmp = content[i - 1];
                    content[i - 1] = content[i];
                    content[i] = tmp;
                }
                ++i;
            }
            this.children = new LinkedList<FilterCopy>(Arrays.asList(content));
            this.changed = true;
        }

        public void moveDown(UIResourceFilterDescription filter) {
            FilterCopy[] content = this.getChildren();
            int i = 0;
            while (i < content.length - 1) {
                if (content[i] == filter) {
                    FilterCopy tmp = content[i + 1];
                    content[i + 1] = content[i];
                    content[i] = tmp;
                }
                ++i;
            }
            this.children = new LinkedList<FilterCopy>(Arrays.asList(content));
            this.changed = true;
        }

        public int getChildrenLimit() {
            return Integer.MAX_VALUE;
        }

        protected void argumentsChanged() {
            this.changed = true;
        }

        public boolean hasChanged() {
            if (this.changed) {
                return true;
            }
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                FilterCopy filter = (FilterCopy)it.next();
                if (!filter.hasChanged()) continue;
                return true;
            }
            return false;
        }

        public boolean isFirst(FilterCopy o) {
            if (this.children.size() > 0) {
                return this.children.getFirst().equals(o);
            }
            return false;
        }

        public boolean isLast(FilterCopy o) {
            if (this.children.size() > 0) {
                return this.children.getLast().equals(o);
            }
            return false;
        }

        public void removeAll() {
            if (this.children.size() > 0) {
                super.removeAll();
                this.changed = true;
            }
        }
    }

    class LabelProvider
    implements ITableLabelProvider {
        FilterTypeUtil util = new FilterTypeUtil();

        String getColumnID(int index) {
            return (String)ResourceFilterGroup.this.filterView.getColumnProperties()[index];
        }

        public boolean isPartialFilter(Object element) {
            FilterCopy copy = (FilterCopy)element;
            return copy.isUnderAGroupFilter();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (!this.isPartialFilter(element)) {
                Object condition;
                if (this.getColumnID(columnIndex).equals(FilterTypeUtil.ARGUMENTS)) {
                    Object index = FilterTypeUtil.getValue((FilterCopy)element, FilterTypeUtil.TARGET);
                    return this.util.getImage(FilterTypeUtil.TARGET, (Integer)index);
                }
                if (this.getColumnID(columnIndex).equals(FilterTypeUtil.MODE)) {
                    Object index = FilterTypeUtil.getValue((FilterCopy)element, FilterTypeUtil.MODE);
                    return this.util.getImage(FilterTypeUtil.MODE, (Integer)index);
                }
                if (this.getColumnID(columnIndex).equals(FilterTypeUtil.INHERITABLE) && ((Boolean)(condition = FilterTypeUtil.getValue((FilterCopy)element, FilterTypeUtil.INHERITABLE))).booleanValue()) {
                    return ResourceFilterGroup.this.checkIcon;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            FilterCopy filter = (FilterCopy)element;
            String column = this.getColumnID(columnIndex);
            return this.getValue(filter, column);
        }

        private String getValue(FilterCopy filter, String column) {
            String id;
            IFilterMatcherDescriptor descriptor;
            if (column.equals(FilterTypeUtil.ID) && (descriptor = FilterTypeUtil.getDescriptor(id = filter.getId())) != null) {
                return descriptor.getName();
            }
            if (column.equals(FilterTypeUtil.MODE)) {
                if (!this.isPartialFilter(filter)) {
                    if ((filter.getType() & 1) != 0) {
                        return NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_includeOnlyColumn, null);
                    }
                    return NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_excludeAllColumn, null);
                }
                return this.getFilterTypeName(filter);
            }
            if (column.equals(FilterTypeUtil.TARGET)) {
                boolean includeFolders;
                boolean includeFiles = (filter.getType() & 4) != 0;
                boolean bl = includeFolders = (filter.getType() & 8) != 0;
                if (includeFiles && includeFolders) {
                    return NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_filesAndFoldersColumn, null);
                }
                if (includeFiles) {
                    return NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_filesColumn, null);
                }
                if (includeFolders) {
                    return NLS.bind((String)IDEWorkbenchMessages.ResourceFilterPage_foldersColumn, null);
                }
            }
            if (column.equals(FilterTypeUtil.ARGUMENTS)) {
                if (filter.hasStringArguments()) {
                    return filter.getArguments() != null ? filter.getArguments().toString() : "";
                }
                if (filter.getChildrenLimit() > 0 && !filter.isUnderAGroupFilter()) {
                    return "< " + this.getFilterTypeName(filter) + " >";
                }
            }
            return null;
        }

        private String getFilterTypeName(FilterCopy filter) {
            IFilterMatcherDescriptor desc = FilterTypeUtil.getDescriptor(filter.getId());
            if (desc != null) {
                return desc.getName();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof FilterCopy) {
                return ((FilterCopy)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof FilterCopy) {
                if (((FilterCopy)element).getParent() != null) {
                    return ((FilterCopy)element).getParent();
                }
                return ResourceFilterGroup.this.filters;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof FilterCopy) {
                FilterCopy[] children = ((FilterCopy)element).getChildren();
                return children != null && children.length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

