/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import java.util.Iterator;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.annotations.PreDestroy;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.EditorActionBars;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.internal.registry.EditorDescriptor;

public class CompatibilityEditor
extends CompatibilityPart {
    private EditorReference reference;

    @Inject
    CompatibilityEditor(MPart part, EditorReference ref) {
        super(part);
        this.reference = ref;
        if (!part.getTags().contains((Object)"removeOnHide")) {
            part.getTags().add((Object)"removeOnHide");
        }
    }

    protected void createPartControl(IWorkbenchPart legacyPart, Composite parent) {
        IConfigurationElement element;
        String iconURI;
        super.createPartControl(legacyPart, parent);
        EditorDescriptor descriptor = this.reference.getDescriptor();
        if (descriptor != null && (iconURI = (element = descriptor.getConfigurationElement()).getAttribute("icon")) != null) {
            StringBuilder builder = new StringBuilder("platform:/plugin/");
            builder.append(element.getNamespaceIdentifier()).append('/');
            if (iconURI.startsWith("$nl$")) {
                iconURI = iconURI.substring(4);
            }
            builder.append(iconURI);
            this.part.setIconURI(builder.toString());
        }
    }

    void doSave(@Optional IProgressMonitor monitor) {
        super.doSave(monitor);
    }

    public IEditorPart getEditor() {
        return (IEditorPart)this.getPart();
    }

    public WorkbenchPartReference getReference() {
        return this.reference;
    }

    @PreDestroy
    void preDestroy() {
        WorkbenchPartReference reference = this.getReference();
        WorkbenchPage page = (WorkbenchPage)this.wrapped.getSite().getPage();
        Iterator<EditorReference> it = page.getInternalEditorReferences().iterator();
        while (it.hasNext()) {
            IEditorReference ref = it.next();
            if (ref != reference) continue;
            it.remove();
        }
        EditorActionBars bars = (EditorActionBars)((IEditorSite)this.wrapped.getSite()).getActionBars();
        EditorReference.disposeEditorActionBars(bars);
    }
}

