/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import java.util.ArrayList;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationFactory;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MPSCElement;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartDescriptor;
import org.eclipse.e4.ui.model.application.MPartSashContainer;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MPerspective;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.workbench.modeling.EModelService;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IViewLayout;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.e4.compatibility.ModeledFolderLayout;
import org.eclipse.ui.internal.e4.compatibility.ModeledPlaceholderFolderLayout;
import org.eclipse.ui.internal.e4.compatibility.ModeledViewLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeledPageLayout
implements IPageLayout {
    private MApplication application;
    private EModelService modelService;
    WorkbenchPage page;
    private MPerspective perspModel;
    private IPerspectiveDescriptor descriptor;
    private MPartStack editorStack;
    private ArrayList newWizardShortcuts = new ArrayList();
    private ArrayList perspectiveShortcut = new ArrayList();
    private ArrayList showInPart = new ArrayList();
    private ArrayList showViewShortcut = new ArrayList();
    private ArrayList actionSet = new ArrayList();
    boolean createReferences;

    public ModeledPageLayout(MApplication application, EModelService modelService, MPerspective perspModel, IPerspectiveDescriptor descriptor, WorkbenchPage page, boolean createReferences) {
        this.application = application;
        this.modelService = modelService;
        this.page = page;
        this.perspModel = perspModel;
        this.descriptor = descriptor;
        this.createReferences = createReferences;
        MPartSashContainer esc = MApplicationFactory.eINSTANCE.createPartSashContainer();
        this.editorStack = MApplicationFactory.eINSTANCE.createPartStack();
        this.editorStack.getTags().add((Object)"newtablook");
        this.editorStack.getTags().add((Object)"org.eclipse.e4.primaryDataStack");
        this.editorStack.setId("org.eclipse.e4.primaryDataStack");
        esc.getChildren().add((Object)this.editorStack);
        esc.setId(this.getEditorArea());
        perspModel.getChildren().add((Object)esc);
    }

    public MPerspective getModel() {
        return this.perspModel;
    }

    @Override
    public void addActionSet(String actionSetId) {
        this.actionSet.add(actionSetId);
    }

    @Override
    public void addFastView(String viewId) {
    }

    @Override
    public void addFastView(String viewId, float ratio) {
    }

    @Override
    public void addNewWizardShortcut(String id) {
        this.newWizardShortcuts.add(id);
    }

    @Override
    public void addPerspectiveShortcut(String id) {
        this.perspectiveShortcut.add(id);
    }

    @Override
    public void addPlaceholder(String viewId, int relationship, float ratio, String refId) {
        this.insertView(viewId, relationship, ratio, refId, false, true);
    }

    @Override
    public void addShowInPart(String id) {
        this.showInPart.add(id);
    }

    @Override
    public void addShowViewShortcut(String id) {
        this.showViewShortcut.add(id);
    }

    @Override
    public void addStandaloneView(String viewId, boolean showTitle, int relationship, float ratio, String refId) {
        MPart viewModel = this.insertView(viewId, relationship, ratio, refId, true, false);
    }

    @Override
    public void addStandaloneViewPlaceholder(String viewId, int relationship, float ratio, String refId, boolean showTitle) {
        MPart viewModel = this.insertView(viewId, relationship, ratio, refId, false, false);
    }

    @Override
    public void addView(String viewId, int relationship, float ratio, String refId) {
        this.insertView(viewId, relationship, ratio, refId, true, true);
    }

    @Override
    public IFolderLayout createFolder(String folderId, int relationship, float ratio, String refId) {
        MPartStack stack = this.insertStack(folderId, relationship, ratio, refId, true);
        return new ModeledFolderLayout(this, this.application, stack);
    }

    @Override
    public IPlaceholderFolderLayout createPlaceholderFolder(String folderId, int relationship, float ratio, String refId) {
        MPartStack Stack = this.insertStack(folderId, relationship, ratio, refId, false);
        return new ModeledPlaceholderFolderLayout(this, this.application, Stack);
    }

    @Override
    public IPerspectiveDescriptor getDescriptor() {
        return this.descriptor;
    }

    public static String internalGetEditorArea() {
        return "org.eclipse.ui.editorss";
    }

    @Override
    public String getEditorArea() {
        return ModeledPageLayout.internalGetEditorArea();
    }

    @Override
    public int getEditorReuseThreshold() {
        return 0;
    }

    @Override
    public IPlaceholderFolderLayout getFolderForView(String id) {
        MPart view = this.findPart((MUIElement)this.perspModel, id);
        if (view == null) {
            return null;
        }
        MElementContainer stack = view.getParent();
        if (stack == null || !(stack instanceof MPartStack)) {
            return null;
        }
        return new ModeledPlaceholderFolderLayout(this, this.application, (MPartStack)stack);
    }

    @Override
    public IViewLayout getViewLayout(String id) {
        MPart view = this.findPart((MUIElement)this.perspModel, id);
        if (view == null || !(view instanceof MPart)) {
            return null;
        }
        return new ModeledViewLayout(view);
    }

    @Override
    public boolean isEditorAreaVisible() {
        return true;
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public void setEditorAreaVisible(boolean showEditorArea) {
        this.editorStack.setToBeRendered(showEditorArea);
    }

    @Override
    public void setEditorReuseThreshold(int openEditors) {
    }

    @Override
    public void setFixed(boolean isFixed) {
    }

    private static int plRelToSwt(int rel) {
        switch (rel) {
            case 4: {
                return 1024;
            }
            case 1: {
                return 16384;
            }
            case 2: {
                return 131072;
            }
            case 3: {
                return 128;
            }
        }
        return 0;
    }

    public static MPart createViewModel(MApplication application, String id, boolean visible, WorkbenchPage page, boolean createReferences) {
        for (MPartDescriptor descriptor : application.getDescriptors()) {
            if (!descriptor.getId().equals(id)) continue;
            MPart part = (MPart)EcoreUtil.copy((EObject)((EObject)descriptor));
            part.setToBeRendered(visible);
            if (visible && createReferences) {
                page.createViewReferenceForPart(part, id);
            }
            return part;
        }
        throw new RuntimeException("Unknown id: " + id);
    }

    public static MPartStack createStack(String id, boolean visible) {
        MPartStack newStack = MApplicationFactory.eINSTANCE.createPartStack();
        newStack.getTags().add((Object)"newtablook");
        newStack.setId(id);
        newStack.setVisible(visible);
        return newStack;
    }

    private MPart insertView(String viewId, int relationship, float ratio, String refId, boolean visible, boolean withStack) {
        MUIElement refModel = this.findElement((MUIElement)this.perspModel, refId);
        if (refModel instanceof MPart) {
            refModel = refModel.getParent();
        }
        MPart viewModel = ModeledPageLayout.createViewModel(this.application, viewId, visible, this.page, this.createReferences);
        if (withStack) {
            String stackId = String.valueOf(viewId) + "MStack";
            MPartStack stack = this.insertStack(stackId, relationship, ratio, refId, visible);
            stack.getChildren().add((Object)viewModel);
        } else {
            ModeledPageLayout.insert((MUIElement)viewModel, refModel, ModeledPageLayout.plRelToSwt(relationship), ratio);
        }
        return viewModel;
    }

    private MPartStack insertStack(String stackId, int relationship, float ratio, String refId, boolean visible) {
        MUIElement refModel = this.findElement((MUIElement)this.perspModel, refId);
        if (refModel == null) {
            MPartStack stack = ModeledPageLayout.createStack(stackId, visible);
            this.perspModel.getChildren().add((Object)stack);
            return stack;
        }
        MPartStack stack = ModeledPageLayout.createStack(stackId, visible);
        ModeledPageLayout.insert((MUIElement)stack, refModel, ModeledPageLayout.plRelToSwt(relationship), ratio);
        return stack;
    }

    public static void replace(MUIElement relTo, MElementContainer<MUIElement> newParent) {
        if (relTo == null || newParent == null) {
            return;
        }
        MElementContainer parent = relTo.getParent();
        if (parent == null) {
            return;
        }
        EList kids = parent.getChildren();
        if (kids == null) {
            return;
        }
        kids.add(kids.indexOf(relTo), newParent);
        kids.remove(relTo);
    }

    public static void insertParent(MElementContainer<MUIElement> newParent, MUIElement relTo) {
        if (newParent == null || relTo == null) {
            return;
        }
        MPart curParent = (MPart)relTo.getParent();
        if (curParent != null) {
            ModeledPageLayout.replace(relTo, newParent);
        }
        newParent.getChildren().add((Object)relTo);
    }

    public static void insert(MUIElement toInsert, MUIElement relTo, int swtSide, int ratio) {
        String label;
        if (toInsert == null || relTo == null) {
            return;
        }
        MElementContainer relParent = relTo.getParent();
        if (relParent != null) {
            EList children = relParent.getChildren();
            int index = children.indexOf((Object)relTo);
            MPartSashContainer psc = MApplicationFactory.eINSTANCE.createPartSashContainer();
            psc.setContainerData(relTo.getContainerData());
            relParent.getChildren().add(index + 1, (Object)psc);
            switch (swtSide) {
                case 16384: {
                    psc.getChildren().add((Object)((MPSCElement)toInsert));
                    psc.getChildren().add((Object)((MPSCElement)relTo));
                    toInsert.setContainerData("" + ratio);
                    relTo.setContainerData("" + (100 - ratio));
                    psc.setHorizontal(true);
                    break;
                }
                case 131072: {
                    psc.getChildren().add((Object)((MPSCElement)relTo));
                    psc.getChildren().add((Object)((MPSCElement)toInsert));
                    relTo.setContainerData("" + ratio);
                    toInsert.setContainerData("" + (100 - ratio));
                    psc.setHorizontal(true);
                    break;
                }
                case 128: {
                    psc.getChildren().add((Object)((MPSCElement)toInsert));
                    psc.getChildren().add((Object)((MPSCElement)relTo));
                    toInsert.setContainerData("" + ratio);
                    relTo.setContainerData("" + (100 - ratio));
                    psc.setHorizontal(false);
                    break;
                }
                case 1024: {
                    psc.getChildren().add((Object)((MPSCElement)relTo));
                    psc.getChildren().add((Object)((MPSCElement)toInsert));
                    relTo.setContainerData("" + ratio);
                    toInsert.setContainerData("" + (100 - ratio));
                    psc.setHorizontal(false);
                }
            }
            return;
        }
        boolean isStack = true;
        MPartSashContainer newSash = null;
        if (!(swtSide != 128 && swtSide != 1024 || isStack)) {
            newSash = MApplicationFactory.eINSTANCE.createPartSashContainer();
            label = "Vertical Sash[" + toInsert.getId() + "]";
            newSash.setId(label);
            newSash.setHorizontal(false);
        } else if (!(swtSide != 16384 && swtSide != 131072 || isStack)) {
            newSash = MApplicationFactory.eINSTANCE.createPartSashContainer();
            label = "Horizontal Sash[" + toInsert.getId() + "]";
            newSash.setId(label);
            newSash.setHorizontal(true);
        }
        if (newSash != null || relParent != null) {
            // empty if block
        }
        MPartSashContainer vscElement = newSash;
        MElementContainer container = (MElementContainer)vscElement;
        ModeledPageLayout.insertParent((MElementContainer<MUIElement>)container, relTo);
        EList parts = newSash.getChildren();
        int index = parts.indexOf(relTo);
        if (swtSide == 1024 || swtSide == 131072) {
            ++index;
        }
        parts.add(index, toInsert);
    }

    public static void insert(MUIElement toInsert, MUIElement relTo, int swtSide, float ratio) {
        int pct = (int)(ratio * 100.0f);
        ModeledPageLayout.insert(toInsert, relTo, swtSide, pct);
    }

    private MUIElement findElement(MUIElement toSearch, String id) {
        return this.modelService.find(id, toSearch);
    }

    private MPart findPart(MUIElement toSearch, String id) {
        MUIElement element = this.modelService.find(id, toSearch);
        return element instanceof MPart ? (MPart)element : null;
    }

    public ArrayList getNewWizardShortcuts() {
        return this.newWizardShortcuts;
    }

    public ArrayList getShowViewShortcuts() {
        return this.showViewShortcut;
    }

    public ArrayList getPerspectiveShortcuts() {
        return this.perspectiveShortcut;
    }

    public ArrayList getShowInPartIds() {
        return this.showInPart;
    }
}

