/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.PostConstruct;
import org.eclipse.e4.core.di.annotations.PreDestroy;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.model.application.ItemType;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MHandledItem;
import org.eclipse.e4.ui.model.application.MItem;
import org.eclipse.e4.ui.model.application.MMenuItem;
import org.eclipse.e4.ui.model.application.MParameter;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MUILabel;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.eclipse.e4.workbench.ui.renderers.swt.SWTPartRenderer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuItemRenderer
extends SWTPartRenderer {
    @Inject
    Logger logger;
    @Inject
    IEventBroker eventBroker;
    private EventHandler itemUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MMenuItem)) {
                return;
            }
            MMenuItem itemModel = (MMenuItem)event.getProperty("ChangedElement");
            MenuItem menuItem = (MenuItem)itemModel.getWidget();
            if (menuItem == null) {
                return;
            }
            String attName = (String)event.getProperty("AttName");
            if ("label".equals(attName)) {
                MenuItemRenderer.this.setItemText(itemModel, menuItem);
            } else if ("iconURI".equals(attName)) {
                menuItem.setImage(MenuItemRenderer.this.getImage((MUILabel)itemModel));
            }
        }
    };
    private EventHandler selectionUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MMenuItem)) {
                return;
            }
            MMenuItem itemModel = (MMenuItem)event.getProperty("ChangedElement");
            MenuItem menuItem = (MenuItem)itemModel.getWidget();
            if (menuItem != null) {
                menuItem.setSelection(itemModel.isSelected());
            }
        }
    };

    @PostConstruct
    public void init() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/UILabel"), this.itemUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/Item", (String)"selected"), this.selectionUpdater);
    }

    @PreDestroy
    public void contextDisposed() {
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.selectionUpdater);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MMenuItem) || !(parent instanceof Menu)) {
            return null;
        }
        MMenuItem itemModel = (MMenuItem)element;
        Menu parentMenu = (Menu)parent;
        int addIndex = this.calcVisibleIndex(element);
        if (itemModel.getType() == ItemType.SEPARATOR) {
            return new MenuItem(parentMenu, 2, addIndex);
        }
        int flags = 0;
        if (itemModel.getChildren().size() > 0) {
            flags = 64;
        } else if (itemModel.getType() == ItemType.PUSH) {
            flags = 8;
        } else if (itemModel.getType() == ItemType.CHECK) {
            flags = 32;
        } else if (itemModel.getType() == ItemType.RADIO) {
            flags = 16;
        }
        MenuItem newItem = new MenuItem((Menu)parent, flags, addIndex);
        this.setItemText(itemModel, newItem);
        newItem.setImage(this.getImage((MUILabel)itemModel));
        newItem.setEnabled(itemModel.isEnabled());
        return newItem;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    private void setItemText(MMenuItem model, MenuItem item) {
        String text = model.getLabel();
        if (model instanceof MHandledItem) {
            TriggerSequence sequence;
            MHandledItem handledItem = (MHandledItem)model;
            IEclipseContext context = this.getContext((MUIElement)model);
            EBindingService bs = (EBindingService)context.get(EBindingService.class.getName());
            ParameterizedCommand cmd = handledItem.getWbCommand();
            if (cmd == null) {
                cmd = this.generateParameterizedCommand(handledItem, context);
            }
            if ((sequence = bs.getBestSequenceFor(handledItem.getWbCommand())) != null) {
                text = String.valueOf(text) + '\t' + sequence.format();
            }
            item.setText(text);
        } else {
            if (text == null) {
                text = "";
            }
            item.setText(text);
        }
    }

    @Override
    public void hookControllerLogic(MUIElement me) {
        MItem item;
        if (me instanceof MItem && ((item = (MItem)me).getType() == ItemType.CHECK || item.getType() == ItemType.RADIO)) {
            MenuItem ti = (MenuItem)me.getWidget();
            ti.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    item.setSelected(((MenuItem)e.widget).getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    item.setSelected(((MenuItem)e.widget).getSelection());
                }
            });
        }
        if (me instanceof MContribution && ((MContribution)me).getURI() != null) {
            item = (MMenuItem)me;
            final MContribution contrib = (MContribution)me;
            final IEclipseContext lclContext = this.getContext(me);
            MenuItem mi = (MenuItem)me.getWidget();
            mi.addSelectionListener(new SelectionListener((MMenuItem)item){
                private final /* synthetic */ MMenuItem val$item;
                {
                    this.val$item = mMenuItem;
                }

                public void widgetSelected(SelectionEvent e) {
                    block5: {
                        if (contrib.getObject() == null) {
                            IContributionFactory cf = (IContributionFactory)lclContext.get(IContributionFactory.class.getName());
                            contrib.setObject(cf.create(contrib.getURI(), lclContext));
                        }
                        try {
                            lclContext.set(MItem.class.getName(), (Object)this.val$item);
                            ContextInjectionFactory.invoke((Object)contrib.getObject(), (String)"execute", (IEclipseContext)lclContext);
                            lclContext.remove(MItem.class.getName());
                        }
                        catch (InvocationTargetException e1) {
                            if (MenuItemRenderer.this.logger != null) {
                                MenuItemRenderer.this.logger.error((Throwable)e1);
                            }
                        }
                        catch (InjectionException e1) {
                            if (MenuItemRenderer.this.logger == null) break block5;
                            MenuItemRenderer.this.logger.error((Throwable)e1);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else if (me instanceof MHandledItem) {
            item = (MHandledItem)me;
            final IEclipseContext lclContext = this.getContext(me);
            MenuItem mi = (MenuItem)me.getWidget();
            mi.addSelectionListener(new SelectionListener((MHandledItem)item){
                private final /* synthetic */ MHandledItem val$item;
                {
                    this.val$item = mHandledItem;
                }

                public void widgetSelected(SelectionEvent e) {
                    EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class.getName());
                    ParameterizedCommand cmd = this.val$item.getWbCommand();
                    if (cmd == null) {
                        cmd = MenuItemRenderer.this.generateParameterizedCommand(this.val$item, lclContext);
                    }
                    lclContext.set(MItem.class.getName(), (Object)this.val$item);
                    service.executeHandler(cmd);
                    lclContext.remove(MItem.class.getName());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    public Object getUIContainer(MUIElement element) {
        if (!(element instanceof MMenuItem)) {
            return null;
        }
        if (!(element.getParent().getWidget() instanceof MenuItem)) {
            return null;
        }
        MenuItem mi = (MenuItem)element.getParent().getWidget();
        if (mi.getMenu() == null) {
            mi.setMenu(new Menu(mi));
        }
        return mi.getMenu();
    }

    private ParameterizedCommand generateParameterizedCommand(MHandledItem item, IEclipseContext lclContext) {
        ECommandService cmdService = (ECommandService)lclContext.get(ECommandService.class.getName());
        HashMap<String, String> parameters = null;
        EList modelParms = item.getParameters();
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getTag(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = cmdService.createCommand(item.getCommand().getId(), parameters);
        item.setWbCommand(cmd);
        return cmd;
    }
}

