/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class TrimmedPartLayout
extends Layout {
    public Composite top;
    public Composite bottom;
    public Composite left;
    public Composite right;
    public Composite clientArea;

    public TrimmedPartLayout(Composite parent) {
        this.clientArea = new Composite(parent, 0);
        this.clientArea.setLayout((Layout)new FillLayout());
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(-1, -1);
    }

    protected void layout(Composite composite, boolean flushCache) {
        composite.setRedraw(false);
        try {
            Rectangle newBounds;
            Rectangle ca = composite.getClientArea();
            Rectangle caRect = new Rectangle(ca.x, ca.y, ca.width, ca.height);
            if (this.top != null) {
                Point topSize = this.top.computeSize(caRect.width, -1, true);
                caRect.y += topSize.y;
                caRect.height -= topSize.y;
                newBounds = new Rectangle(ca.x, ca.y, caRect.width, topSize.y);
                if (!newBounds.equals((Object)this.top.getBounds())) {
                    this.top.setBounds(newBounds);
                }
            }
            if (this.bottom != null) {
                Point bottomSize = this.bottom.computeSize(caRect.width, -1, true);
                caRect.height -= bottomSize.y;
                newBounds = new Rectangle(caRect.x, caRect.y + caRect.height, caRect.width, bottomSize.y);
                if (!newBounds.equals((Object)this.bottom.getBounds())) {
                    this.bottom.setBounds(newBounds);
                }
            }
            if (this.left != null) {
                Point leftSize = this.left.computeSize(-1, caRect.height, true);
                caRect.x += leftSize.x;
                caRect.width -= leftSize.x;
                newBounds = new Rectangle(caRect.x - leftSize.x, caRect.y, leftSize.x, caRect.height);
                if (!newBounds.equals((Object)this.left.getBounds())) {
                    this.left.setBounds(newBounds);
                }
            }
            if (this.right != null) {
                Point rightSize = this.right.computeSize(-1, caRect.height, true);
                caRect.width -= rightSize.x;
                newBounds = new Rectangle(caRect.x + caRect.width, caRect.y, rightSize.x, caRect.height);
                if (!newBounds.equals((Object)this.right.getBounds())) {
                    this.right.setBounds(newBounds);
                }
            }
            if (!caRect.equals((Object)this.clientArea.getBounds())) {
                this.clientArea.setBounds(caRect);
            }
        }
        finally {
            composite.setRedraw(true);
        }
    }

    public Composite getTrimComposite(Composite parent, int side) {
        if (side == 128) {
            if (this.top == null) {
                this.top = new Composite(parent, 0);
                this.top.setLayout((Layout)new RowLayout(256));
            }
            return this.top;
        }
        if (side == 1024) {
            if (this.bottom == null) {
                this.bottom = new Composite(parent, 0);
                this.bottom.setLayout((Layout)new RowLayout(256));
            }
            return this.bottom;
        }
        if (side == 16384) {
            if (this.left == null) {
                this.left = new Composite(parent, 0);
                this.left.setLayout((Layout)new RowLayout(512));
            }
            return this.left;
        }
        if (side == 131072) {
            if (this.right == null) {
                this.right = new Composite(parent, 0);
                this.right.setLayout((Layout)new RowLayout(512));
            }
            return this.right;
        }
        return null;
    }
}

