/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.Comparator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.breakpoints.provisional.IBreakpointContainer;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.views.DebugModelPresentationContext;

public class ElementComparator
implements Comparator {
    private static final String SPACE = " ";
    protected DebugModelPresentationContext fContext;
    static /* synthetic */ Class class$0;

    public ElementComparator(IPresentationContext context) {
        if (context instanceof DebugModelPresentationContext) {
            this.fContext = (DebugModelPresentationContext)context;
        }
    }

    public int compare(Object arg0, Object arg1) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IBreakpoint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBreakpoint bp0 = (IBreakpoint)DebugPlugin.getAdapter((Object)arg0, (Class)clazz);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.debug.core.model.IBreakpoint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBreakpoint bp1 = (IBreakpoint)DebugPlugin.getAdapter((Object)arg1, (Class)clazz2);
        if (bp0 != null && bp1 != null) {
            return this.compare(bp0, bp1);
        }
        if (arg0 instanceof IBreakpointContainer && arg1 instanceof IBreakpointContainer) {
            return this.compare((IBreakpointContainer)arg0, (IBreakpointContainer)arg1);
        }
        return -1;
    }

    private int compare(IBreakpointContainer c1, IBreakpointContainer c2) {
        if (this.fContext != null) {
            String name1 = this.fContext.getModelPresentation().getText(c1);
            String name2 = this.fContext.getModelPresentation().getText(c2);
            return name1.compareTo(name2);
        }
        return -1;
    }

    private int compare(IBreakpoint b1, IBreakpoint b2) {
        int result;
        String text1 = "";
        String text2 = "";
        text1 = String.valueOf(text1) + b1.getModelIdentifier();
        text2 = String.valueOf(text2) + b2.getModelIdentifier();
        IMarker marker1 = b1.getMarker();
        IMarker marker2 = b2.getMarker();
        try {
            if (marker1.exists() && marker2.exists()) {
                text1 = String.valueOf(text1) + SPACE + marker1.getType();
                text2 = String.valueOf(text2) + SPACE + marker2.getType();
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        if ((result = text1.compareTo(text2)) != 0) {
            return result;
        }
        if (this.fContext != null) {
            String name1 = this.fContext.getModelPresentation().getText(b1);
            String name2 = this.fContext.getModelPresentation().getText(b2);
            boolean lineBreakpoint = false;
            try {
                lineBreakpoint = marker1.isSubtypeOf(IBreakpoint.LINE_BREAKPOINT_MARKER);
            }
            catch (CoreException coreException) {}
            if (lineBreakpoint) {
                return this.compareLineBreakpoints(b1, b2, name1, name2);
            }
            return name1.compareTo(name2);
        }
        return result;
    }

    private int compareLineBreakpoints(IBreakpoint b1, IBreakpoint b2, String name1, String name2) {
        String upToColon1;
        int colon2;
        int colon1 = name1.indexOf(58);
        if (colon1 != -1 && (colon2 = name2.indexOf(58)) != -1 && name2.startsWith(upToColon1 = name1.substring(0, colon1))) {
            int l1 = 0;
            int l2 = 0;
            try {
                l1 = ((ILineBreakpoint)b1).getLineNumber();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            try {
                l2 = ((ILineBreakpoint)b2).getLineNumber();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            return l1 - l2;
        }
        return name1.compareTo(name2);
    }
}

