/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class CachedCheckboxTreeViewer
extends ContainerCheckedTreeViewer {
    private Set checkState = new HashSet();

    protected CachedCheckboxTreeViewer(Tree tree) {
        super(tree);
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CachedCheckboxTreeViewer.this.updateCheckState(event.getElement(), event.getChecked());
            }
        });
        this.setUseHashlookup(true);
    }

    protected void updateCheckState(Object element, boolean state) {
        if (state) {
            if (this.checkState == null) {
                this.checkState = new HashSet();
            }
            ITreeContentProvider contentProvider = null;
            if (this.getContentProvider() instanceof ITreeContentProvider) {
                contentProvider = (ITreeContentProvider)this.getContentProvider();
            }
            if (contentProvider != null) {
                Object[] children = contentProvider.getChildren(element);
                if (children != null && children.length > 0) {
                    int i = 0;
                    while (i < children.length) {
                        this.updateCheckState(children[i], state);
                        ++i;
                    }
                } else {
                    this.checkState.add(element);
                }
            } else {
                this.checkState.add(element);
            }
        } else if (this.checkState != null) {
            Object[] children;
            ITreeContentProvider contentProvider = null;
            if (this.getContentProvider() instanceof ITreeContentProvider) {
                contentProvider = (ITreeContentProvider)this.getContentProvider();
            }
            if (contentProvider != null && (children = contentProvider.getChildren(element)).length > 0) {
                int i = 0;
                while (i < children.length) {
                    this.updateCheckState(children[i], state);
                    ++i;
                }
            }
            this.checkState.remove(element);
        }
    }

    public void restoreLeafCheckState() {
        if (this.checkState == null) {
            return;
        }
        this.getTree().setRedraw(false);
        super.setCheckedElements(new Object[0]);
        this.setGrayedElements(new Object[0]);
        Iterator iter = this.checkState.iterator();
        Object element = null;
        if (iter.hasNext()) {
            this.expandAll();
        }
        while (iter.hasNext()) {
            element = iter.next();
            super.setChecked(element, true);
        }
        this.getTree().setRedraw(true);
    }

    public Object[] getCheckedLeafElements() {
        if (this.checkState == null) {
            return new Object[0];
        }
        return this.checkState.toArray(new Object[this.checkState.size()]);
    }

    public int getCheckedLeafCount() {
        if (this.checkState == null) {
            return 0;
        }
        return this.checkState.size();
    }

    public boolean setChecked(Object element, boolean state) {
        this.updateCheckState(element, state);
        return super.setChecked(element, state);
    }

    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        if (this.checkState == null) {
            this.checkState = new HashSet();
        } else {
            this.checkState.clear();
        }
        ITreeContentProvider contentProvider = null;
        if (this.getContentProvider() instanceof ITreeContentProvider) {
            contentProvider = (ITreeContentProvider)this.getContentProvider();
        }
        int i = 0;
        while (i < elements.length) {
            Object[] children;
            Object[] objectArray = children = contentProvider != null ? contentProvider.getChildren(elements[i]) : null;
            if (!(this.getGrayed(elements[i]) || children != null && children.length != 0 || this.checkState.contains(elements[i]))) {
                this.checkState.add(elements[i]);
            }
            ++i;
        }
    }

    public void setAllChecked(boolean state) {
        block8: {
            block7: {
                super.setAllChecked(state);
                if (!state) break block7;
                Object[] visible = this.getFilteredChildren(this.getRoot());
                if (this.checkState == null) {
                    this.checkState = new HashSet();
                }
                ITreeContentProvider contentProvider = null;
                if (this.getContentProvider() instanceof ITreeContentProvider) {
                    contentProvider = (ITreeContentProvider)this.getContentProvider();
                }
                if (contentProvider == null) {
                    int i = 0;
                    while (i < visible.length) {
                        this.checkState.add(visible[i]);
                        ++i;
                    }
                } else {
                    HashSet toCheck = new HashSet();
                    int i = 0;
                    while (i < visible.length) {
                        this.addFilteredChildren(visible[i], contentProvider, toCheck);
                        ++i;
                    }
                    this.checkState.addAll(toCheck);
                }
                break block8;
            }
            if (this.checkState == null) break block8;
            Object[] visible = this.filter(this.checkState.toArray());
            int i = 0;
            while (i < visible.length) {
                this.checkState.remove(visible[i]);
                ++i;
            }
        }
    }

    private void addFilteredChildren(Object element, ITreeContentProvider contentProvider, Collection result) {
        if (!contentProvider.hasChildren(element)) {
            result.add(element);
        } else {
            Object[] visibleChildren = this.getFilteredChildren(element);
            int i = 0;
            while (i < visibleChildren.length) {
                this.addFilteredChildren(visibleChildren[i], contentProvider, result);
                ++i;
            }
        }
    }
}

