/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional;

import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.builder.TypeScope;
import org.eclipse.pde.api.tools.internal.descriptors.ComponentDescriptorImpl;
import org.eclipse.pde.api.tools.internal.descriptors.PackageDescriptorImpl;
import org.eclipse.pde.api.tools.internal.model.CompositeApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.ReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.util.Signatures;

public class Factory {
    public static IComponentDescriptor componentDescriptor(String componentid) {
        return new ComponentDescriptorImpl(componentid, null);
    }

    public static IComponentDescriptor componentDescriptor(String componentid, String version) {
        return new ComponentDescriptorImpl(componentid, version);
    }

    public static IPackageDescriptor packageDescriptor(String packageName) {
        return new PackageDescriptorImpl(packageName);
    }

    public static IReferenceTypeDescriptor typeDescriptor(String fullyQualifiedName) {
        String packageName = Signatures.getPackageName(fullyQualifiedName);
        String typeName = Signatures.getTypeName(fullyQualifiedName);
        return Factory.packageDescriptor(packageName).getType(typeName);
    }

    public static IMethodDescriptor methodDescriptor(String typename, String name, String signature) {
        IReferenceTypeDescriptor type = Factory.typeDescriptor(typename);
        return type.getMethod(name, signature);
    }

    public static IFieldDescriptor fieldDescriptor(String typename, String name) {
        IReferenceTypeDescriptor type = Factory.typeDescriptor(typename);
        return type.getField(name);
    }

    public static IReferenceDescriptor referenceDescriptor(IComponentDescriptor origincomponent, IMemberDescriptor originmember, int line, IComponentDescriptor targetcomponent, IMemberDescriptor targetmember, int kind, int flags, int visibility) {
        return new ReferenceDescriptor(origincomponent, originmember, line, targetcomponent, targetmember, kind, flags, visibility);
    }

    public static IApiTypeContainer newScope(IApiComponent[] components) throws CoreException {
        LinkedList<IApiComponent> compList = new LinkedList<IApiComponent>();
        int i = 0;
        while (i < components.length) {
            compList.add(components[i]);
            ++i;
        }
        CompositeApiTypeContainer scope = new CompositeApiTypeContainer(components[0].getBaseline(), compList);
        return scope;
    }

    public static IApiTypeContainer newTypeScope(IApiComponent component, IReferenceTypeDescriptor[] types) {
        return new TypeScope(component, types);
    }
}

