/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchReporter;
import org.eclipse.pde.api.tools.internal.provisional.search.IMetadata;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.SkippedComponent;
import org.eclipse.pde.api.tools.internal.search.XmlReferenceDescriptorWriter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSearchReporter
implements IApiSearchReporter {
    private String fLocation = null;
    private DocumentBuilder parser = null;
    private boolean debug = false;

    public XmlSearchReporter(String location, boolean debug) {
        this.fLocation = location;
        this.debug = debug;
        try {
            this.parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.parser.setErrorHandler(new DefaultHandler());
        }
        catch (FactoryConfigurationError fce) {
            ApiPlugin.log(fce);
        }
        catch (ParserConfigurationException pce) {
            ApiPlugin.log(pce);
        }
    }

    public void reportResults(IApiElement element, IReference[] references) {
        if (this.fLocation != null) {
            XmlReferenceDescriptorWriter writer = new XmlReferenceDescriptorWriter(this.fLocation);
            ArrayList<IReferenceDescriptor> descriptors = new ArrayList<IReferenceDescriptor>(references.length + 1);
            int i = 0;
            while (i < references.length) {
                Reference reference = (Reference)references[i];
                try {
                    descriptors.add(reference.getReferenceDescriptor());
                }
                catch (CoreException e) {
                    ApiPlugin.log(e.getStatus());
                }
                ++i;
            }
            writer.writeReferences(descriptors.toArray(new IReferenceDescriptor[descriptors.size()]));
        }
    }

    String getId(IApiComponent component) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(component.getSymbolicName()).append(" ").append('(').append(component.getVersion()).append(')');
        return buffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public void reportNotSearched(IApiElement[] elements) {
        block28: {
            if (elements == null) {
                return;
            }
            writer = null;
            try {
                if (this.debug) {
                    System.out.println("Writing file for projects that were not searched...");
                }
                if (!(rootfile = new File(this.fLocation)).exists()) {
                    rootfile.mkdirs();
                }
                if (!(file = new File(rootfile, "not_searched.xml")).exists()) {
                    file.createNewFile();
                }
                doc = Util.newDocument();
                root = doc.createElement("components");
                doc.appendChild(root);
                comp = null;
                component = null;
                i = 0;
                while (i < elements.length) {
                    component = (SkippedComponent)elements[i];
                    comp = doc.createElement("component");
                    comp.setAttribute("id", component.getComponentId());
                    comp.setAttribute("version", component.getVersion());
                    comp.setAttribute("details", component.getErrorDetails());
                    root.appendChild(comp);
                    ++i;
                }
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(Util.serializeDocument(doc));
                writer.flush();
            }
            catch (FileNotFoundException v0) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block28;
                }
                catch (IOException v1) {}
                break block28;
            }
            catch (IOException v2) {
                ** try [egrp 3[TRYBLOCK] [7 : 241->242)] { 
lbl45:
                // 1 sources

                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block28;
                }
                catch (IOException v3) {}
                break block28;
            }
            catch (CoreException v4) {
                ** try [egrp 5[TRYBLOCK] [8 : 257->258)] { 
lbl-1000:
                // 3 sources

                {
                    catch (Throwable var10_10) {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException v5) {}
                        throw var10_10;
                    }
                }
lbl61:
                // 1 sources

                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block28;
                }
                catch (IOException v6) {}
                break block28;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException v7) {}
        }
    }

    public void reportMetadata(IMetadata data) {
        if (data == null) {
            return;
        }
        try {
            File file;
            File rootfile;
            if (this.debug) {
                System.out.println("Writing file for projects that were not searched...");
            }
            if (!(rootfile = new File(this.fLocation)).exists()) {
                rootfile.mkdirs();
            }
            if (!(file = new File(rootfile, "meta.xml")).exists()) {
                file.createNewFile();
            }
            data.serializeToFile(file);
        }
        catch (FileNotFoundException fnfe) {
            ApiPlugin.log(fnfe);
        }
        catch (IOException ioe) {
            ApiPlugin.log(ioe);
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
        }
    }
}

